// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

//VectorTransFunc.m                                        
// this code applies the object TransFuncion to a vector

#import "VectorTransFunc.h"
#import <math.h>

@implementation VectorTransFunc

- createEnd
{
   [super createEnd];

   return self;
}

- setTransFunc: f
{
  transFunc=f;
  return self;
}

- from: (float *) v1 to: (float *) v2 itemNumber: (int) n
{
   int i;
   for (i=0;i<n;i++) v2[i]=[transFunc transform: v1[i]];
   return self;
}

- from: v1 to: v2
{
   int i, n;
   n=[v1 getNumberOfElements];
   for (i=0;i<n;i++) [v2 P: i setFrom: [transFunc transform: [v1 P: i] ]];
   return self;
}

- from: v1 toDerivative: v2
{
   int i, n;
   n=[v1 getNumberOfElements];
   for (i=0;i<n;i++) [v2 P: i setFrom:
                              [transFunc firstDerivativeAt: [v1 P: i] ]];
   return self;
}

- from1: v1 to1: v2
{
   int i, n;
   n=[v1 getNumberOfElements];
   for (i=1;i<n;i++) [v2 P: i setFrom: [transFunc transform: [v1 P: i] ]];
   return self;
}

- from1: v1 to1Derivative: v2
{
   int i, n;
   n=[v1 getNumberOfElements];
   for (i=1;i<n;i++) [v2 P: i setFrom:
                              [transFunc firstDerivativeAt: [v1 P: i] ]];
   return self;
}

@end
                                     
