// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************
//
// in apps we have to prepare a XXXInterface.h file for each type of agent:
// in the ct-hayek application of bp-ct this file corresponds
// to the files ConsumerInterface.h and ProducerInterface.h
//
// **********************************

// SpecificInterface.h 

#import "Interface.h" // see headers imported by Interface.h

@interface SpecificInterface: Interface
{

// we need a variable nX for each input and a variable nX_out and nX_target
// for each output
// X is the conventional name that we use to identify the specific input
// or output; the use of this kind of variables is explained in the
// related .m file

// +++++++ start
  float  nL1, nL2, nOR_out, nOR_target, nXOR_out, nXOR_target;

  // CT inputs and outputs
  int v1, v2, or, xor;
// +++++++ end

}

  // the following methods are strictly related to the meaning the problem
  // data to which we are applying our neural network have

  // so, for each application, we have to modify them if we want to display
  // agent data or operate with them in a CT way

// +++++++ start
- (float )getL1;
          // L1 is the first logical input in the OR XOR application
- (float )getL2;
          // L2 is the second logical input in the OR XOR application
- (float )getOR_out;
          // OR_out is the first output in the OR XOR application
- (float )getOR_target;
          // OR_target is the first target in the OR XOR application
- (float )getXOR_out;
          // XOR_out is the second output in the OR XOR application
- (float )getXOR_target;
          // XOR_target is the second target in the OR XOR application
// +++++++ end

  // the following methods override those of Interface.h, which
  // are left void in Interface.m

- initialize;
- setCT_Inputs;
- setCT_Targets;

@end
