// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// DataWarehouse.h 
// this is the portion of the code where the data related to
// the neural network structure are stored; each has the address
// of its instance of DataWarehouse

#import <objectbase/SwarmObject.h>
#import <simtools.h>  // necessary to invoke InFile protocol
#import <random.h>
#import "Matrix.h"

@interface DataWarehouse: SwarmObject
{
  int inputNodeNumber, inputNodeNumber1,
      hiddenNodeNumber, hiddenNodeNumber1, outputNodeNumber,
      patternNumberInVerificationSet, patternNumberInTrainingSet,
      epochNumberInEachTrainingCycle;
  float weightRange, eps, alpha;
  int usingRandomOrderInLearning,
      longTermLearningInCT_OnlyWithCompleteTrainingSet,
      useOutputsAsTargetsInCT_RelearningScheme;

  Matrix * outputTrainingMatrix,     * targetTrainingMatrix,
         * dataTrainingMatrix, 
         * outputVerificationMatrix, * targetVerificationMatrix, 
         * dataVerificationMatrix,
         * minmax,
         * wih, * dwih, * who, * dwho,
         * inputLayer, * hiddenLayer, * outputLayer, * deltaOut,
         * hiddenLayerTransFuncDerivatives, * outputLayerTransFuncDerivatives;
  char * verificationFileName, * trainingFileName, * minmaxFileName,
       * initValuesFileName;
  id <InFile> verificationSet;
  id <InFile> trainingSet;
  id <InFile> minmaxSet;
  id <InFile> initValues;

}

- createEnd;

- setVerificationFileName: (char *) fn1   andTrainingFileName: (char *) fn2
            andMinmaxName: (char *) fn3 andInitValuesFileName: (char *) fn4;

- setInputNodeNumber: (int) ni andHiddenNodeNumber: (int) nh
                               andOutputNodeNumber: (int) no
                               andPatternNumberInVerificationSet: (int) pn1
                               andPatternNumberInTrainingSet:     (int) pn2
                               andEpochNumberInEachTrainingCycle: (int) cn;

- setBackPropagationParametersWeightRange: (float) wr eps: (float) e
                    alpha: (float) a
                    andWithOrderInLearning: (int) o
                    andLongTermLearningInCT: (int) lt
                    andUseOutputsAsTargetsInCT: (int) uo;

- readWeightsFromFileOfAgentNumber: (int) n;


-(int) getInputNodeNumber;
-(int) getHiddenNodeNumber;
-(int) getOutputNodeNumber;
-(int) getPatternNumberInVerificationSet;
-(int) getPatternNumberInTrainingSet;
-(int) getEpochNumberInEachTrainingCycle;

- getOutputVerificationMatrix;
- getTargetVerificationMatrix;
- getDataVerificationMatrix;
- getOutputTrainingMatrix;
- getTargetTrainingMatrix;
- getDataTrainingMatrix;
- getMinmax;

- getInputLayer;
- getHiddenLayer;
- getHiddenLayerTransFuncDerivatives;
- getOutputLayer;
- getOutputLayerTransFuncDerivatives;
- getDeltaOut;

- getWih;
- getDwih;
- getWho;
- getDwho;

-(float) getEps;
-(float) getAlpha;
-(int)   getRandomOrderInLearning;
-(int)   getLongTermLearningInCT_OnlyWithCompleteTrainingSet;
-(int)   getUseOutputsAsTargetsInCT_RelearningScheme;

@end

