#import "Spring.h"
#import "Species.h"
#import "YoungForest.h"
#import "Tree.h"

#import <random.h>
#import <misc.h>

@implementation Spring

- setWorldSize: (int)aSize
{
  worldSize = aSize;
  return self;
}

- setForest: aForest
{
  forest = aForest;
  return self;
}

- setYoungForest: aYoungForest 
{
  youngForest = aYoungForest;
  return self;
}

- createEndWith: speciesList
{
  int i;

  speciesNumber = [speciesList getCount];

  speciesArray = (id *)xmalloc (speciesNumber * sizeof (id));
  potencyArray = (int *)xmalloc (speciesNumber * sizeof (int));

  for(i = 0; i < speciesNumber; i++)
    speciesArray[i] = [speciesList atOffset: i];

  return self;
}

- step
{
  int i,j,k,aPotencyVal;
  int totalSeeds, choice;
  
  for(i = 0; i < worldSize; i++)
    for(j = 0; j < worldSize; j++)
      {
        if ([youngForest treeAtX: i Y: j])
          continue;
        
        totalSeeds = 0;
        
        for (k = 0; k < speciesNumber; k++)
          {
            aPotencyVal = 
              [speciesArray[k] getPotencyAtX: i Y: j];
            potencyArray[k] = aPotencyVal;
            totalSeeds += aPotencyVal;
          }
        
        if (!totalSeeds)
          continue;
        
        totalSeeds++;
        
        //      choice = [uniformRandom rMax: totalSeeds];
        choice = [uniformIntRand getIntegerWithMin: 0 withMax: totalSeeds - 1];
        
        choice--;
        
        for (k = 0; k < speciesNumber; k++)
          {
            choice -= potencyArray[k];
            
            if (choice < 0)
              {
                [youngForest addTree:
                               
                               [[[[Tree createBegin: [self getZone]]
                                   setX: i Y:j] 
                                  setSpecies: speciesArray[k]] 
                                 createEnd]
                             
                             atX: i Y: j];
                break; 
              }
            
          }
        
        if (choice >= 0)
          {
            printf("Major problem in spring module\n");
            exit(-1);
          }
      }
  
  return self;
}

@end
