#import "Forest.h"
#import "Tree.h"
#import <space.h>
#import <random.h>

@implementation Forest

- setWorldSize: (int)aSize
{
  worldSize = aSize;
  return self;
}

- (int)getWorldSize
{
  return worldSize;
}

- createEnd
{
  treeGrid = 
    [[[Grid2d createBegin: [self getZone]] setSizeX: worldSize Y: worldSize]
     createEnd];
  [treeGrid setOverwriteWarnings: 1];

  treeList = [OrderedSet createBegin: [self getZone]];
  [treeList setIndexFromMemberLoc: offsetof(Tree, listMembership)];
  treeList = [treeList createEnd];

  exitQ = [List create: [self getZone]];

  return self;
}

- getTreeGrid
{
  return treeGrid;
}

- getTreeList
{
  return treeList;
}

- step
{
  [self subclassResponsibility: @selector(step)];
  return self;
}

- treeAtX: (int) xVal Y: (int) yVal
{
  return [treeGrid getObjectAtX: xVal Y: yVal];
}

- addTree: aTree atX: (int) xVal Y: (int) yVal
{
  [treeList addFirst: aTree];
  [treeGrid putObject: aTree atX: xVal Y: yVal];
  return self; 
}

- addTree: aTree
{
  int x,y;

  do {
//    x = [uniformRandom rMax: [treeGrid getSizeX]];
//    y = [uniformRandom rMax: [treeGrid getSizeY]];

   x = [uniformIntRand getIntegerWithMin: 0 withMax: [treeGrid getSizeX] - 1];
   y = [uniformIntRand getIntegerWithMin: 0 withMax: [treeGrid getSizeY] - 1];

  } while([treeGrid getObjectAtX: x Y: y]);

  [aTree setX: x Y: y];

  [self addTree: aTree atX: x Y: y];

  return self;
}

- fireAtX: (int)theX Y: (int)theY
{
  id anObj;

  if ((anObj = [treeGrid getObjectAtX: theX Y: theY]))
    {
      [treeList remove: anObj];
      [treeGrid putObject: nil atX: theX Y: theY];
      [anObj drop];
    }
  
  return self;
}

@end
