// Copyright  1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#import <objectbase/SwarmObject.h>
#import "SortSpace.h"
#import <space.h>

// carriedObject should probably be an id, not a void *.
@interface SortingAnt: SwarmObject
{
  SortSpace *sortSpace;			 // the space of objects
  SortParcel carriedObject;		 // the object I'm carrying
  int x, y;				 // my spatial coordinates
  id <Grid2d> world;		         // my world.
  int worldSize;			 // how big that world is
  Color carryColor, emptyColor;		 // my colour
  id emptyPixmap, carryPixmap;
}

- setX: (int)x Y: (int)y;
- setColors: (Color)c : (Color)c2;
- setPixmaps: cp : ep;
- setWorld: (id <Grid2d>)w Space: (SortSpace *)s;
- createEnd;

// the major antsort action: do 'one timestep'
- step;

// extra display code, to be removed
- drawSelfOn: (id <Raster>)r;

@end
