#import <random.h>
#import "Fish.h"

//----------------------------------------------------------------------
@implementation FishSpecies

// This class routine makes the FishSpecies a singleton by using a static
// to contain the Species instance.

+ getInstance
{
	static id instance;
	if (instance == nil)
	{
		instance = [super create: globalZone];
	}
	return instance;
}

@end

//----------------------------------------------------------------------
@implementation Fish

+createBegin: (id) aZone
{
	id newMe = [super createBegin: aZone];
	return newMe;
}	

-(void) setFoodFactor: (double) d
{
	foodFactor = d;
}

-(void) setEnergyLimit: (double) d
{
	myEnergyLimit = d;
}

-createEnd
{
	return [super createEnd];
}

//----------------------------
-copy: aZone
{
	Fish* newFish;

	newFish = [Fish createBegin: aZone];
	[super copyFStateInto: newFish];
	[newFish setFoodFactor: foodFactor];
	[newFish setEnergyLimit: myEnergyLimit];
	newFish = [newFish createEnd];

	[super copyMStateInto: newFish];

	return newFish;
}

// this Fish model is stationary food

-(void) step
{
	myEnergy -= myConsumption;  // consumption is negative, i.e. we get
	                            // a free lunch every step
	
	if (myEnergy >= myEnergyLimit)
		myEnergy = myEnergyLimit;    // forces a hard energy limit

	if (myEnergy >= myEnergy2Spawn)  // may we spawn?
	{
		int newX, newY;

		// TODO: only one attempt to spawn
		newX = posX + [uniformIntRand getIntegerWithMin: -1 withMax: 1];
		newY = posY + [uniformIntRand getIntegerWithMin: -1 withMax: 1];

		if (newX>=0 && newX<worldXSize 
			&& newY>=0 && newY<worldYSize 
			&& [myWorld getObjectAtX: newX Y: newY] == nil)
		{
			id newFish;
			myEnergy = 0.0;
			newFish = [self copy: globalZone];//[myWorld getZone]];
			
			[newFish setX: newX Y: newY];
			[mySpecies add: newFish];
			[myWorld putObject: newFish atX: newX Y: newY];
		}
	}
}

-(double) getFoodValue
{
	return foodFactor*myEnergy;
}


-(void) dissolve
{
	[myWorld putObject: nil atX: posX Y: posY];
	
	// we let our species determine when to actually remove ourselves
	// from the ActionSchedule
	[mySpecies remove: self];
}

@end
