/* $Id: MNGVideo.h,v 1.15 2001/04/14 12:27:58 ralf Exp $ */

#import <objectbase/SwarmObject.h>
#import <space.h>
#import <collections.h>
#import <png.h>

@interface MNGVideo : SwarmObject
{
  id <String> basename, filename;
  id <Colormap> cmap;
  id <Discrete2d> vgrid, ogrid;
  id ocoll;
  SEL omsg;
  Color **cbuf, **cbuf1, **cbuf2;
  unsigned width, height, mag, fps, n_frames, img_nr;
  unsigned mfac, mc, ncolors, nbits;
  BOOL delta_f;

  png_structp png_ptr;
  png_infop info_ptr;
  png_byte **pngbuf;
  FILE *file_ptr;
}

+create: aZone ColorMap: (id <Colormap>) cm MagFactor: (unsigned) m;
+create: aZone ColorMap: (id <Colormap>) cm MagFactor: (unsigned) m \
   FrameRate: (unsigned) rate NFrames: (int) nf \
   Basename: (unsigned char*) name;
+createBegin: aZone;
-createEnd;
-setBasename: (char*) filebase;
-setWidth: (unsigned) w;
-setHeight: (unsigned) h;
-setColormap: (id <Colormap>) cm;
-setMagnification: (unsigned) mag;
-setFrameRate: (unsigned) fps;
-setNFrames: (unsigned) nf;
-(int)initVideo;
-(void)setValueLayerGrid: (id <Discrete2d>) d MappingM: (int)m C: (int)c;
-(void)setObjectLayerGrid: (id <Discrete2d>) d ObjectCollection: c Message: (SEL)sel;
-(void)takeAFrame;
-(void)drawPointX: (int)x Y: (int)y Color: (Color)c;
-(void)finish;
-(void)drop;

@end

