#import <random.h>
#import "Fish.h"
#import "Shark.h"

//-------------------------------------------------------------------------
@implementation SharkSpecies

+ getInstance
{
	static id instance;
	if (instance == nil)
	{
		instance = [super create: globalZone];
	}
	return instance;
}

@end

//-------------------------------------------------------------------------
@implementation Shark

+createBegin: (id) aZone
{
	Shark *obj = [super createBegin: aZone];
	
	obj->targetX = -1;        // new sharks have no history
	obj->targetY = -1;
	obj->lastSwitchPartner = nil;
	
	return obj;
}	

-createEnd
{
	return [super createEnd];
}

//-----------------
-copy: aZone
{
	Shark* newShark = [Shark createBegin: aZone];
	[super copyFStateInto: newShark];
	newShark = [newShark createEnd];
	
	[super copyMStateInto: newShark];
	return newShark;
}

-(void) step
// this is spaghetti (but FAST), therefore a candidate for redesign:
// targetting, switching protocol etc.
{
	unsigned newX, newY;
	id obj;
	
	myEnergy -= myConsumption;
	if (myEnergy < 0.0)               // starving?
	{
		[mySpecies remove: self];
		myWorld = [myWorld putObject: nil atX: posX Y: posY];
		return;
	}
	
	if (targetX <0 || targetY <0              // disoriented?
		|| (posX==targetX && posY==targetY))  // at target?
	// set new target
	{
		targetX = [uniformIntRand getIntegerWithMin: 0 withMax: worldXSize-1];
		targetY = [uniformIntRand getIntegerWithMin: 0 withMax: worldYSize-1];
		lastSwitchPartner = nil;
	}
	
	// calc new pos
	newX = posX;
	newY = posY;
	if (targetX < posX) --newX;
	else if (targetX > posX) ++newX;
	if (targetY < posY) --newY;
	else if (targetY > posY) ++newY;

	if (posX==newX && posY==newY)             // same target
		return;
	
	// what is there where we want to move to?
	obj = [myWorld getObjectAtX: newX Y: newY];

	// refuse to infinitely exchange position with the same partner
	if (obj != nil && obj == lastSwitchPartner)
		return;

	// Beginning of switching
	// 1. unplug myself 
	// 2. cond. unplug other 
	// 3. cond. plug in other
	// 4. cond. plug in baby
	// 5. plug in myself
	
	[myWorld putObject: nil atX: posX Y: posY];

	if (obj != nil)                       // there is something
	{
		const char *objClass;

		[myWorld putObject: nil atX: newX Y: newY];

		objClass = [[obj class] name];
		if (!strcmp (objClass, "Shark"))  // there is another shark?
		{
			// switch position
			[myWorld putObject: obj atX: posX Y: posY];
			[obj setX: posX Y: posY];
			lastSwitchPartner = obj;
		}
		else
		if (!strcmp (objClass, "Fish"))   // yum
		{
			myEnergy += [obj getFoodValue];
			[obj dissolve];
		}
		else [WarningMessage raiseEvent: 
			"Panic in [Shark step]: obj (%x) is neither Fish nor Shark!\n\
			It's a %s\n", obj, objClass];
	}
	
	if (myEnergy >= myEnergy2Spawn        // shall we spawn?
		&& [myWorld getObjectAtX: posX Y: posY] == nil)
	{
		Shark *shark;
		myEnergy /= 2;
		shark = [self copy: globalZone];  
		[shark setX: posX Y: posY];
		[mySpecies add: shark];
		[myWorld putObject: shark atX: posX Y: posY];
	}
	
	posX = newX;
	posY = newY;
	[myWorld putObject: self atX: newX Y: newY];
}

@end
