// 04-Jan-00: adapted from:
// Template application. Copyright  1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <random/UniformDoubleDist.h>
#import "AquariumSwarm.h"
#import "Species.h"
#import "SetSet.h"
#import "Shark.h"
#import "Fish.h"

//-------------------------------------------------------------------
@implementation AquariumSwarm

+createBegin: (id) aZone 
{
	AquariumSwarm * obj = [super createBegin: aZone];
	id <ProbeMap> probeMap;

	// set start values
	obj->worldXSize = 100;
	obj->worldYSize = 100;
	
	obj->numFish = 200;
	obj->fishConsumption = -0.05; // fish have a free lunch
	obj->fishEnergyLimit = 6.0;
	obj->fishEnergy2Spawn = 3.0;
	obj->fishFoodFactor = 1.0;
	
	obj->numShark = 100;
	obj->sharkConsumption = 0.05;
	obj->sharkEnergy2Spawn = 12.0;
  
	probeMap = [EmptyProbeMap createBegin: aZone];
	[probeMap setProbedClass: [self class]];
	probeMap = [probeMap createEnd];

	[probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "numFish"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "fishConsumption"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "fishEnergyLimit"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "fishEnergy2Spawn"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "fishFoodFactor"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "numShark"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "sharkConsumption"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "sharkEnergy2Spawn"
				    inClass: [self class]]];

	[probeLibrary setProbeMap: probeMap For: [self class]];

	return obj;
}

-  createEnd 
{
	return [super createEnd];
}

//----------------------------------------------------------------------
- (id <Grid2d>) getWorld
{
	return world;
}

- (id <Set>) getFishSet
{
	return [fishes getIndividua];
}

- (id <Set>) getSharkSet
{
	return [sharks getIndividua];
}

- (id <Set>) getAgents
{
	return agents;
}

- buildObjects 
{
	int ctr;
	id randGen = uniformDblRand;
	
	[super buildObjects];

	world = [Grid2d create: [self getZone] 
		setSizeX: worldXSize Y: worldYSize];
	
	[world setOverwriteWarnings: YES];
	
	fishes = [FishSpecies getInstance];
	
	for (ctr=0; ctr<numFish; ctr++)
	{
		int x,y;
		Fish *fish;
		
		x = [uniformIntRand getIntegerWithMin: 0 withMax: worldXSize-1];
		y = [uniformIntRand getIntegerWithMin: 0 withMax: worldYSize-1];
		
		if ([world getObjectAtX: x Y: y] != nil)
		{ --ctr; continue; }
		
		fish = [Fish createBegin: [self getZone]];
		[fish setWorld: world];
		[fish setConsumption: fishConsumption];
		[fish setEnergy: 
			[randGen getDoubleWithMin: 0.0 withMax:fishEnergy2Spawn]];
		[fish setEnergyLimit: fishEnergyLimit];
		[fish setEnergy2Spawn: fishEnergy2Spawn];
		[fish setFoodFactor: fishFoodFactor];
		[fish setSpecies: fishes];
		fish = [fish createEnd];
		[fish setX: x Y: y];

		[fishes add: fish];
		[world putObject: fish atX: x Y: y];
	}
	[fishes update];

	sharks = [SharkSpecies getInstance];
	for (ctr=0; ctr<numShark; ctr++)
	{
		int x,y;
		Shark *shark;
		
		x = [uniformIntRand getIntegerWithMin: 0 withMax: worldXSize-1];
		y = [uniformIntRand getIntegerWithMin: 0 withMax: worldYSize-1];

		if ([world getObjectAtX: x Y: y] != nil)
		{ --ctr; continue; }

		shark = [Shark createBegin: [self getZone]];
		[shark setWorld: world];
		[shark setEnergy: 
			[randGen getDoubleWithMin: 0.0 withMax:sharkEnergy2Spawn]];
		[shark setConsumption: sharkConsumption];
		[shark setEnergy2Spawn: sharkEnergy2Spawn];
		[shark setSpecies: sharks];
		shark = [shark createEnd];
		[shark setX: x Y: y];

		[sharks add: shark];
		[world putObject: shark atX: x Y: y];
	}
	[sharks update];

	agents = [SetSet createBegin: self];
	[agents addSet: [fishes getIndividua]];
	[agents addSet: [sharks getIndividua]];
	agents = [agents createEnd];

	return self;
}

- buildActions 
{
	[super buildActions];

	modelActions = [ActionGroup create: self];

	[[modelActions createActionForEach: [fishes getIndividua]
  		message: M(step)] setDefaultOrder: Randomized];
	[[modelActions createActionForEach: [sharks getIndividua] 
		message: M(step)] setDefaultOrder: Randomized];
	[modelActions createActionTo: fishes message: M(update)];
	[modelActions createActionTo: sharks message: M(update)];

	modelSchedule = [Schedule createBegin: self];
	[modelSchedule setRepeatInterval: 1];
	modelSchedule = [modelSchedule createEnd];
	[modelSchedule at: 0 createAction: modelActions];

	return self;
}

- activateIn:  swarmContext 
{
	[super activateIn: swarmContext];

	[modelSchedule activateIn: self];

	return [self getSwarmActivity];
}

@end
