// 04-Jan-00: adapted from:
// Template application. Copyright  1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <objectbase.h>
#import <objectbase/Swarm.h>
#import <collections.h>
#import <space.h>

@class Species;

@interface AquariumSwarm: Swarm
{
@private
	int worldXSize, worldYSize;
	int numFish;
	double fishConsumption;
	double fishEnergyLimit;
	double fishEnergy2Spawn;
	double fishFoodFactor;
	int numShark;
	double sharkConsumption;
	double sharkEnergy2Spawn;

	id modelActions;
	id modelSchedule;

	id <Grid2d> world;
	Species *fishes, *sharks;
	id agents;
}

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;
- (id <Grid2d>) getWorld;
- (id <Set>) getAgents;
- (id <Set>) getFishSet;
- (id <Set>) getSharkSet;


@end
