// 04-Jan-00: adapted from heatbugs and:
// Template application. Copyright  1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <simtoolsgui/GUISwarm.h>
#import <analysis.h>
#import <space.h>
#import "AquariumSwarm.h"

@interface AquariumObserverSwarm: GUISwarm
{
	int displayFrequency;

	id displayActions;
	id displaySchedule, video;

	AquariumSwarm *observedAquarium;

	id <Colormap> colormap;	            	// allocate colours
	id <ZoomRaster> worldRaster;			// 2d display widget
	id <EZGraph> populationGraph;			// graphing widget
	id <Object2dDisplay> agentDisplay;
}

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;
- (void)debug;

@end
