// $Id: NaSchSingleDemoSwarm.m,v 1.6 2001/01/25 13:40:27 ralf Exp $
// Written by R.Stephan 2000,2001, no copy restrictions.

#import "NaSchSingleDemoSwarm.h"
#import <gui.h>
#import <collections.h>
#import <simtools.h>
#import <analysis.h>
#import <tkobjc/Graph.h>
#import "NaSchSingleHighway.h"
#import "Detector.h"
#import "DetectorFeed.h"
#import "MNGVideo/MNGVideo.h"

@implementation NaSchSingleDemoSwarm

#define FONTNAME "*-helvetica-medium-*-normal-14-*_*_*_*_*_*"

//------------------------------------------------------
+ createBegin: aZone
{
	NaSchSingleDemoSwarm * obj;
	id <ProbeMap> probeMap;
  
	obj = [super createBegin: aZone];
	obj->vmax = 2;
	obj->pDecel = 0.1;
	obj->nHighways = 20;
	obj->highwayLen = 200;
	obj->minCarDensity = 0.2;
	obj->maxCarDensity = 0.6;

	probeMap = [EmptyProbeMap createBegin: aZone];
	[probeMap setProbedClass: [self class]];
	probeMap = [probeMap createEnd];

	[probeMap addProbe: [probeLibrary getProbeForVariable: "vmax"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "pDecel"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "nHighways"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "highwayLen"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "minCarDensity"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "maxCarDensity"
				    inClass: [self class]]];

	[probeLibrary setProbeMap: probeMap For: [self class]];

	return obj;
}

- createEnd
{
	return [super createEnd];
}

//--------------------------------------------------------------------
- _worldRasterDeath_ : caller
{
  [worldRaster drop];
  worldRaster = nil;
  return self;
}

- _canvasDeath_ : caller
{
	[myCanvas drop];
	myCanvas = nil;
	return self;
}

- _anGraphDeath_ : caller
{
  [anGraph drop];
  anGraph = nil;
  return self;
}

- buildObjects
{
	int i;
	id myText, detectorFeed, graphElement, graph;
	
	[super buildObjects];
  
	// create the probe display for the observer swarm (self)
	CREATE_PROBE_DISPLAY (self);

	myCanvas = [[Canvas createBegin: self] createEnd];
	[myCanvas setWidth: 450 Height: 240];
	[myCanvas setWindowTitle: "About NaSchDemo"];
	[myCanvas enableDestroyNotification: self
		notificationMethod: @selector (_canvasDeath_:)];

	myText = [TextItem createBegin: self];
	[[myText setText: 
	"
    The Nagel-Schreckenberg (NaSch) model is a minimal cellular
automaton that exhibits similar complex behaviour as cars 
on a single lane highway.
    Each highway in this demo is a ring of cells with cars moving
to the right and reappearing at the left.  One cell corresponds
to 7.5m in reality, so the default highway is 1.5km long.
    At the start, cars are placed on the highway with random 
position and speed, according to the given densities.  A number 
of highways is stacked in the window with ever increasing car 
density. The default demo shows how, with increasing density, 
traffic jams occur and move backwards.

Ref.: cond-mat/0007053
	"] 
	setFont: FONTNAME];
	[[myText setCanvas: myCanvas] setCenterFlag: NO];
	[myText setX: 25 Y: 120];
	[myText createEnd];
	[myCanvas pack];

//	observedAquarium = [AquariumSwarm createBegin: [self getZone]];
//	observedAquarium = [observedAquarium createEnd];
//	CREATE_PROBE_DISPLAY (observedAquarium);
	
	[controlPanel setStateStopped];
	if ([controlPanel getState] == ControlStateQuit)
		return nil;

	colormap = [Colormap create: [self getZone]];
	[colormap setColor: 0 ToName: "grey"];

    world = [Grid2d create: self setSizeX: highwayLen Y: nHighways*5];

	observedHighways = [List create: self];
	detectorFeed = [DetectorFeed createBegin: self];
	[detectorFeed setMin: minCarDensity Max: maxCarDensity];

	for (i=0; i<nHighways; i++)
	{
		float carDensity = minCarDensity 
			+ ((maxCarDensity-minCarDensity)/(nHighways-1))*i;
		id highway, detector;
		char dname[32];

		sprintf (dname, "c=%1.2f", carDensity);
		detector = [Detector create: self name: dname];
		[detectorFeed addObj: detector];
		highway = [NaSchSingleHighway createBegin: self];
		[highway setDensity: carDensity vMax: vmax P: pDecel];
		[highway setWorld: world];
		[highway setY: 2+i*5 size: highwayLen];
		[highway setDetector: detector];
		highway = [highway createEnd];
		[observedHighways addLast: highway];
		[highway buildObjects];
	}
	detectorFeed = [detectorFeed createEnd];

	// the following is stolen from heatbugs
	worldRaster = [ZoomRaster create: self];
	[worldRaster enableDestroyNotification: self
		notificationMethod: @selector (_worldRasterDeath_:)];
	[worldRaster setColormap: colormap];
	[worldRaster setZoomFactor: 4];
	[worldRaster setWidth: [world getSizeX] Height: [world getSizeY]];
	[worldRaster setWindowTitle: "NaSch Highways"];
	[worldRaster pack];				  // draw the window.
	[worldRaster drawSelf];

	video1 = [MNGVideo create: self Grid: world MagFactor: 4 ColorMap: colormap];
	video2 = [MNGVideo create: self Grid: world MagFactor: 2 ColorMap: nil
			   FrameRate: 50 NFrames: 100 Basename: "ns-50fps"];
	
	agentDisplay = 
    	[Object2dDisplay create: self
			setDisplayWidget: worldRaster
			setDiscrete2dToDisplay: world
			setDisplayMessage: M(drawSelfOn:)];
   
	graph = [Graph create: self];
	[graph setTitle: "Flow rate in single NaSch highways"];
	[graph setAxisLabelsX: "density" Y: "cars/timestep"];
	[graph setWidth: 400 Height: 250];
	[graph pack];
	[graph setScaleModeX: 1 Y: 0];
   
	graphElement = [graph createElement];
	[[[graphElement setLabel: "Flow"] setColor: "gray"]
    setWidth: 3];
//	[graphElement setOwnerGraph: graph];
	
	detectorGraph = [FunctionGraph createBegin: self];
	[detectorGraph setDataFeed: detectorFeed];
	[detectorGraph setElement: graphElement];
	[detectorGraph setFunctionSelector: M(getDFrom::)];
	[detectorGraph setXMin: minCarDensity Max: maxCarDensity
		Resolution: nHighways-1];
//	[detectorGraph setWindowGeometryRecordName: "detectorGraph"];
//	[detectorGraph enableDestroyNotification: self
//		notificationMethod: @selector (_anGraphDeath_:)];

	detectorGraph = [detectorGraph createEnd];
	return self;
}

//--------------------------------------------------

- buildActions
{
	[super buildActions];
  
	[observedHighways forEach: M(buildActions)];

	displayActions = [ActionGroup create: self];
	
	[displayActions createActionTo: worldRaster  message: M(erase)];
	[displayActions createActionTo: agentDisplay  message: M(display)];
	[displayActions createActionTo: worldRaster  message: M(drawSelf)];
	[displayActions createActionTo: detectorGraph  message: M(graph)];
	[displayActions createActionTo: probeDisplayManager message: M(update)];
	[displayActions createActionTo: video1 message: M(takeAFrame)];
	[displayActions createActionTo: video2 message: M(takeAFrame)];
	[displayActions createActionTo: actionCache  message: M(doTkEvents)];
//	[displayActions createActionTo: self  message: M(takeAPicture)];

	displaySchedule = [Schedule createBegin: self];
	[displaySchedule setRepeatInterval: 1];
	displaySchedule = [displaySchedule createEnd];
	[displaySchedule at: 0 createAction: displayActions];
  
	return self;
}  

- activateIn: swarmContext
{
	[super activateIn: swarmContext];

	[displaySchedule activateIn: self];
	[observedHighways forEach: M(activateIn:) : self];
  
	return [self getSwarmActivity];
}



@end
