// PopStep.h
// defines reproduction on population
// requirement agents are sorted from least to most fit when object is called

#import <objectbase/SwarmObject.h>
#import "GA.h"

@interface PopStep : SwarmObject
{
  GA * ga;
  double replace;				  // % of pop to replace
  double crossover;				  // % of replace to use crossover

  // % point, duplicate, split mut.
  double pp;
  double pd;
  double ps;		
}

-init;

-setReplace: (double) percent;
-setCrossover: (double) percent;
-setPP: (double) mut;
-setPD: (double) mut;
-setPS: (double) mut;

-reproduceSoup: (id *) a number: (int) num_agents;
-reproduceSpatial: (id *) a number: (int) num_agents;
-mutate: (id *) a number: (int) num_agents;

-(double) getReplace;
-(double) getCrossover;
-(double) getPP;
-(double) getPD;
-(double) getPS;

@end
