// Agent.m
// iterated prisoners dilemma agent

#import "IPDagent.h"
#import <stdio.h>
#include <string.h>		// for strcpy
#include <math.h>		// for exp and log

// class variables

@implementation IPDagent

// set agent states
-setID: (char *) newid
{
  strcpy(ident, newid);
  return self;
}

-setPayoff: (int) place Val: (int) value
{
  payoff[place] = value;
  return self;
}

-setStrategy: (unsigned) strat withMemory: (unsigned char) mem
{
  unsigned  mask;
  if (mem <= MEMMAX ) {
    memory = mem;
    length = (unsigned) pow(2.0, mem );
  } else
    return nil;

  mask = (length==32)?MASK32:(1 << length) - 1;
  strategy = strat&mask;
  return self;
}

-setHistory: (int) hist
{
  history = hist;
  return self;
}

-reset {
  average=0;
  iterations=0;
  return self;
}

-createEnd { 
  payoff[0] = 1;
  payoff[1] = 5;
  payoff[2] = 0;
  payoff[3] = 3;
  history = MASK32;
  score = average = 0;
  iterations = 1;

  return self;
}
  
-copyAgent: (id) a2
{
  [self setStrategy: [a2 getStrategy] withMemory: [a2 getMemory]];
  return self;
}

// agent interaction with world

-(char) action
{
  int i,j;

  i = (1 << memory) - 1;	// mask for past actions
  j = (1 << (i - (history & i))) & strategy;
    
  return ( j != 0 );
}

-updateAgent: (char) action
{
  history = (history << 2) | action;
  score = payoff[(int)action];
  if ( average ) 
    average = 
      (average + 
       (double) score / iterations)*((double)iterations/(iterations+1) );
  else 
    average = score;
  iterations++;
  return self;
}

// get agent state

-(char*) getID
{
  return (ident);}

-(unsigned char) getMemory
{
  return (memory);
}

-(unsigned char) getLength {
  return length;
}

-(unsigned) getStrategy
{
  return (strategy);
}

-(int) getScore
{
  return (score);
}

-(double) getAverage 
{
  return (average);
}

-debugState
{
  printf("AGENT:%s ",ident);
  printf("Mem:0x%x Strat:0x%x ",memory,strategy);
  printf("Hist 0x%x Score %3d Avg %g\n",history,score,average);

  return self;
}  

-printState
{
  //  printf("AGENT:%s ",ident);
  printf("Memory:0x%x Strategy:0x%x Average:%.3g\n",
	 memory, strategy, average);

  return self;
}

@end



