// -*- mode: objc
// Template application. Copyright (C) 1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "AgentObsSwarm.h"

// implementation of sample graphical interface for models.
@implementation AgentObserverSwarm

+ createBegin: aZone
{
  AgentObserverSwarm * obj;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  // MODIFY: initialize other display options here.
  obj->displayFrequency = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // MODIFY: set any display parameters here.
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

// MODIFY: possible creation finalization here
-createEnd {
  return [super createEnd];
}

- buildObjects
{
  id modelZone;

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];

  // Start creating population, needed to set the evaluation function
  agentSwarm = [AgentSwarm create: modelZone ];

  CREATE_ARCHIVED_PROBE_DISPLAY (agentSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);

  [actionCache waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  [agentSwarm buildObjects];

  // Create Graph for displaying fitness and data element
  fitnessGraph =  [EZGraph createBegin: modelZone];
  SET_WINDOW_GEOMETRY_RECORD_NAME (fitnessGraph);
  [fitnessGraph setTitle: "Fitness Evolution" ];
  [fitnessGraph setAxisLabelsX: "Time" Y: "Fitness"];
  fitnessGraph= [fitnessGraph createEnd];

  [fitnessGraph createAverageSequence: "Average fitness"
		withFeedFrom: [agentSwarm getList]
		andSelector: M(getFitness) ];

  [fitnessGraph createMinSequence: "Min fitness"
		withFeedFrom: [agentSwarm getList]
		andSelector: M(getFitness) ];

  [fitnessGraph createMaxSequence: "Max fitness"
		withFeedFrom: [agentSwarm getList]
		andSelector: M(getFitness) ];

  // Create Graph  and data element to display length
  lenGraph =  [EZGraph createBegin: modelZone];
  SET_WINDOW_GEOMETRY_RECORD_NAME (lenGraph);
  [lenGraph setTitle: "Len Evolution" ];
  [lenGraph setAxisLabelsX: "Time" Y: "Len"];
  lenGraph= [lenGraph createEnd];

  [lenGraph createAverageSequence: "Average memory length"
		withFeedFrom: [agentSwarm getList]
		andSelector: M(getMemory) ];

  [lenGraph createMinSequence: "Min memory length"
		withFeedFrom: [agentSwarm getList]
		andSelector: M(getMemory) ];

  [lenGraph createMaxSequence: "Max memory length"
		withFeedFrom: [agentSwarm getList]
		andSelector: M(getMemory) ];

  return self;
}  

- buildActions 
{
  [super buildActions];
  
  [agentSwarm buildActions];

  // MODIFY: schedule display objects here.
  displayActions = [ActionGroup create: [self getZone]];
  // Now schedule the update of the graphs
  [displayActions createActionTo: fitnessGraph  message: M(step)];
  [displayActions createActionTo: lenGraph  message: M(step)];
  // Schedule the update of the probe displays
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  // Finally, schedule an update for the whole user interface code.
  // This is crucial: without this, no graphics update and the control
  // panel will be dead. It's best to put it at the end of the display schedule
  [displayActions createActionTo: actionCache message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [agentSwarm activateIn: self];
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}

@end

