// PopStep.m
// code for methods belonging to PopStep object class

#import "PopStep.h"
#import "Agent.h"
#import "r250.h"

@implementation PopStep

-init
{
  [super init];
  
  ga = [[GA alloc] init];
  if (ga == nil) {
    fprintf(stderr,"Error: Creation of GA object in PopStep init");
    exit (-1);
  }

  return self;
}

-setReplace: (double) percent
{
  replace = percent;

  return self;
}

-setCrossover: (double) percent
{
  crossover = percent;

  return self;
}

-setGA: (GA *) g
{
  ga = g;

  return self;
}

-setPP: (double) mut
{
  pp = mut;

  return self;
}

-setPD: (double) mut
{
  pd = mut;

  return self;
}

-setPS: (double) mut
{
  ps = mut;

  return self;
}

-reproduceSoup: (id *) a number: (int) num_agents
{
  int i,j,k;
  int l1,l2,g1,g2;
  int c1,c2;

  // replace is total pop being replaced
  // crossover is % of replace to use crossover on
  c1 = (int) floor(replace * crossover * num_agents);
  c2 = (int) floor(replace * num_agents);

  j = num_agents - 1;

  // take top replace*crossover of pop and crossover
  for (i=0,k=0;i<c1;i+=2,k++) {
    g1 = [a[j-k] getGene];
    g2 = [a[j-k-1] getGene];
    l1 = [a[j-k] getGeneLength];
    l2 = [a[j-k-1] getGeneLength];

    // l1 is new length of gene
    l1 = [ga crossMutate: &g1 gene2: &g2 len1: l1 len2: l2];

    [a[i] setGene: g1];
    [a[i+1] setGene: g2];
    [a[i] setGeneLength: l1];
    [a[i+1] setGeneLength: l1];
  }

  // take top (replace-replace*crossover) % of pop. and duplicate
  for (i=c1;i<c2;i++) {
    [a[i] copyAgent: a[j-i]];
  }

  return self;
}

-reproduceSpatial: (id *) a number: (int) num_agents
{
  int i,j;
  int l1,l2,g1,g2;
  
  for (i=0;i<num_agents;i++) {			  // copy best neighbor
    if (dr250() > crossover){			  // copy update
      j = [a[i] getReg1];
      [a[i] copyAgent: a[j]];
    } else {					  // crossover update
      j = [a[i] getReg1];
      g1 = [a[i] getGene];
      g2 = [a[j] getGene];
      l1 = [a[i] getGeneLength];
      l2 = [a[j] getGeneLength];

      // l1 is new length of gene
      l1 = [ga crossMutate: &g1 gene2: &g2 len1: l1 len2: l2];

      [a[i] setGene: g1];
      [a[i] setGeneLength: l1];
     }
  }
  
  return self;
}

-mutate: (id *) a number: (int) num_agents
{
  int i,l1;
  unsigned g;

  for (i=0;i<num_agents;i++) {

    if (dr250() < pp) {				  // point mutation
      g = [a[i] getGene];
      l1 = [a[i] getGeneLength];
      [a[i] setGene: [ga bitMutate: g len: l1]];
    }

    if ( dr250() < pd) {			  // duplication  mutation
      g = [a[i] getGene];
      l1 = [a[i] getGeneLength];
      if (l1 <= 16){
	[a[i] setGene: [ga doubleMutate: g len: l1]];	
	[a[i] setGeneLength: (l1 << 1)];
      }
    }

    if ( dr250() < ps) {			  // split mutation
      g = [a[i] getGene];
      l1 = [a[i] getGeneLength];
      if (l1 > 2) {
	[a[i] setGene: [ga splitMutate: g len: l1]];
	[a[i] setGeneLength: (l1 >> 1)];
      }
    }
  }

  return self;
}

-(double) getReplace
{
  return(replace);
}

-(double) getCrossover
{
  return(crossover);
}

-(double) getPP
{
  return(pp);
}

-(double) getPD
{
  return(pd);
}

-(double) getPS
{
  return(ps);
}


@end








