// Agent.h
// defines agent vars and its interaction structure
// assumption: agent does not do any scheduling activity, relies on world
// to be added as Swarm scheduling is implementedd

#import <objectbase/SwarmObject.h>
#import <space/Grid2d.h>

@interface IPDAgent : SwarmObject
{
  // agent spatial location information
  int ident;			// agent ID tag

  // agent internal state
  int payoff[4];
  char memory;			// length of memory of agent
  unsigned strategy;		// agent transition table
  int score;			// total score from interaction
  double average;		// average from interacts

  int history;			// past actions
  int reg1;			// agent memory registers
  double reg2;
}

// spatial location setup
-setID: (int) newid;

// change internal state
-setPayoff: (int) place Val: (int) value;
-setMemory: (char) mem;
-setStrategy: (unsigned) strat;
-setHistory: (int) hist;
-setAverage: (double) avg;
-copyAgent: (id) a2;

-(char) action;			// returns action given history
-updateAgent: (char) action;	// given actions, updates agent
-updateAverage: (int) iter;

// get info about agent
-(int) getID;
-(char) getMemory;
-(unsigned) getStrategy;
-(int) getScore;
-(double) getAverage;
-(int) getReg1;
-(double) getReg2;
-(unsigned) getGene;
-(int) getGeneLength;

// utilities
-iSetKey: (unsigned) inum;			  // sorting keys
-dSetKey: (double) dnum;
-(unsigned) iGetKey;
-(double) dGetKey;

-debugState;
-printState;					  // prints agent internal state

@end
