// -*- mode: objc
// Template application. Copyright (C) 1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "PopSwarm.h"
#import "PopBatchSwarm.h"

#import <collections.h>

// implementation of sample graphical interface for models.
@implementation PopulationBatchSwarm

+createBegin: (id) aZone {
  PopulationBatchSwarm * obj;
  
  obj = [super createBegin: aZone];

  // MODIFY: initialize other display options here.
  obj->loggingFrequency = 1;

  return obj;
}

// MODIFY: possible creation finalization here
-createEnd {
  return [super createEnd];
}

-setChromLength: (unsigned) _len {
  chromLen = _len;
  return self;
}

-setEvaluationFunc: (float(*)( id )) _evalFunc {
    evalFunc = _evalFunc;
    return self;
}

-buildObjects {
  id modelZone;

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];

  // Start creating population, needed to set the evaluation function
  populationSwarm = [PopulationSwarm create: modelZone ];
  [populationSwarm setEvaluationFunc: evalFunc];
  [populationSwarm setChromLength: chromLen];

  [ObjectLoader load: populationSwarm fromFileNamed: "GA-experiment.setup"] ;
  [ObjectLoader load: self fromFileNamed: "GA-batch.setup"] ;


  [populationSwarm buildObjects];

  // Create Graph for displaying fitness and data element
  if ( loggingFrequency ) {
    fitnessGraph =  [EZGraph createBegin: [self getZone]];
    [[fitnessGraph setGraphics:0] setFileOutput:1];
    fitnessGraph= [fitnessGraph createEnd];

    [fitnessGraph createAverageSequence: "Average.fitness"
		  withFeedFrom: [populationSwarm getList]
		  andSelector: M(getFitness) ];

    [fitnessGraph createMinSequence: "Min.fitness"
		  withFeedFrom: [populationSwarm getList]
		  andSelector: M(getFitness) ];

    [fitnessGraph createMaxSequence: "Max.fitness"
		  withFeedFrom: [populationSwarm getList]
		  andSelector: M(getFitness) ];
  }
  return self;
}  

-buildActions {
  [super buildActions];
  
  [populationSwarm buildActions];

  // MODIFY: schedule display objects here.
  if (loggingFrequency ) {
    displayActions = [ActionGroup create: [self getZone]];
    // Now schedule the update of the fitness graph
    [displayActions createActionTo: fitnessGraph  message: M(step)];
    // and check to stop
    [displayActions createActionTo: self message: M(checkToStop) ];

    displaySchedule = [Schedule createBegin: [self getZone]];
    [displaySchedule setRepeatInterval: loggingFrequency];
    displaySchedule = [displaySchedule createEnd];
    [displaySchedule at: 0 createAction: displayActions];
  }
  return self;
}  

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [populationSwarm activateIn: self];
  if (loggingFrequency) 
    [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}

-checkToStop {
  if ( [populationSwarm getGenerations] 
       <= [populationSwarm getGenerationCount]) {
    [getTopLevelActivity() terminate]; // Terminate the simulation.

    if(loggingFrequency)
      [fitnessGraph drop] ;              // Close the output file.
  }
  return self;
}


// the PopulationObserverSwarm had a go method inherited from GUISwarm,
// but we have to define our own here. It's pretty simple. There's also
// a friendly message printed out here just in case someone is confused
// when they run heatbugs and see no graphics.

-go {
  printf(
    "You typed 'gademo -batchmode', so we're running without graphics.\n");

  printf("The GA is running for %d timesteps.\n", generations) ;
 
  if(loggingFrequency)
    printf("It is logging data every %d timesteps to {Max|Average|Min}.fitness.\n",
            loggingFrequency);

  [[self getSwarmActivity] run];
  return [[self getSwarmActivity] getStatus];
}
@end

