// ModelSwarm.m					majority 33

#import <simtools.h>
#import <collections.h>
#import <random.h>
#import "ModelSwarm.h"
#import "Setter.h"
#import "Voter.h"

@implementation ModelSwarm  

+createBegin: (id) aZone {
  ModelSwarm * obj;
 id <ProbeMap>  probeMap;

  obj = [super createBegin: aZone];

  // Fill in various simulation parameters with default values.
  obj->numVoters = 11;
  obj->worldXSize = 100;
  obj->worldYSize = 100;
  obj->widthOfSearch = 2;
  obj->beginx= 2;
  obj->beginy=4;
  obj->longestStep=5;
  
   probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
   probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
                                    inClass: [self class]]];
                                    
   [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
                                    inClass: [self class]]];        
                                                              
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numVoters"
                                   inClass: [self class]]]; 
				   
  [probeMap addProbe: [probeLibrary getProbeForVariable: "beginx"
                                   inClass: [self class]]];            
  [probeMap addProbe: [probeLibrary getProbeForVariable: "beginy"
                                   inClass: [self class]]];          				   
				                                       			                                       
  [probeMap addProbe: [probeLibrary getProbeForVariable: "longestStep"
				    inClass: [self class]]]; 
   
  [probeMap addProbe: [probeLibrary getProbeForVariable: "widthOfSearch"
				    inClass: [self class]]];                                                                    

  [probeLibrary setProbeMap: probeMap For: [self class]];
 
  return obj;
}

-createEnd {
  return [super createEnd];
}

-getVoterList {
  return voterList;
}
   
-getPolicyList {
  return policyList;
}

-getWinnerList {
  return winnerList;
}

-getWorld {
  return world;
}
    
-getSetterList {
  return setterList;
}
    
-buildObjects {

  int y; 

  [super buildObjects];  //copied from heatbugs

  world = [Grid2d createBegin: self ];
  [world setSizeX: worldXSize Y: worldYSize];
  world = [world createEnd];
  [world fillWithObject: nil];
 
  sq[0]=beginx; sq[1]=beginy;

  current = [PolicyPoint createBegin: self];
  [current setWorld: world];
  current = [current createEnd];
  [current setPos: sq];
  [current setPolicyColor: 2];    

  proposal = [PolicyPoint createBegin: self ];
  [proposal setWorld: world];
  proposal = [proposal createEnd];
  [proposal  setPos: sq];
  [proposal setPolicyColor: 2];    

  policyList = [List create: self ];
   
  winnerList = [List create: self ];
 
  voterList = [List create: self ];
   
  setterList = [List create: self];
 
  for (y = 0; y < numVoters; y ++) 
    {  
      Voter * aVoter;
      aVoter = [Voter createBegin: self];
      [aVoter setWorld: world];
      aVoter = [aVoter createEnd];
      [aVoter setVoterColor: 0];
      [voterList addLast: aVoter];
      [aVoter setidnum:y];
      // Uncomment Following to get creation-state information to compare against voter list
      // printf immediately below
      //     [aVoter sayHi];
    }

  //this is included if you want to verify the voter positions in the console output
  //   index=[voterList begin:[self getZone]];
  //   while((aVoter=[index next])){
  //         [aVoter sayHi];
  //         printf("that was from within the voterList!");}  
  //   [index drop];

  aSetter = [Setter createBegin: [self getZone]];
  [aSetter setWorld: world];
  aSetter = [aSetter createEnd];	 
  [aSetter startRNG];      
  [aSetter setInitialDirection: [uniformDblRand getDoubleWithMin: 0 withMax: +2]];
  [aSetter setWidthOfSearch: widthOfSearch];
  [aSetter setLongestStep: longestStep];
  [aSetter setVoterList: voterList];
  [setterList addLast: aSetter];
  //some graphs seem to insist you give them a list, rather than object, even
  //though there is just one. More clear manuals would help me here.      
      
  return self; 
}

-buildActions {

  //Create an ActionGroup to hold the messages

  modelActions = [ActionGroup create: self];
  
  [modelActions createActionTo: aSetter message: M(sayHi)];
  
  [modelActions createActionTo:  aSetter  message: M(makeProp:to:): current: proposal];
  
  [modelActions createActionTo: current message: M(sayHi)];

  [modelActions createActionTo: proposal message: M(sayHi)];
   
  [modelActions createActionTo:   aSetter  message: M(evaluateC:P:L:):current:proposal:voterList];

  // This causes the winner positions to be displayed in a "stream": 
  [modelActions createActionTo: policyList message: M(addLast:):current]; 

  //  If you instead want to show winners in red and losers in green, comment-out the previous and compile with NO_PIXMAP and  uncomment this:
  // [modelActions createActionTo: policyList message: M(addLast:):proposal]; 


  [modelActions createActionTo: self       message: M(checkToStop)];
  // Make a schedule and insert the ActionGroup as the only action

  modelSchedule = [Schedule createBegin: self];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions]; 

  return self;

}

-activateIn: (id) swarmContext {

  // Here, we activate the swarm in the context passed in
  // Then we activate our schedule in ourselves

   [super activateIn: swarmContext];
   [modelSchedule activateIn: self];

  return [self getActivity];
}

-checkToStop { 
   if (getCurrentTime() == 500)
     {
       stop=1;
   //    [[self getActivity] terminate];
      }
   else stop = 0;
    return self;
 }
-(int)getStop {
    return stop;
 }


@end



  


