// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// ViewerSwarm.m
/*
  - OPENS files
  - LOADS into arrays
  - RUNS swarm with graphs reading data from arrays
  - if Button SAVESIM: 
            - SAVES simName.PNG picture
	    - COPY model.setup -> simName.setup
*/

#import "ViewerSwarm.h"
#import <activity.h>

static const char *files[] = {  
  "data/data.population.Population",
  "data/data.population.Births",
  "data/data.population.Deaths",
  "data/data.population.Age_avg",
  // "data/data.population.Mutations",
  "data/data.population.enz_Mag",

  "data/data.entropy.input",
  "data/data.entropy.output",
  "data/data.entropy.enzyme",

  "data/data.ioCardStat.in_card_avg",
  "data/data.ioCardStat.out_card_avg",
  "data/data.ioCardStat.enz_card_avg",
  "data/data.ioCardStat.in_card_std",
  "data/data.ioCardStat.out_card_std",
  "data/data.ioCardStat.enz_card_std",

  "data/data.MetabRates.totalMetab",
  "data/data.MetabRates.moveMetab",    
  "data/data.MetabRates.consRate",
  "data/data.MetabRates.magSize",
  "data/data.MetabRates.vision",
  "data/data.MetabRates.maxMR",
  //  "data/data.MetabRates.enzMetab",
  "data/data.MetabRates.satisfMetab",
 
  "data/data.nutris.",

  "data/data.cyclRatios.",

  "data/data.mBiomass.",

  "data/data.fBiomass.",

  "data/data.contribNuts.",

  "data/data.nutriFracs.",

  "data/data.optStat.error",
  "data/data.optStat.avgMagError",
  "data/data.optStat.IFD",
};


@implementation ViewerSwarm

+ createBegin: aZone
{
  ViewerSwarm *obj;
  id <ProbeMap> probeMap;

 printf("  VS: createBegin ..");
       // createBegin: here we set up the default simulation parameters.
  obj = [super createBegin: aZone];

  obj->displayFrequency    = 1;
  obj->drawPopulGr         = 1;
  obj->drawNutrisGr        = 1;
  obj->drawFreeBiomassGr   = 1;
  obj->drawCyclRatiosGr    = 1;
  obj->drawMagsBiomassGr   = 1;
  obj->drawContribNutriGr  = 1;
  obj->drawIOCardStatGr    = 1;
  obj->drawIOEntropyGr     = 1;
  obj->drawMetabGr         = 1;
  obj->drawNutriFracsGr    = 1;
  obj->drawOptFracsStatGr  = 1;
  obj->tik                 = 0;
  obj->time                = 0;
  obj->dataFile            = (char *) 0;
  if( ( obj->dataFile= (char *) calloc( 81, sizeof(char)) ) ==NULL )
    [InvalidCombination raiseEvent: "OS: Cannot allocate dataFile string\n"];
  strcpy(obj->dataFile,"data/model.setup"); 
  strcpy(obj->simName,"defaultSim1"); 
  obj->cntNutri            = 0;
  obj->cntCyclRat          = 0;
  obj->cntMagsBiomass      = 0;
  obj->cntContribNutri     = 0;
  obj->cntFreeBiomass      = 0;
  obj->cntNutriFracs       = 0;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  //  [probeMap addProbe: [probeLibrary getProbeForMessage: "tick"
  //                                  inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "dataFile"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
                                    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];
 printf("Done\n");

  return obj;
}

- createEnd
{
  printf("  VS: createEnd     Done\n");
  return [super createEnd];
}



- (float) getPopGr1      {  return popGr1[tik];   }
- (float) getPopGr2      {  return popGr2[tik];   }
- (float) getPopGr3      {  return popGr3[tik];   }
- (float) getPopGr4      {  return popGr4[tik];   }
- (float) getPopGr5      {  return popGr5[tik];   }
- (float) getEntGr1      {  return entGr1[tik];   }
- (float) getEntGr2      {  return entGr2[tik];   }
- (float) getEntGr3      {  return entGr3[tik];   }
- (float) getCardStatGr1 {  return cardStatGr1[tik];   }
- (float) getCardStatGr2 {  return cardStatGr2[tik];   }
- (float) getCardStatGr3 {  return cardStatGr3[tik];   }
- (float) getCardStatGr4 {  return cardStatGr4[tik];   }
- (float) getCardStatGr5 {  return cardStatGr5[tik];   }
- (float) getCardStatGr6 {  return cardStatGr6[tik];   }
- (float) getMetabGr1    {  return metabGr1[tik];   }
- (float) getMetabGr2    {  return metabGr2[tik];   }
- (float) getMetabGr3    {  return metabGr3[tik];   }
- (float) getMetabGr4    {  return metabGr4[tik];   }
- (float) getMetabGr5    {  return metabGr5[tik];   }
- (float) getMetabGr6    {  return metabGr6[tik];   }
- (float) getMetabGr7    {  return metabGr7[tik];   }
- (float) getMetabGr8    {  return metabGr8[tik];   }
- (float) getOptFracsStatGr1    {  return optFracsStatGr1[tik];   }
- (float) getOptFracsStatGr2    {  return optFracsStatGr2[tik];   }
- (float) getOptFracsStatGr3    {  return optFracsStatGr3[tik];   }

- (float) getNutriGr
{ 
  float val;
  val=nutriGr[cntNutri][tik];
  if(++cntNutri > nutrisNum-1)                 // cycling 0,1,..N,0,1,..
    cntNutri = 0; 
  return val;  
}

- (float) getCyclRatGr
{ 
  float val;
  val=cyclRatGr[cntCyclRat][tik];
  if(++cntCyclRat > nutrisNum-1)                 // cycling 0,1,..N,0,1,..
    cntCyclRat = 0; 
  return val;  
}

- (float) getMagsBiomassGr
{ 
  float val;
  val=magsBiomassGr[cntMagsBiomass][tik];
  if(++cntMagsBiomass > nutrisNum-1)                 // cycling 0,1,..N,0,1,..
    cntMagsBiomass = 0; 
  return val;  
}

- (float) getFreeBiomassGr
{ 
  float val;
  val=freeBiomassGr[cntFreeBiomass][tik];
  if(++cntFreeBiomass > nutrisNum-1)                 // cycling 0,1,..N,0,1,..
    cntFreeBiomass = 0; 
  return val;  
}


- (float) getContribNutriGr
{ 
  float val;
  val=magsContribNutrisGr[cntContribNutri][tik];
  if(++cntContribNutri > nutrisNum-1)                 // cycling 0,1,..N,0,1,..
    cntContribNutri = 0; 
  return val;  
}

- (float) getNutriFracsGr
{ 
  float val;
  val=nutriFracsGr[cntNutriFracs][tik];
  if(++cntNutriFracs > nutrisNum-1)                 // cycling 0,1,..N,0,1,..
    cntNutriFracs = 0; 
  return val;  
}




- buildObjects
{
  char text[10];
  int i;
  id <ButtonPanel> panelWidget;

 printf("  VS: buildObjects ..");

  [super buildObjects];
  panelWidget = [actionCache getPanel];      // adding button to ControlPanel
  [panelWidget addButtonName: "SaveSim"
		      target: self
		      method: M(saveModel)];

  CREATE_ARCHIVED_PROBE_DISPLAY (self);       // for MS and OS

  [controlPanel setStateStopped];

  [self checkFiles];
  
  if(drawPopulGr==1)
  {  
    populationGraph = [EZGraph createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME(populationGraph);
    [populationGraph setTitle: "Population"];
    [populationGraph setAxisLabelsX: "time" Y: "agents"];
    populationGraph = [populationGraph createEnd];
    [populationGraph createSequence: "Population"
                     withFeedFrom: self
		     andSelector: M(getPopGr1)];
    [populationGraph createSequence: "Births"
                   withFeedFrom: self
		   andSelector: M(getPopGr2)];
    [populationGraph createSequence: "Deaths"
                   withFeedFrom: self
		   andSelector: M(getPopGr3)];
    [populationGraph createSequence: "Age_avg"
                     withFeedFrom: self
		     andSelector: M(getPopGr4)];
    [populationGraph createSequence: "enz_Mag"
                     withFeedFrom: self
		     andSelector: M(getPopGr5)];
    /*  [populationGraph createSequence: "Mutations"
                     withFeedFrom: self 
		     andSelector: M(getPopGr5)];*/
  }


 
  if(drawIOEntropyGr==1)
  {  
    ioEntropyGraph = [EZGraph createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME(ioEntropyGraph);
    [ioEntropyGraph setTitle: "Input/Output/Enzymes entropy"];
    [ioEntropyGraph setAxisLabelsX: "time" Y: "entropy"];
    ioEntropyGraph = [ioEntropyGraph createEnd];
    [ioEntropyGraph createSequence: "input"
                     withFeedFrom: self
		     andSelector: M(getEntGr1)];
    [ioEntropyGraph createSequence: "output"
                     withFeedFrom: self
	 	     andSelector: M(getEntGr2)];
    [ioEntropyGraph createSequence: "enzyme"
                     withFeedFrom: self
	 	     andSelector: M(getEntGr3)];
  } 
    
  if(drawIOCardStatGr==1)
  {  
    ioCardStatGraph = [EZGraph createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME(ioCardStatGraph);
    [ioCardStatGraph setTitle: "Input/Output/Enzymes cardinality statistics"];
    [ioCardStatGraph setAxisLabelsX: "time" Y: "avg , std.deviation"];
    ioCardStatGraph = [ioCardStatGraph createEnd];
    [ioCardStatGraph createSequence: "in_card_avg"
                     withFeedFrom: self
		     andSelector: M(getCardStatGr1)];
    [ioCardStatGraph createSequence: "out_card_avg"
                     withFeedFrom: self
		     andSelector: M(getCardStatGr2)];
    [ioCardStatGraph createSequence: "enz_card_avg"
                     withFeedFrom: self
		     andSelector: M(getCardStatGr3)];
    [ioCardStatGraph createSequence: "in_card_std"
                     withFeedFrom: self
		     andSelector: M(getCardStatGr4)];
    [ioCardStatGraph createSequence: "out_card_std"
                     withFeedFrom: self
		     andSelector: M(getCardStatGr5)];
    [ioCardStatGraph createSequence: "enz_card_std"
                     withFeedFrom: self
		     andSelector: M(getCardStatGr6)];
  }
   
 
  if(drawMetabGr==1)
  {  
    metabGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(metabGraph);
    [metabGraph setTitle: "Amount of Average metabRates"];
    [metabGraph setAxisLabelsX: "time" Y: "Rate"];
     metabGraph = [metabGraph createEnd];
    [metabGraph createSequence: "totalMetab"
                   withFeedFrom: self
		   andSelector: M(getMetabGr1)];
    [metabGraph createSequence: "moveMetab"     
                   withFeedFrom: self
		   andSelector: M(getMetabGr2)];
    [metabGraph createSequence: "consRate"
                   withFeedFrom: self
		   andSelector: M(getMetabGr3)];
    [metabGraph createSequence: "magSize"
                   withFeedFrom: self
		   andSelector: M(getMetabGr4)];
    [metabGraph createSequence: "vision"
                   withFeedFrom: self
		   andSelector: M(getMetabGr5)];
    [metabGraph createSequence: "maxMR"
                   withFeedFrom: self
		   andSelector: M(getMetabGr6)];
    /*    [metabGraph createSequence: "enzMetab"
                   withFeedFrom: self
		   andSelector: M(getMetabGr7)];*/
    [metabGraph createSequence: "satisfMetab"     
	  	   withFeedFrom: self
		   andSelector: M(getMetabGr7)];
  } 

  if(drawNutrisGr==1)
  {  
    allNutriGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(allNutriGraph);
    [allNutriGraph setTitle: "Amount of nutrients"];
    [allNutriGraph setAxisLabelsX: "time" Y: "nutrient"];
    allNutriGraph = [allNutriGraph createEnd]; 
    for(i=0; i<nutrisNum; i++)
    {  
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_nutri");
      [allNutriGraph createSequence: text
		 withFeedFrom: self
		 andSelector: M(getNutriGr)]; 
    }		 
  }	
	 
  if(drawCyclRatiosGr==1)
  {   
    cyclRatiosGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(cyclRatiosGraph); 
    [cyclRatiosGraph setTitle: "Cycling Ratios"]; 
    [cyclRatiosGraph setAxisLabelsX: "time" Y: "Cycling Ratio"]; 
    cyclRatiosGraph = [cyclRatiosGraph createEnd]; 
    for(i=0; i<nutrisNum; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
       // I just hope order of calling selector will stay the same
      [cyclRatiosGraph createSequence: text
		       withFeedFrom: self
		       andSelector: M(getCyclRatGr)]; 
    }		  
  }		  
 
  if(drawMagsBiomassGr==1)
  {   
    magsBiomassGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(magsBiomassGraph); 
    [magsBiomassGraph setTitle: "Mags'a biomass"]; 
    [magsBiomassGraph setAxisLabelsX: "time" Y: "nutrient"]; 
    magsBiomassGraph = [magsBiomassGraph createEnd]; 
    for(i=0; i<nutrisNum; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
       // I just hope order of calling selector will stay the same
      [magsBiomassGraph createSequence: text
		     withFeedFrom: self
		     andSelector: M(getMagsBiomassGr)]; 
    }		  
  }		  

  if(drawFreeBiomassGr==1)
  {   
    freeBiomassGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(freeBiomassGraph); 
    [freeBiomassGraph setTitle: "Free biomass"]; 
    [freeBiomassGraph setAxisLabelsX: "time" Y: "biomass"]; 
    freeBiomassGraph = [freeBiomassGraph createEnd]; 
    for(i=0; i<nutrisNum; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_bioM"); 
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
       // I just hope order of calling selector will stay the same
      [freeBiomassGraph createSequence: text
		     withFeedFrom: self
		     andSelector: M(getFreeBiomassGr)]; 
    }		  
  }		  

  if(drawContribNutriGr==1)
  {   
    magsContribNutrisGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(magsContribNutrisGraph); 
    [magsContribNutrisGraph setTitle: "Total production/consumption" ]; 
    [magsContribNutrisGraph setAxisLabelsX: "time" Y: "nutrient"]; 
    magsContribNutrisGraph = [magsContribNutrisGraph createEnd]; 
    for(i=0; i<nutrisNum; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
       // I just hope order of calling selector will stay the same
      [magsContribNutrisGraph createSequence: text
		      withFeedFrom: self
		      andSelector: M(getContribNutriGr)]; 
    }		  
  }		  

  if(drawNutriFracsGr==1)
  {  
    allNutriFracsGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(allNutriFracsGraph);
    [allNutriFracsGraph setTitle: "Amount of nutrients' fractions"];
    [allNutriFracsGraph setAxisLabelsX: "time" Y: "nutrient fraction"];
    allNutriFracsGraph = [allNutriFracsGraph createEnd];
    for(i=0; i<nutrisNum; i++)
    {  
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_nutri");
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
       // I just hope order of calling selector will stay the same
      [allNutriFracsGraph createSequence: text
			  withFeedFrom: self
			  andSelector: M(getNutriFracsGr)]; 
    }		 
  }	
	 
  if(drawOptFracsStatGr==1)
  {  
    optFracsStatGraph = [EZGraph createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME(optFracsStatGraph);
    [optFracsStatGraph setTitle: "Optimal NutriFracs Error statistics"];
    [optFracsStatGraph setAxisLabelsX: "time" Y: "error"];
    optFracsStatGraph = [optFracsStatGraph createEnd];
    [optFracsStatGraph createSequence: "error"
                     withFeedFrom: self
		     andSelector: M(getOptFracsStatGr1)];
    [optFracsStatGraph createSequence: "avgMagError"
                     withFeedFrom: self
		     andSelector: M(getOptFracsStatGr2)];
    [optFracsStatGraph createSequence: "IFD"
                     withFeedFrom: self
		     andSelector: M(getOptFracsStatGr3)];
 }
  
 printf("  Done\n");
	       	       
  return self;
}


- tick
{
  tik++;
  return self;
}

- checkToStop
{
  if(tik == time)
  {
    [controlPanel setStateStopped];
    printf("\007");
  }
  return self;
}

- buildActions
{
  int nutrisNum;
 printf("  VS: buildActions ..");

  [super buildActions];
  
  displayActions = [ActionGroup create: self];


  if(drawPopulGr == 1)	       	       
    [displayActions createActionTo: populationGraph        message: M(step)];
  if(drawIOEntropyGr == 1)	       	       
    [displayActions createActionTo: ioEntropyGraph         message: M(step)];
  if(drawIOCardStatGr == 1)	       	       
    [displayActions createActionTo: ioCardStatGraph        message: M(step)];
  if(drawMetabGr == 1)	       	       
    [displayActions createActionTo: metabGraph             message: M(step)];
  if(drawNutrisGr == 1)	       	        
    [displayActions createActionTo: allNutriGraph          message: M(step)];
  if(drawFreeBiomassGr == 1)	       	       
    [displayActions createActionTo: freeBiomassGraph       message: M(step)];
  if(drawCyclRatiosGr == 1)	       	       
    [displayActions createActionTo: cyclRatiosGraph        message: M(step)];
  if(drawMagsBiomassGr == 1)	       	       
    [displayActions createActionTo: magsBiomassGraph       message: M(step)];
  if(drawContribNutriGr == 1)	       	       
    [displayActions createActionTo: magsContribNutrisGraph message: M(step)];
  if(drawNutriFracsGr == 1)	       	       
    [displayActions createActionTo: allNutriFracsGraph     message: M(step)];
  if(drawOptFracsStatGr == 1)	       	       
    [displayActions createActionTo: optFracsStatGraph      message: M(step)];
  
  [displayActions createActionTo: self                message: M(tick)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache         message: M(doTkEvents)];
  [displayActions createActionTo: self                message: M(checkToStop)];

  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
  
 printf("Done\n");
 
  return self;
}


- activateIn: swarmContext
{
 printf("  VS: ActivateIn ..");

  [super activateIn: swarmContext];

  [displaySchedule activateIn: self];

 printf("Done \n");
  return [self getSwarmActivity];
}

- saveModel       // called by SaveSim button or when all Mags are dead
{
  id pixId;
  char text[MAXFILENAME];

  printf("\n\007  Saving picture 's%s.png' ..",simName);
  sprintf (text, "s%s.png",simName);
  pixId = [ [[[Pixmap createBegin:[self getZone] ] 
                      setWidget: nil]             // ('nil'=>root window)
             	      createEnd] 
         	      save: text];
  [pixId drop];

  if((strcmp(dataFile,"model.setup"))==0)
  {
    sprintf (text, "cp %s s%s.setup",dataFile,simName);
    printf("\n%s",text);
    system(text);
  }
  if((strcmp(dataFile,"data/model.setup"))==0)
  {
    sprintf (text, "cp %s s%s.setup",dataFile,simName);
    printf("\n%s",text);
    system(text);
  }
  printf(".. Done");
  return self;
}

  // ======================================== LOAD DATA FILES ==========
  // ===================================================================

- checkFiles
{
  int i, k, ret, fileNum, done;
  char txt[200];
  float fl;
  char baseName[100],nutriName[20],fullName[120];
  int d;

     /* 1. LOAD FROM MODEL.SETUP nutrisNum, displayFreq
        2. ALOCATE ARRAYS FOR GRAPHS DATA
	3. SEQUENTIALY OPEN DATA FILES AND IF EXISTS THEN COPY DATA TO ARRAYS
           if not, leave arrays = 0
	4. CLOSE THE FILES  
	   */

  // ======================================== MODEL.SETUP ==========

  if( (file=fopen(dataFile,"r"))==NULL)
     [InvalidCombination raiseEvent: "OS: Cannot open dataFile "];

  done = 0;
  do{ 
    ret=fscanf(file,"%s",txt);
    if( strcmp(txt,"nutrisNum")==0 )
    {  
      fscanf(file,"%d",&nutrisNum);
      printf("\n nutrisNum = %d", nutrisNum);
      done++;
    }
    if( strcmp(txt,"displayFreq")==0 )
    {  
      fscanf(file,"%d",&displayFrequency);
      printf("\n displayFreq = %d", displayFrequency);
      done++;
    }
    if( strcmp(txt,"simName")==0 )
    {  
      fscanf(file,"%s",simName);
      printf("\n simName = %s", simName);
      if( strlen(simName) > MAXFILENAME-1 )
	[InvalidCombination raiseEvent: "\n Simulation name too long"]; 
      done++;
    }
  }while(ret!=EOF && done!=3);
  fclose(file);
  if( done==0 )
     [InvalidCombination 
       raiseEvent: "VS: Didn't found nutrisNum or DisplayFreq in dataFile"];

  fileNum=0;
  time=0;

  // ======================================== DATA.POPULATION ==========


  if( (file=fopen(files[fileNum++],"r"))==NULL)
  {
    printf("\n Error: Cannot open basic file: %s",files[fileNum-1]);
    exit(1);
  }
  else
  {
    while( (ret=fscanf(file,"%f",&fl)) != EOF)
      time++;
    printf("\n timeSteps=%d\n", time);

    if( ( popGr1= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate population1 array\n"];
    if( ( popGr2= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate population2 array\n"];
    if( ( popGr3= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate population3 array\n"];
    if( ( popGr4= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate population4 array\n"];
    if( ( popGr5= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate population5 array\n"];

    
    fseek(file,0,0);  // reposition file to beginning
    i=0;
    while( (ret=fscanf(file,"%f",&popGr1[i++])) != EOF);
    if(i!=time+1) printf("\n Not matching count in %s, %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&popGr2[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&popGr3[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }
  
  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&popGr4[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }    

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&popGr5[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }    


  // ======================================== DATA.ENTROPY ==========

  if( ( entGr1= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate entropy1 array\n"];
  if( ( entGr2= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate entropy2 array\n"];
  if( ( entGr3= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate entropy3 array\n"];

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&entGr1[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&entGr2[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }
    
  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&entGr3[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }
  

  // ======================================== DATA.IOCARDSTAT ==========

  if( ( cardStatGr1= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate cardStat1 array\n"];
  if( ( cardStatGr2= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate cardStat2 array\n"];
  if( ( cardStatGr3= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate cardStat3 array\n"];
  if( ( cardStatGr4= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate cardStat4 array\n"];
  if( ( cardStatGr5= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate cardStat5 array\n"];
  if( ( cardStatGr6= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate cardStat6 array\n"];
  
  if( (file=fopen(files[fileNum++],"r"))==NULL)
      printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else
  {
    i=0;
    while( (ret=fscanf(file,"%f",&cardStatGr1[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }
  
  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&cardStatGr2[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&cardStatGr3[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&cardStatGr4[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }    

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&cardStatGr5[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }    

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&cardStatGr6[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }    



  // ======================================== DATA.METABRATES ==========

  if( ( metabGr1= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate metab1 array\n"];
  if( ( metabGr2= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate metab2 array\n"];
  if( ( metabGr3= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate metab3 array\n"];
  if( ( metabGr4= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate metab4 array\n"];
  if( ( metabGr5= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate metab5 array\n"];
  if( ( metabGr6= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate metab6 array\n"];
  if( ( metabGr7= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate metab7 array\n"];
  if( ( metabGr8= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate metab8 array\n"];
  
  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else
  {
    i=0;
    while( (ret=fscanf(file,"%f",&metabGr1[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&metabGr2[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&metabGr3[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }
  
  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&metabGr4[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }
  
  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&metabGr5[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }
  
  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&metabGr6[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&metabGr7[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  /*  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&metabGr8[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s %d",files[fileNum-1],i);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  } 
  */

  // ======================================== DATA.NUTRIS ==========
  
  for(k=0; k<nutrisNum; k++)
  {
    if( ( nutriGr[k]= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate nutriGr array\n"];
  }


  strcpy(baseName,files[fileNum++]);
  for(k=0; k<nutrisNum; k++)
  {  
    nutriName[0] = 'A'+k;         // rising A,B,C,... 
    nutriName[1] = '\0';	  
    strcat(nutriName,"_nutri");
    sprintf(fullName,"%s%s",baseName,nutriName);
    if( (file=fopen(fullName,"r"))==NULL)
      printf("\n Warning: Cannot open file: %s",fullName);
    else{
      i=0;
      while( (ret=fscanf(file,"%f",&nutriGr[k][i++])) != EOF);
      if(i!=time+1)  printf("\n Not matching count in %s",fullName);
      printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
      fclose(file);
    }
  }

  // ======================================== DATA.CYCLRAT ==========

  
  for(k=0; k<nutrisNum; k++)
  {
    if( ( cyclRatGr[k]= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate cyclRatGr array\n"];
  }


  strcpy(baseName,files[fileNum++]);
  for(k=0; k<nutrisNum; k++)
  {  
    nutriName[0] = 'A'+k;         // rising A,B,C,... 
    nutriName[1] = '\0';	  
    strcat(nutriName,"_nutri");
    sprintf(fullName,"%s%s",baseName,nutriName);
    if( (file=fopen(fullName,"r"))==NULL)
      printf("\n Warning: Cannot open file: %s",fullName);
    else{
      i=0;
      while( (ret=fscanf(file,"%f",&cyclRatGr[k][i++])) != EOF);
      if(i!=time+1)  printf("\n Not matching count in %s",fullName);
      printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
      fclose(file);
    }
  }


  // ======================================== DATA.mBIOMASS =========

  
  for(k=0; k<nutrisNum; k++)
  {
    if( ( magsBiomassGr[k]= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate magsBiomassGr array\n"];
  }


  strcpy(baseName,files[fileNum++]);
  for(k=0; k<nutrisNum; k++)
  {  
    nutriName[0] = 'A'+k;         // rising A,B,C,... 
    nutriName[1] = '\0';	  
    strcat(nutriName,"_nutri");
    sprintf(fullName,"%s%s",baseName,nutriName);
    if( (file=fopen(fullName,"r"))==NULL)
      printf("\n Warning: Cannot open file: %s",fullName);
    else{
      i=0;
      while( (ret=fscanf(file,"%f",&magsBiomassGr[k][i++])) != EOF);
      if(i!=time+1)  printf("\n Not matching count in %s",fullName);
      printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
      fclose(file);
    }
  }


  // ======================================== DATA.fBIOMASS =========

  for(k=0; k<nutrisNum; k++)
  {
    if( ( freeBiomassGr[k]= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate freeBiomassGr array\n"];
  }


  strcpy(baseName,files[fileNum++]);
  for(k=0; k<nutrisNum; k++)
  {  
    nutriName[0] = 'A'+k;         // rising A,B,C,... 
    nutriName[1] = '\0';	  
    strcat(nutriName,"_bioM");
    sprintf(fullName,"%s%s",baseName,nutriName);
    if( (file=fopen(fullName,"r"))==NULL)
      printf("\n Warning: Cannot open file: %s",fullName);
    else{
      i=0;
      while( (ret=fscanf(file,"%f",&freeBiomassGr[k][i++])) != EOF);
      if(i!=time+1)  printf("\n Not matching count in %s",fullName);
      printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
      fclose(file);
    }
  }

  // ======================================== DATA.MAGS_CONTRIB_NURTIS ==

  
  for(k=0; k<nutrisNum; k++)
  {
    if( ( magsContribNutrisGr[k]= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate magsContribNutrisGr array\n"];
  }


  strcpy(baseName,files[fileNum++]);
  for(k=0; k<nutrisNum; k++)
  {  
    nutriName[0] = 'A'+k;         // rising A,B,C,... 
    nutriName[1] = '\0';	  
    strcat(nutriName,"_nutri");
    sprintf(fullName,"%s%s",baseName,nutriName);
    if( (file=fopen(fullName,"r"))==NULL)
      printf("\n Warning: Cannot open file: %s",fullName);
    else{
      i=0;
      while( (ret=fscanf(file,"%f",&magsContribNutrisGr[k][i++])) != EOF);
      if(i!=time+1)  printf("\n Not matching count in %s",fullName);
      printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
      fclose(file);
    }
  }


  // ======================================== DATA.NUTRIFRACS ==========
  
  for(k=0; k<nutrisNum; k++)
  {
    if( ( nutriFracsGr[k]= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
      [InvalidCombination raiseEvent: "Cannot allocate nutriFracsGr array\n"];
  }


  strcpy(baseName,files[fileNum++]);
  for(k=0; k<nutrisNum; k++)
  {  
    nutriName[0] = 'A'+k;         // rising A,B,C,... 
    nutriName[1] = '\0';	  
    strcat(nutriName,"_nutri");
    sprintf(fullName,"%s%s",baseName,nutriName);
    if( (file=fopen(fullName,"r"))==NULL)
      printf("\n Warning: Cannot open file: %s",fullName);
    else{
      i=0;
      while( (ret=fscanf(file,"%f",&nutriFracsGr[k][i++])) != EOF);
      if(i!=time+1)  printf("\n Not matching count in %s",fullName);
      printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
      fclose(file);
    }
  }

  // ======================================== DATA.OPTFRACSSTAT ==========

  if( ( optFracsStatGr1= (float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate optFracsStat1 array\n"];
  if( ( optFracsStatGr2=(float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate optFracsStat2 array\n"];
  if( ( optFracsStatGr3=(float *) calloc( time+3, sizeof(float)) ) ==NULL )
    [InvalidCombination raiseEvent: "Cannot allocate optFracsStat3 array\n"];

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&optFracsStatGr1[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&optFracsStatGr2[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  if( (file=fopen(files[fileNum++],"r"))==NULL)
    printf("\n Warning: Cannot open file: %s",files[fileNum-1]);
  else{
    i=0;
    while( (ret=fscanf(file,"%f",&optFracsStatGr3[i++])) != EOF);
    if(i!=time+1)  printf("\n Not matching count in %s",files[fileNum-1]);
    printf("\n Reading file: %s , %d entries.",files[fileNum-1],i);
    fclose(file);
  }

  return self;
}


@end















