// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

 // ViewerSwarm.h

#import <analysis.h>
#import <simtoolsgui/GUISwarm.h>

#define MAXNUTRIS 11
#define MAXFILENAME 100  // max. lenght of simulation name

@interface ViewerSwarm: GUISwarm
{
  int displayFrequency;   
  int nutrisNum;
  int drawPopulGr;      
  int drawNutrisGr;
  int drawNutriFracsGr;
  int drawFreeBiomassGr;
  int drawMagsBiomassGr;
  int drawContribNutriGr;
  int drawMetabGr;
  int drawCyclRatiosGr;
  int drawIOCardStatGr;
  int drawIOEntropyGr;
  int drawOptFracsStatGr;
  int tik;
  char *dataFile;
  char simName[MAXFILENAME];

  int time;
  float *popGr1, *popGr2, *popGr3, *popGr4, *popGr5;
  float *entGr1, *entGr2, *entGr3;
  float *cardStatGr1,*cardStatGr2, *cardStatGr3;
  float *cardStatGr4, *cardStatGr5, *cardStatGr6;  
  float *metabGr1, *metabGr2, *metabGr3, *metabGr4;
  float *metabGr5, *metabGr6, *metabGr7, *metabGr8;
  float *optFracsStatGr1, *optFracsStatGr2, *optFracsStatGr3;
  float *nutriGr[MAXNUTRIS];
  float *cyclRatGr[MAXNUTRIS];
  float *magsBiomassGr[MAXNUTRIS];
  float *freeBiomassGr[MAXNUTRIS];
  float *magsContribNutrisGr[MAXNUTRIS];
  float *nutriFracsGr[MAXNUTRIS];

  int cntNutri, cntCyclRat, cntMagsBiomass, cntContribNutri, cntFreeBiomass;
  int cntNutriFracs;

  id displayActions;                          
  id displaySchedule;

  FILE *file;

  id <EZGraph> populationGraph;    // all popul + births + deaths
  id <EZGraph> allNutriGraph;
  id <EZGraph> freeBiomassGraph;   // amt of free biomass A,B, .. in world
  id <EZGraph> cyclRatiosGraph;    // cycling ratios = min(prod,cons)/max(inF,ouF)
  id <EZGraph> magsBiomassGraph;      // nutri stored in Mags
  id <EZGraph> magsContribNutrisGraph;     // nutri in space added/taken by Mags
  id <EZGraph> ioCardStatGraph;    // avg and std deviation of in/out nutri cardinality
  id <EZGraph> ioEntropyGraph;     // entropy of Mags' inputs / outputs 
  id <EZGraph> metabGraph;         // metabolisms
  id <EZGraph> allNutriFracsGraph; // amt of nutritients ratios [%] A,B, ..
  id <EZGraph> optFracsStatGraph;  // error from optimum nutri fracs. measure

}

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- tick;
- checkFiles;
- activateIn: swarmContext;

@end

