// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// main.m

#import <simtools.h>                // ... for initSwarm() 
#import <simtoolsgui.h>
#import "ObserverSwarm.h"
#import "BatchObserverSwarm.h"

int main (int argc, const char **argv)
{
  id topLevelSwarm;

 printf("\nSTARTING Swarm\n");
 printf("INITSWARM ..");
  initSwarmApp (argc, argv, "1.4.1", "bug-swarm@santafe.edu");
 printf("DONE\n");

  if (swarmGUIMode == 1)
  {    
    printf("CREATING OS (interactive mode)..\n");
    topLevelSwarm =  [ObserverSwarm createBegin: globalZone];
    SET_WINDOW_GEOMETRY_RECORD_NAME(topLevelSwarm);
    topLevelSwarm = [topLevelSwarm createEnd];
    printf("DONE\n");
  }  
  else
  {
    printf("CREATING OS (batch mode)..\n");
    topLevelSwarm =  [BatchObserverSwarm create: globalZone];
    printf("DONE\n");
  }  
     

 printf("BUILDING OS Objects, Actions, ActivateIn ..\n");
  [topLevelSwarm buildObjects];
  [topLevelSwarm buildActions];
  [topLevelSwarm activateIn: nil];	// Top-level swarm is activated in nil
 printf("DONE\n");
  
 printf("RUNNIG ..");
  [topLevelSwarm go];
  if (swarmGUIMode == 1)
    [topLevelSwarm saveSetup];
 printf("DONE\n");

  return 0;

}


