// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Resource2d.m

#import "Resource2d.h"
//#import <simtools.h>
#import <random.h>
#define maxSpotNutri 25

@implementation Resource2d


- (float) getScaledTotalNutri       {  return scaledTotalNutri;  }
- setScaledTotalNutri: (float) amt  {  scaledTotalNutri = amt; return self; }

- (long) getUnscaledTotalNutri       {  return unscaledTotalNutri;  }
- setUnscaledTotalNutri: (long) amt  {  unscaledTotalNutri = amt; return self; }

- (float) getTotalMagsBiomass       {  return totalMagsBiomass;  }
- setTotalMagsBiomass: (float) amt  {  totalMagsBiomass = amt; return self; }

- (float) getCyclRatio              {  return cyclRatio;  }
- setCyclRatio: (float) amt         {  cyclRatio = amt; return self; }

- (float) getNutriFrac          {  return nutriFrac ;  };
- setNutriFrac: (float) amt     {  nutriFrac = amt; return self; };


/*
-(double) getTotal
{
 long sum;
 int  x, y;
 
 [self updateLattice];
 sum = 0;
 for( x=0; x<xsize ; x++)
   for( y=0; y<ysize ; y++)
     sum += [self getValueAtX: x Y: y];
 return (double)sum;
}

-seedNutriWithProb: (float) seedProb 
{
  int x,y, amount;        // xsize, ysize - internal parameters of Discr2d.h

  seedProb = seedProb/100.0;
  for (y = 0; y < ysize; y++) 
    for (x = 0; x < xsize; x++) 
    {  
      if ([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] < seedProb) 
      {
        amount = [uniformIntRand getIntegerWithMin: 0 withMax: maxSpotNutri-1];
	[self incrementValue: amount atX: x Y: y];
      }
    }  
  return self;
}

-seedSlopeNutriAtX: (int) midX Y: (int) midY
{ 
  int x,y, amount;        // xsize, ysize - internal parameters of Discr2d.h
  
  for (y = 0; y < ysize; y++) 
    for (x = 0; x < xsize; x++) 
    {  
      amount = (int) ((x+1)*(y+1)*(1.0/(xsize+ysize))/8.);
      [self incrementValue: amount atX: x Y: y];
    }  
  return self;
}

-seedCircleNutriAtX: (int) midX Y: (int) midY
{
  int x,y, amount;        // xsize, ysize - internal parameters of Discr2d.h
  
  for (y = 0; y < ysize; y++) 
    for (x = 0; x < xsize; x++) 
    {  
      amount=(int)(maxSpotNutri*.01*(xsize*xsize*2)/(1.0+(x-midX)*(x-midX)+(y-midY)*(y-midY)));
      [self incrementValue: amount atX: x Y: y];
    }  
  return self;
}

- incrementValueXXX: (int) delta atX: (int) x Y: (int) y
{
  int newVal;
  newVal = delta + [self getValueAtX: x Y: y];
  if( newVal > maxSpotNutri ) 
   newVal = maxSpotNutri;
 [self putValue: newVal atX: x Y:y];
  return self;
}
*/

@end






