// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// observerSwarm.m

#import "ObserverSwarm.h"
#import "ModelSwarm.h"
#import <collections.h>
#import <objectbase.h>
#import <analysis.h>
#import <activity.h>
#import <gui.h>
#import <simtools.h>


static const char *histColors[] = {  
  "red","blue", "orange","darkgreen", "magenta",  "purple", "green","grey50", 
  "plum3", "black", "cyan", "brown" 
};


@implementation ObserverSwarm

+ createBegin: aZone
{
  ObserverSwarm *obj;
  id <ProbeMap> probeOSMap;

 printf("  OS: createBegin ..");
       // createBegin: here we set up the default simulation parameters.
  obj = [super createBegin: aZone];

  obj->displayFrequency  = 1;
  obj->drawNutriDisplays = 0;
  obj->useSetupFile      = 0;
  obj->loadRandSeed      = 0;
  obj->saveGraphs        = 0;
  obj->drawWorld         = 1;
  obj->worldBgNutri      = 1;
  obj->drawPopulGr       = 1;
  obj->drawNutrisGr      = 1;
  obj->drawNutriFracsGr  = 1;
  obj->drawFreeBiomassGr = 1;
  obj->drawCyclRatiosGr  = 1;
  obj->drawMagsBiomassGr = 1;
  obj->drawContribNutriGr= 1;
  obj->drawIOCardStatGr  = 1;
  obj->drawIOEntropyGr   = 1;
  obj->drawOptFracsStatGr= 1;
  obj->drawMetabGr       = 1;
  obj->drawMagIOHist     = 1;
  obj->drawIOCardHist    = 1;
  obj->drawSizeDistGr    = 0;
  obj->tik               = 0;
  obj->expTime           = 0;
  
  probeOSMap = [EmptyProbeMap createBegin: aZone];
  [probeOSMap setProbedClass: [self class]];
  probeOSMap = [probeOSMap createEnd];

  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "useSetupFile"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "loadRandSeed"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "saveGraphs"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawWorld"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "worldBgNutri"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawNutriDisplays"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawPopulGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawNutrisGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawNutriFracsGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawFreeBiomassGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawCyclRatiosGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawMagsBiomassGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawContribNutriGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawIOEntropyGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawIOCardStatGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawOptFracsStatGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawMetabGr"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawMagIOHist"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawIOCardHist"
                                    inClass: [self class]]];
  [probeOSMap addProbe: [probeLibrary getProbeForVariable: "drawSizeDistGr"
                                    inClass: [self class]]];

  [probeLibrary setProbeMap: probeOSMap For: [self class]];

 printf("Done\n");
    return obj;
}

- createEnd
{
  printf("  OS: createEnd     Done\n");
  return [super createEnd];
}

- buildObjects
{
  id magList;
  id reaperQueue, birthQueue;
  char text[10];
  int i, nutrisNum;
  int smZoom,bigZoom;
  float step,m;
  id <ButtonPanel> panelWidget;
  double maxNutri;

 printf("  OS: buildObjects ..");

  [super buildObjects];
  [ObjectLoader load: self fromAppConfigFileNamed: "observer.setup"];
 
  panelWidget = [actionCache getPanel];      // adding button to ControlPanel
  [panelWidget addButtonName: "SaveSim"
		      target: self
		      method: M(saveModel)];

  CREATE_ARCHIVED_PROBE_DISPLAY (self);      

  [controlPanel setStateStopped];

  modelSwarm = [ModelSwarm create: self ];
  [modelSwarm setDisplayFreq: displayFrequency ];

  if(useSetupFile == 1)
    [modelSwarm loadMS];
  if( loadRandSeed == 1 )
    [modelSwarm loadRandGenSeed];
  CREATE_ARCHIVED_PROBE_DISPLAY (modelSwarm); // creating param. windows

  [controlPanel setStateStopped];
  [modelSwarm buildObjects];
  //  CREATE_ARCHIVED_PROBE_DISPLAY ([modelSwarm getNutrisList]);
  //  CREATE_ARCHIVED_PROBE_DISPLAY ([modelSwarm getNutriAtIndex: 0]);
  
  magList = [modelSwarm getMagList];
  reaperQueue = [modelSwarm getReaperQueue];
  birthQueue = [modelSwarm getBirthQueue];
  nutrisNum =  [modelSwarm getNutrisNum];
    
  // ColorMap 0..10 reserved for bugs colors
  //          10..30 levels of grey for nutri levels
  colorMap = [Colormap create: self];
  maxNutri = (double) MAX;
  m = 0.4; step = (1-m)/20;
  [colorMap setColor: 10 ToName: "black"];
  for(i=1; i<21;i++)
    [colorMap setColor: i+10 ToRed: m+i*step Green: m+i*step Blue: m+i*step];

  [colorMap setColor: 0 ToName: "black"];
  [colorMap setColor: 1 ToRed: 0.6 Green: 0.7 Blue: 1];   // static mag
  [colorMap setColor: 2 ToRed: 1 Green: 0.6 Blue: 1];   // moving mag-full
  [colorMap setColor: 3 ToRed: 0.7 Green: 0.9 Blue: 0.5];   // new mag
  [colorMap setColor: 4 ToRed: 0.7 Green: 0.0 Blue: 0];   // moving mag-partial
  [colorMap setColor: 5 ToName: "green"];    // bioNew
  [colorMap setColor: 6 ToName: "blue"];     // bioStatic
  [colorMap setColor: 7 ToName: "magenta"];  // bioFullstep
  [colorMap setColor: 8 ToName: "red"];      // bio Part step
  smZoom = SmZOOM; bigZoom=BigZOOM;
  if(  [[modelSwarm getWorld] getSizeX] < 11)
  {
    smZoom = 10+smZoom;
    bigZoom = 20+bigZoom;   
  } 
  if( drawNutriDisplays==1 )
  {  
    if(nutrisNum > 0)
    {  
      w1Raster = [ZoomRaster createBegin: self];
      SET_WINDOW_GEOMETRY_RECORD_NAME (w1Raster);
      w1Raster = [w1Raster createEnd];
      [w1Raster setColormap: colorMap];
      [w1Raster setZoomFactor: smZoom ];
      [w1Raster setWidth: [[modelSwarm getWorld] getSizeX]
                 Height: [[modelSwarm getWorld] getSizeY]];
      [w1Raster setWindowTitle: "Nutrient A"];
      [w1Raster pack];                             // draw the window.

      f1D = [Value2dDisplay createBegin: self];
      [f1D setDisplayWidget: w1Raster colormap: colorMap];
      [f1D setDiscrete2dToDisplay:   [modelSwarm getNutriAtIndex: 0]];
      [f1D setDisplayMappingM: maxNutri/20 C: 10];
      f1D = [f1D createEnd];
    }
    if(nutrisNum > 1)
    {  
      w2Raster = [ZoomRaster createBegin: self];
      SET_WINDOW_GEOMETRY_RECORD_NAME (w2Raster);
      w2Raster = [w2Raster createEnd];
      [w2Raster setColormap: colorMap];
      [w2Raster setZoomFactor: smZoom ];
      [w2Raster setWidth: [[modelSwarm getWorld] getSizeX]
                 Height: [[modelSwarm getWorld] getSizeY]];
      [w2Raster setWindowTitle: "Nutrient B"];
      [w2Raster pack];                             // draw the window.

      f2D = [Value2dDisplay createBegin: self];
      [f2D setDisplayWidget: w2Raster colormap: colorMap];
      [f2D setDiscrete2dToDisplay:  [modelSwarm getNutriAtIndex: 1]];
      [f2D setDisplayMappingM:  maxNutri/20 C: 10];
      f2D = [f2D createEnd];
    }
    if(nutrisNum > 2)
    {  
      w3Raster = [ZoomRaster createBegin: self];
      SET_WINDOW_GEOMETRY_RECORD_NAME (w3Raster);
      w3Raster = [w3Raster createEnd];
      [w3Raster setColormap: colorMap];
      [w3Raster setZoomFactor: smZoom ];
      [w3Raster setWidth: [[modelSwarm getWorld] getSizeX]
                 Height: [[modelSwarm getWorld] getSizeY]];
      [w3Raster setWindowTitle: "Nutrient C"];
      [w3Raster pack];                             // draw the window.

      f3D = [Value2dDisplay createBegin: self];
      [f3D setDisplayWidget: w3Raster colormap: colorMap];
      [f3D setDiscrete2dToDisplay:  [modelSwarm getNutriAtIndex: 2]];
      [f3D setDisplayMappingM:  maxNutri/20 C: 10];
      f3D = [f3D createEnd];
    }
    if(nutrisNum > 3)
    {  
      w4Raster = [ZoomRaster createBegin: self];
      SET_WINDOW_GEOMETRY_RECORD_NAME (w4Raster);
      w4Raster = [w4Raster createEnd];
      [w4Raster setColormap: colorMap];
      [w4Raster setZoomFactor: smZoom ];
      [w4Raster setWidth: [[modelSwarm getWorld] getSizeX]
                 Height: [[modelSwarm getWorld] getSizeY]];
      [w4Raster setWindowTitle: "Nutrient D"];
      [w4Raster pack];                             // draw the window.

      f4D = [Value2dDisplay createBegin: self];
      [f4D setDisplayWidget: w4Raster colormap: colorMap];
      [f4D setDiscrete2dToDisplay: [modelSwarm getNutriAtIndex: 3]];
      [f4D setDisplayMappingM: maxNutri/20 C: 10];
      f4D = [f4D createEnd];
    }  
  }
  
  if(drawWorld == 1)
  {
    worldRaster = [ZoomRaster createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME (worldRaster);
    worldRaster = [worldRaster createEnd];
    [worldRaster setColormap: colorMap];
    [worldRaster setZoomFactor: bigZoom ];
    [worldRaster setWidth: [[modelSwarm getWorld] getSizeX]
                 Height: [[modelSwarm getWorld] getSizeY]];
    [worldRaster setWindowTitle: "The World"];
    [worldRaster pack];                             // draw the window.

    nutriDisplay = [Value2dDisplay createBegin: self ];
    [nutriDisplay setDisplayWidget: worldRaster colormap: colorMap ];
    if(worldBgNutri <= 2*nutrisNum && worldBgNutri > 0)  // background acc.to given value
      [nutriDisplay setDiscrete2dToDisplay: 
		     [modelSwarm getNutriAtIndex: worldBgNutri-1 ]];
    else 
           //if out of range, draw nothing = draw black 
           //                 = draw empty nutri space[nutrisNum]
      [nutriDisplay setDiscrete2dToDisplay: 
    		     [modelSwarm getNutriAtIndex: 2*nutrisNum ]];
    [nutriDisplay setDisplayMappingM: maxNutri/20 C: 10];
    nutriDisplay = [nutriDisplay createEnd];
    
    magDisplay = [Object2dDisplay createBegin: self];
    [magDisplay setDisplayWidget: worldRaster];
    [magDisplay setDiscrete2dToDisplay: [modelSwarm getWorld]];
    [magDisplay setObjectCollection: [modelSwarm getMagList]];
    [magDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
    magDisplay = [magDisplay createEnd];

    [worldRaster setButton: ButtonRight
		 Client: magDisplay
		 Message: M(makeProbeAtX:Y:)];
  }


  // =============================  GRAPHS ==================================

  if(drawPopulGr==1)
  {  
    populationGraph = [EZGraph createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME(populationGraph);
    [populationGraph setTitle: "Population"];
    [populationGraph setAxisLabelsX: "time" Y: "agents"];
    [populationGraph setGraphics: 1];
    [populationGraph setFileOutput: saveGraphs];
    [populationGraph setFileName: "data/data.population"];
    populationGraph = [populationGraph createEnd];
    //   [ObjectSaver save: populationGraph toFileNamed: "popGraph"] ;
    [populationGraph createSequence: "Population"
                      withFeedFrom: magList
    		     andSelector: M(getCount)];
    [populationGraph createSequence: "Births"
		     withFeedFrom: modelSwarm
		     andSelector: M(getBirthsNum)];
    [populationGraph createSequence: "Deaths"
		     withFeedFrom: modelSwarm
		     andSelector: M(getDeathsNum)];
    [populationGraph createAverageSequence: "Age_avg"
                     withFeedFrom: magList
		     andSelector: M(getMagAge)];
    /*    [populationGraph createSequence: "Mutations"
		     withFeedFrom: modelSwarm 
		     andSelector: M(getMutationsCnt)];*/
    [populationGraph createTotalSequence: "enz_Mag"
		     withFeedFrom: magList
		     andSelector: M(getEnzMag)];
  }

  if(drawNutrisGr==1)
  {  
    allNutriGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(allNutriGraph);
    [allNutriGraph setTitle: "Amount of nutrients"];
    [allNutriGraph setAxisLabelsX: "time" Y: "nutrient"];
    [allNutriGraph setFileOutput: saveGraphs];
    [allNutriGraph setFileName: "data/data.nutris"];
    allNutriGraph = [allNutriGraph createEnd];
    for(i=0; i<nutrisNum; i++)
    {  
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_nutri");
      [allNutriGraph createSequence: text
		 withFeedFrom: [modelSwarm getNutriAtIndex: i]
		 andSelector: M(getScaledTotalNutri)]; 
    }		 
  }	

  if(drawNutriFracsGr==1)
  {  
    allNutriFracsGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(allNutriFracsGraph);
    [allNutriFracsGraph setTitle: "Amount of nutrients' fractions"];
    [allNutriFracsGraph setAxisLabelsX: "time" Y: "nutrient fraction"];
    [allNutriFracsGraph setFileOutput: saveGraphs];
    [allNutriFracsGraph setFileName: "data/data.nutriFracs"];
    allNutriFracsGraph = [allNutriFracsGraph createEnd];
    for(i=0; i<nutrisNum; i++)
    {  
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_nutri");
      [allNutriFracsGraph createSequence: text
		 withFeedFrom: [modelSwarm getNutriAtIndex: i]
		 andSelector: M(getNutriFrac)]; 
    }		 
  }	
	 
  if(drawFreeBiomassGr==1)
  {  
    freeBiomassGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(freeBiomassGraph);
    [freeBiomassGraph setTitle: "Amount of free biomass"];
    [freeBiomassGraph setAxisLabelsX: "time" Y: "biomass"];
    [freeBiomassGraph setFileOutput: saveGraphs];
    [freeBiomassGraph setFileName: "data/data.fBiomass"];
    freeBiomassGraph = [freeBiomassGraph createEnd];
    for(i=0; i<nutrisNum; i++)
    {  
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_bioM");
      [freeBiomassGraph createSequence: text
		 withFeedFrom: [modelSwarm getNutriAtIndex: i+nutrisNum]
		 andSelector: M(getScaledTotalNutri)]; 
    }		 
  }	
	 
  if(drawCyclRatiosGr==1)
  {   
    cyclRatiosGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(cyclRatiosGraph); 
    [cyclRatiosGraph setTitle: "Cycling Ratios"]; 
    [cyclRatiosGraph setAxisLabelsX: "time" Y: "Cycling Ratio"]; 
    [cyclRatiosGraph setFileOutput: saveGraphs];
    [cyclRatiosGraph setFileName: "data/data.cyclRatios"];
    cyclRatiosGraph = [cyclRatiosGraph createEnd]; 
    for(i=0; i<[modelSwarm getNutrisNum]; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
      [cyclRatiosGraph createSequence: text
		       withFeedFrom: [modelSwarm getNutriAtIndex: i]
		       andSelector: M(getCyclRatio)]; 
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
      /* I just hope order of calling selector will stay the same
      [cyclRatiosGraph createSequence: text 
		       withFeedFrom: modelSwarm 
		       andSelector: M(getCyclRatios)]; */
    }		  
  }		  

  if(drawMagsBiomassGr==1)
  {   
    magsBiomassGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(magsBiomassGraph); 
    [magsBiomassGraph setTitle: "Mags' biomass"]; 
    [magsBiomassGraph setAxisLabelsX: "time" Y: "nutrient"]; 
    [magsBiomassGraph setFileOutput: saveGraphs];
    [magsBiomassGraph setFileName: "data/data.mBiomass"];
    magsBiomassGraph = [magsBiomassGraph createEnd]; 
    for(i=0; i<[modelSwarm getNutrisNum]; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
      [magsBiomassGraph createSequence: text
		     withFeedFrom: [modelSwarm getNutriAtIndex: i]
		     andSelector: M(getTotalMagsBiomass)]; 
    }		  
  }		  

  if(drawContribNutriGr==1)
  {   
    magsContribNutrisGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(magsContribNutrisGraph); 
    [magsContribNutrisGraph setTitle: "Total production/consumption"]; 
    [magsContribNutrisGraph setAxisLabelsX: "time" Y: "nutrient"]; 
    [magsContribNutrisGraph setFileOutput: saveGraphs];
    [magsContribNutrisGraph setFileName: "data/data.contribNuts"];
    magsContribNutrisGraph = [magsContribNutrisGraph createEnd]; 
    for(i=0; i<[modelSwarm getNutrisNum]; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
       // I just hope order of calling selector will stay the same
      [magsContribNutrisGraph createSequence: text
		      withFeedFrom: modelSwarm
		      andSelector: M(getContribNutri)]; 
    }		  
  }		  

  if(drawIOEntropyGr==1)
  {  
    ioEntropyGraph = [EZGraph createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME(ioEntropyGraph);
    [ioEntropyGraph setTitle: "Input/Output/Enzyme entropy"];
    [ioEntropyGraph setAxisLabelsX: "time" Y: "entropy"];
    [ioEntropyGraph setFileOutput: saveGraphs];
    [ioEntropyGraph setFileName: "data/data.entropy"];
    ioEntropyGraph = [ioEntropyGraph createEnd];
    [ioEntropyGraph createSequence: "input"
                     withFeedFrom: modelSwarm
		     andSelector: M(getInEntropy)];
    [ioEntropyGraph createSequence: "output"
                     withFeedFrom: modelSwarm
		     andSelector: M(getOutEntropy)];
    [ioEntropyGraph createSequence: "enzyme"
                     withFeedFrom: modelSwarm
		     andSelector: M(getEnzEntropy)];
  }
  
  if(drawIOCardStatGr==1)
  {  
    ioCardStatGraph = [EZGraph createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME(ioCardStatGraph);
    [ioCardStatGraph setTitle: "Input/Output/Enzyme cardinality statistics"];
    [ioCardStatGraph setAxisLabelsX: "time" Y: "avg , std.deviation"];
    [ioCardStatGraph setFileOutput: saveGraphs];
    [ioCardStatGraph setFileName: "data/data.ioCardStat"];
    ioCardStatGraph = [ioCardStatGraph createEnd];
    [ioCardStatGraph createSequence: "in_card_avg"
                     withFeedFrom: modelSwarm
		     andSelector: M(getInCardAvg)];
    [ioCardStatGraph createSequence: "out_card_avg"
                     withFeedFrom: modelSwarm
		     andSelector: M(getOutCardAvg)];
    [ioCardStatGraph createSequence: "enz_card_avg"
                     withFeedFrom: modelSwarm
		     andSelector: M(getEnzCardAvg)];
    [ioCardStatGraph createSequence: "in_card_std"
                     withFeedFrom: modelSwarm
		     andSelector: M(getInCardStd)];
    [ioCardStatGraph createSequence: "out_card_std"
                     withFeedFrom: modelSwarm
		     andSelector: M(getOutCardStd)];
    [ioCardStatGraph createSequence: "enz_card_std"
                     withFeedFrom: modelSwarm
		     andSelector: M(getEnzCardStd)];
    }
  
  if(drawOptFracsStatGr==1)
  {  
    optFracsStatGraph = [EZGraph createBegin: self];
    SET_WINDOW_GEOMETRY_RECORD_NAME(optFracsStatGraph);
    [optFracsStatGraph setTitle: "Optimal NutriFracs Error statistics"];
    [optFracsStatGraph setAxisLabelsX: "time" Y: "error"];
    [optFracsStatGraph setFileOutput: saveGraphs];
    [optFracsStatGraph setFileName: "data/data.optStat"];
    optFracsStatGraph = [optFracsStatGraph createEnd];
    [optFracsStatGraph createSequence: "globalErr"
                     withFeedFrom: modelSwarm
		     andSelector: M(getOptFracsError)];
    [optFracsStatGraph createAverageSequence: "avgLocalErr"
                     withFeedFrom: magList
		     andSelector: M(getD)];
    [optFracsStatGraph createSequence: "IFD"
                     withFeedFrom: modelSwarm
		     andSelector: M(getIFD)];
 }
  
  if(drawMetabGr==1)
  {  
    metabGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(metabGraph);
    [metabGraph setTitle: "Amount of Average metabRates"];
    [metabGraph setAxisLabelsX: "time" Y: "Rate"];
    [metabGraph setFileOutput: saveGraphs];
    [metabGraph setFileName: "data/data.MetabRates"];
    metabGraph = [metabGraph createEnd];
    [metabGraph createAverageSequence: "totalMetab"
                   withFeedFrom: magList
		   andSelector: M(getTotalMetab)];
        // special moveMetab to count only Mags which hasMoved = 1
    [metabGraph createSequence: "moveMetab"     
                   withFeedFrom: modelSwarm
		   andSelector: M(getMoveMetabAvg)];
    [metabGraph createAverageSequence: "consRate"
                   withFeedFrom: magList 
		   andSelector: M(getConsRate)];
    [metabGraph createAverageSequence: "magSize"
                   withFeedFrom: magList
		   andSelector: M(getMagSize)];
    [metabGraph createAverageSequence: "vision"
                   withFeedFrom: magList
		   andSelector: M(getVision)];
    [metabGraph createAverageSequence: "maxMR"
                   withFeedFrom: magList
		   andSelector: M(getMaxMR)];
    /*    [metabGraph createSequence: "enzMetab"     
                   withFeedFrom: modelSwarm
		   andSelector: M(getEnzMetabAvg)]; */
    [metabGraph createAverageSequence: "satisfMetab"     
                   withFeedFrom: magList
		   andSelector: M(getSatisfMetab)];
  }

  if(drawMagIOHist==1)
  {  
    const char *pred[MAXNUTRIS*3+1];/* = {"A inp","B inp","C inp","D inp",
			  "A out","B out","C out","D out",
			  "A in-out","B in-out","C in-out","D in-out",
				"x","x","x","x","x"}; */
    for(i=0; i< nutrisNum;i++)
    {
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_in");
      pred[i]= strdup(text);
    }
    for(i=0; i< nutrisNum;i++)
    {
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_out");
      pred[nutrisNum+i]= strdup(text);
    }
    for(i=0; i< nutrisNum;i++)
    {
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_enz");
      pred[2*nutrisNum+i]= strdup(text);
    }
      
      
    magIOHisto = [Histogram createBegin: globalZone]; 
    SET_WINDOW_GEOMETRY_RECORD_NAME (magIOHisto);
    [magIOHisto setBinCount: ([modelSwarm getNutrisNum]*3)];
    magIOHisto = [magIOHisto createEnd];

    [magIOHisto enableDestroyNotification: self
            notificationMethod: @selector(_histogramDeath_:)];
    [magIOHisto setWidth: 500 Height: 286];
    [magIOHisto setLabels: pred  count:  3*[modelSwarm getNutrisNum]];
    [magIOHisto setColors: histColors count: [modelSwarm getNutrisNum]];
    [magIOHisto setTitle: "Input/Output/Enzyme distribution "];
    [magIOHisto setAxisLabelsX: "nutrient type" Y: "usage of nutrient"];
    [magIOHisto pack];
  }		 

  if(drawIOCardHist==1)
  {  
    const char *pred[MAXNUTRIS*3+3];
    for(i=0; i< nutrisNum+1;i++)
    {
      sprintf(text,"%d",i);         // rising 0,1,2,... 
      strcat(text,"_in's");
      pred[i]= strdup(text);
    }
    for(i=0; i< nutrisNum+1;i++)
    {
      sprintf(text,"%d",i);         // rising 0,1,2,... 
      strcat(text,"_out's");
      pred[ nutrisNum+1 + i ]= strdup(text);
    }
    for(i=0; i< nutrisNum+1;i++)
    {
      sprintf(text,"%d",i);         // rising 0,1,2,... 
      strcat(text,"_enz's");
      pred[ 2*nutrisNum+2 + i ]= strdup(text);
    }
    ioCardHisto = [Histogram createBegin: globalZone]; 
    SET_WINDOW_GEOMETRY_RECORD_NAME (ioCardHisto);
    [ioCardHisto setBinCount: (nutrisNum*3+3)];
    ioCardHisto = [ioCardHisto createEnd];

    [ioCardHisto enableDestroyNotification: self
            notificationMethod: @selector(_ioCardDeath_:)];

    [ioCardHisto setWidth: 500 Height: 330];
    [ioCardHisto setLabels: pred count: 3*([modelSwarm getNutrisNum]+3)];
    [ioCardHisto setColors: histColors count: nutrisNum+1];
    [ioCardHisto setTitle: "Cardinality of Inputs/Outputs/Enzymes"];
    [ioCardHisto setAxisLabelsX: "Cardinality" Y: "Number of Mags"];
    [ioCardHisto pack];
  }		 

  if(drawSizeDistGr==1)
  {  
     sizeDistGraph = [EZBin createBegin: [self getZone]];
     SET_WINDOW_GEOMETRY_RECORD_NAME(sizeDistGraph);
     [sizeDistGraph setTitle: "Distribution of size"];
     [sizeDistGraph setAxisLabelsX: "size" Y: "# of mags"]; 
     [sizeDistGraph setBinCount: 10];       // [modelSwarm getReproSize]+1];
     [sizeDistGraph setLowerBound: 0];
     [sizeDistGraph setUpperBound: [modelSwarm getReproSize]];
     [sizeDistGraph setCollection: magList];
     [sizeDistGraph setProbedSelector: M(getMagSize)];
     sizeDistGraph = [sizeDistGraph createEnd];
     // local satisfactio error histogram
//     sizeDistGraph = [EZBin createBegin: [self getZone]];
//     SET_WINDOW_GEOMETRY_RECORD_NAME(sizeDistGraph);
//     [sizeDistGraph setTitle: "Distribution of Mags' satisfaction"];
//     [sizeDistGraph setAxisLabelsX: "size" Y: "# of mags"];
//     [sizeDistGraph setBinNum: 10];       // [modelSwarm getReproSize]+1];
//     [sizeDistGraph setPrecision: 1];       // [modelSwarm getReproSize]+1];
//     [sizeDistGraph setLowerBound: 0];
//     [sizeDistGraph setUpperBound: 2];
//     [sizeDistGraph setCollection: magList];
//     [sizeDistGraph setProbedSelector: M(getD)];
//     sizeDistGraph = [sizeDistGraph createEnd];
  }
 printf("  Done\n");
	       	       
  return self;
}

- _updHistG_
{
  if(sizeDistGraph)
  {
    [sizeDistGraph reset];
    [sizeDistGraph update];
    [sizeDistGraph output];
  }
  return self;
}

- _updIOGr_
{
  if(magIOHisto)
    [magIOHisto drawHistogramWithInt: [modelSwarm getIODist]];
  return self;
}

- _updIOCardGr_
{
  if(ioCardHisto)
    [ioCardHisto drawHistogramWithInt: [modelSwarm getIOCard]];
  return self;
}

- _histogramDeath_ : caller
{
  [magIOHisto drop];
  magIOHisto = nil;
  return self;
}

- _IOCardDeath_ : caller
{
  [ioCardHisto drop];
  ioCardHisto = nil;
  return self;
}

- tick
{
//  printf("\n\t%d ",tik++ );
  printf("\n\t%d \t %d\t %d\t %d",tik++,[[modelSwarm getMagList] getCount],
 [[modelSwarm getReaperQueue] getCount],[[modelSwarm getBirthQueue] getCount]);
  return self;
}

- buildActions
{
  int nutrisNum;
 printf("  OS: buildActions ..");

  [super buildActions];
  [modelSwarm buildActions];
  nutrisNum=[modelSwarm getNutrisNum];
  
  displayActions = [ActionGroup create: self];

  if(drawWorld == 1)
  {
    //    if(worldBgNutri <= nutrisNum && worldBgNutri > 0)
      [displayActions createActionTo: nutriDisplay         message: M(display)];
    [displayActions createActionTo: magDisplay          message: M(display)];
    [displayActions createActionTo: worldRaster         message: M(drawSelf)];
  }
  if( drawNutriDisplays==1 )
  { 
    if(nutrisNum > 0)     {  
      [displayActions createActionTo: f1D             message: M(display)];
      [displayActions createActionTo: w1Raster        message: M(drawSelf)];
    }
    if(nutrisNum > 1)     {  
      [displayActions createActionTo: f2D             message: M(display)];
      [displayActions createActionTo: w2Raster        message: M(drawSelf)];
    }
     if(nutrisNum > 2)     {  
      [displayActions createActionTo: f3D             message: M(display)];
      [displayActions createActionTo: w3Raster        message: M(drawSelf)];
    }
     if(nutrisNum > 3)     {  
      [displayActions createActionTo: f4D             message: M(display)];
      [displayActions createActionTo: w4Raster        message: M(drawSelf)];
    }
  }
  if(drawPopulGr == 1) 
          [displayActions createActionTo: populationGraph   message: M(step)];
  if(drawNutrisGr == 1)	       	       
          [displayActions createActionTo: allNutriGraph     message: M(step)];
  if(drawNutriFracsGr == 1)	       	       
          [displayActions createActionTo: allNutriFracsGraph message: M(step)];
  if(drawFreeBiomassGr == 1)	       	       
          [displayActions createActionTo: freeBiomassGraph  message: M(step)];
  if(drawCyclRatiosGr == 1)	       	       
          [displayActions createActionTo: cyclRatiosGraph   message: M(step)];
  if(drawMagsBiomassGr == 1)	       	       
          [displayActions createActionTo: magsBiomassGraph  message: M(step)];
  if(drawContribNutriGr == 1)	       	       
          [displayActions createActionTo: magsContribNutrisGraph    message: M(step)];
  if(drawIOEntropyGr == 1)	       	       
          [displayActions createActionTo: ioEntropyGraph    message: M(step)];
  if(drawIOCardStatGr == 1)	       	       
          [displayActions createActionTo: ioCardStatGraph   message: M(step)];
  if(drawOptFracsStatGr == 1)	       	       
          [displayActions createActionTo: optFracsStatGraph message: M(step)];
  if(drawMetabGr == 1)	       	       
          [displayActions createActionTo: metabGraph        message: M(step)];
  if(drawMagIOHist == 1)	       	       
          [displayActions createActionTo: self      message: M(_updIOGr_)];
  if(drawIOCardHist == 1)	       	       
          [displayActions createActionTo: self      message: M(_updIOCardGr_)];
  if(drawSizeDistGr == 1)	       	     
          [displayActions createActionTo: self      message: M(_updHistG_)];

  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: self                message: M(checkStop)];
  [displayActions createActionTo: actionCache         message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
  
 printf("Done\n");
 
  return self;
}

-saveSetup
{
  //  [modelSwarm setExperimentTime: expTime ];
  [modelSwarm saveMSto: "model.setup"];
  [ObjectSaver save: self toFileNamed: "observer.setup"
	       withTemplate:[probeLibrary getProbeMapFor: [self class]]];
  printf("\nSaved model.setup\n");
  return self;
}

-saveModel       // called by SaveSim button or when all Mags are dead
{
  id pixId;
  char filename[MAXFILENAME];

  printf("\n\007  Saving picture 's%s.png' ..",[modelSwarm getSimName]);
  if( strlen([modelSwarm getSimName]) > MAXFILENAME-1 )
    [InvalidCombination raiseEvent: "\n OS: Simulation name too long"]; 
  sprintf (filename, "s%s.png",[modelSwarm getSimName]);
  pixId = [Pixmap createBegin:[self getZone]];
  [pixId setWidget: nil];             // ('nil'=>root window)
  pixId = [pixId createEnd]; 
  [pixId save: filename];
  [pixId drop];

  if(useSetupFile == 1)
  {
    sprintf (filename, "s%s.setup",[modelSwarm getSimName]);
    [modelSwarm saveMSto: filename];
  }
  printf(".. Done");
  return self;
}

-checkStop
{
  //  char text[MAXFILENAME+20];

  //  expTime += displayFrequency;
  //  [modelSwarm setExperimentTime: expTime ];
  if( [[modelSwarm getMagList] getCount]== 0 )
  {  
    printf("\nAll mags dead\n\007");
    [controlPanel setStateStopped];
    if(useSetupFile == 1)
      [self saveModel];
  }    
  return self;
}


- activateIn: swarmContext
{
 printf("  OS: ActivateIn ..");

  [super activateIn: swarmContext];
  [modelSwarm activateIn: self];

  [displaySchedule activateIn: self];

 printf("Done \n");
  return [self getSwarmActivity];
}

@end















