// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

 // ObserverSwarm.h

#import "ModelSwarm.h"
#import "MultiScaled2d.h"
#import <simtoolsgui.h>
#import <analysis.h>
#import <objectbase/SwarmObject.h>
#import <objectbase.h>
#import <simtoolsgui/GUISwarm.h>

#define MAX 10000     // my set maximal value at discrete2d
#define MAXNUTRIS 10      // max. number of Nutris
#define MAXFILENAME 100  // max. lenght of simulation name
#define HiCol 0.7
#define LoCol 0.5
#define SmZOOM 1
#define BigZOOM 3

@interface ObserverSwarm: GUISwarm
{
  int displayFrequency;   
  int drawNutriDisplays;
  int useSetupFile;
  int loadRandSeed;
  int saveGraphs;
  int drawWorld;
  int worldBgNutri;
  int drawPopulGr;      
  int drawNutrisGr;
  int drawNutriFracsGr;
  int drawFreeBiomassGr;
  int drawMagsBiomassGr;
  int drawContribNutriGr;
  int drawMetabGr;
  int drawCyclRatiosGr;
  int drawIOCardStatGr;
  int drawIOEntropyGr;
  int drawOptFracsStatGr;
  int drawSizeDistGr;
  int drawMagIOHist;
  int drawIOCardHist;
  int tik;
  unsigned expTime;    // current time steps of experiment
  //  long zbits;

  id displayActions;                          
  id displaySchedule;

  ModelSwarm *modelSwarm;          	      
  //  MultiScaled2d *multidiscrete2d;

                                                //widgets
  id <Colormap> colorMap;                       // allocate colours
  id <ZoomRaster> worldRaster;                  // 2d display widget
  id <ZoomRaster> w1Raster,w2Raster,w3Raster,w4Raster; // 2d display widgets

  id <EZGraph> populationGraph;    // all popul + births + deaths
  id <EZGraph> allNutriGraph;      // amt of nutritients A,B, ..
  id <EZGraph> allNutriFracsGraph; // amt of nutritients ratios [%] A,B, ..
  id <EZGraph> freeBiomassGraph;   // amt of free biomass A,B, .. in world
  id <EZGraph> cyclRatiosGraph;    // cycling ratios = min(prod,cons)/max(inF,ouF)
  id <EZGraph> magsBiomassGraph;   // nutrients (biomass) stored in Mags
  id <EZGraph> magsContribNutrisGraph;     // nutrients in space added/taken by Mags
  id <EZGraph> ioCardStatGraph;    // avg & std deviation of in/out nutris cardinality
  id <EZGraph> ioEntropyGraph;     // entropy of Mags' inputs / outputs 
  id <EZGraph> optFracsStatGraph;  // error from optimum nutri fracs. measure
  id <EZGraph> metabGraph;         // metabolisms
  id <EZBin>   sizeDistGraph;      // distrib of Mag's size
  id <Histogram> magIOHisto;       // histogram of mag inp/outp nutrients use
  id <Histogram> ioCardHisto;      // histogram of mag inp/outp cardinality
  id <ProbeMap> probeMap2;

  id <Value2dDisplay> nutriDisplay;                    // display the heat
  id <Value2dDisplay> f1D,f2D,f3D,f4D;    // display the heat
  id <Object2dDisplay> magDisplay;                    // display the Mags
}

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- saveModel;
- saveSetup;
- activateIn: swarmContext;

@end

