// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* Space with multiple discrete2d layers */

#import "MultiScaled2d.h"
#import "Resource2d.h"
#import <space/Diffuse2d.h>	
#import <random.h>

@implementation MultiScaled2d

-createGridsN: (int) num sizeX: (int)x sizeY: (int)y 
                    withDiffusion: (double) diffusion 
		    withEvaporation: (double) evaporation 
{
  Resource2d *d2d;
  int n;
  
  gridList = [List create: [self getZone]];
  if( x!=y )
    printf("\nWarning: (MultiScaled2d) different X and Y size of space !\n");
  size = x;
  for (n=0; n < num; n++)
  {
    d2d = [Resource2d createBegin: [self getZone]];
    [d2d setSizeX: x Y: y];  
    [d2d setDiffusionConstant: diffusion];
    [d2d setEvaporationRate: evaporation];
    d2d = [d2d createEnd];
    [gridList addLast: d2d]; // add to the collection
   }
  
  return self;  
}

- (float) getMaxScaledVal     {  return maxScaledVal; }

- setMaxScaledVal: (float) max   { maxScaledVal = max; return self; }

- setIOUnit: (float) u        { ioUnit = u; return self; }

- getId: (int) index{
  if( index > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: getId: too big index\n"];
  return [gridList atOffset: index];
}
  

-(float) getValueAtX: (int) x Y: (int) y atIndex: (int) i
{
  Resource2d *d2d;
  int intVal;
  float scaled;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: getValue: too big index\n"];
  d2d = [gridList atOffset: i];
  intVal = [d2d getValueAtX: x Y: y];
  scaled =  ( maxScaledVal * ((float)intVal)/MAX );
  //  printf("\n\t\tGET int:%d \tscaled:%f",intVal,scaled);
  return scaled;
}

-(int) getUnscaledValueAtX: (int) x Y: (int) y atIndex: (int) i
{
  Resource2d *d2d;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: getUnscaledValue: too big index\n"];
  d2d = [gridList atOffset: i ];
  return [d2d getValueAtX: x Y: y ];
}



-(float) getTotalAtIndex: (int) i
{
  Resource2d *d2d;
  int x, y;
  long intSum;
  float floSum;

  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: getTotalIndex: too big index\n"];
  d2d = [gridList atOffset: i];
  intSum = 0;
  for( x=0; x<size ; x++)
    for( y=0; y<size ; y++)
      intSum = intSum + [d2d getValueAtX: x Y: y];
  floSum = ( maxScaledVal * ((float)intSum)/MAX );
  [d2d setScaledTotalNutri: floSum ];
  [d2d setUnscaledTotalNutri: intSum ];
  return floSum;
}


-(long) getUnscaledTotalAtIndex: (int) i
{
  Resource2d *d2d;
  int x, y;
  long sum;

  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: getTotalIndex: too big index\n"];
  d2d = [gridList atOffset: i];
  sum = 0;
  for( x=0; x<size ; x++)
    for( y=0; y<size ; y++)
      sum = sum + [d2d getValueAtX: x Y: y];
  //  [d2d setScaledTotalNutri: sum];
  return sum;
}

- putValue: (float) v atX: (int) x Y: (int) y atIndex: (int) i 
{
  Resource2d *d2d;
  int intVal;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: putValue: too big index\n"];
  d2d = [gridList atOffset: i];
  intVal = (int) ((MAX/maxScaledVal) * v + 0.5 ); 
  //  printf("\n\t\tPUT scaled:%f \tint:%d",v,intVal);
  [d2d putValue: intVal atX: x Y: y];
  return self;
}

//=========== as putVALUE + updates layers of Diffuse2d space ==========

- putValueUpd: (float) v atX: (int) x Y: (int) y atIndex: (int) i 
{
  Resource2d *d2d;
  int intVal;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: putValueUpd: too big index\n"];
  d2d = [gridList atOffset: i];
  intVal = (int) ((MAX/maxScaledVal) * v + 0.5 ); 
  //  printf("\n\t\tPUT scaled:%f \tint:%d",v,intVal);
  [d2d putValue: intVal atX: x Y: y];
  [d2d updateLattice];
  return self;
}


- putUnscaledValueUpd: (int) v atX: (int) x Y: (int) y atIndex: (int) i 
{
  Resource2d *d2d;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: putUnscaledValueUpd: too big index\n"];
  d2d = [gridList atOffset: i ];
  [d2d putValue: v atX: x Y: y ];
  [d2d updateLattice];                   // <<<=== crucial !
  return self;
}



-(float) incrementValue: (float) delta atX: (int) x Y: (int) y atIndex: (int) i
{
  float newVal, oldVal;

  oldVal = [self getValueAtX: x Y: y atIndex: i];
  newVal = delta + oldVal;
  if( newVal > maxScaledVal )
  {
    [self putValue: maxScaledVal atX:x Y: y atIndex: i];
    return (maxScaledVal-oldVal);
  }
  [self putValue: newVal atX:x Y: y atIndex: i];
  return delta;       // return value that it could put down      
}


//=========== increments and updates layers of Diffuse2d space ==========

-(float) incrementValueUpd: (float) delta atX: (int) x Y: (int) y atIndex: (int) i
{
  float newVal, oldVal;

  oldVal = [self getValueAtX: x Y: y atIndex: i];
  newVal = delta + oldVal;
  if( newVal > maxScaledVal )
  {
    [self putValueUpd: maxScaledVal atX:x Y: y atIndex: i];
    return (maxScaledVal-oldVal);
  }
  [self putValueUpd: newVal atX:x Y: y atIndex: i];
  return delta;       // return value that it could put down      
}


-(int) incrementUnscaledValueUpd: (int) delta atX: (int) x Y: (int) y atIndex: (int) i
{
  int newVal, oldVal;

  oldVal = [self getUnscaledValueAtX: x Y: y atIndex: i ];
  newVal = delta + oldVal;
  if( newVal > MAX )
  {
    [self putUnscaledValueUpd: MAX atX:x Y: y atIndex: i ];
    return (MAX-oldVal);
  }
  [self putUnscaledValueUpd: newVal atX:x Y: y atIndex: i ];
  return delta;       // return value that it could put down      
}


- (float) takeValue: (float) reqVal atX: (int) x Y: (int) y atIndex: (int) i
{
  float realVal; //, newVal;

  realVal = [self getValueAtX: x Y: y atIndex: i];
  if( realVal < reqVal )          // if asked more than exist give max
    reqVal = realVal;
  [self putValue: realVal-reqVal atX: x Y: y atIndex: i];
  
  if( reqVal < 0)
    [InvalidCombination raiseEvent:"Multi2d: takeValue: negative nutri!\n"];
  return reqVal;     // returns value it took 
}



//=========== decrements and updates layers of Diffuse2d space ==========

- (float) takeValueUpd: (float) reqVal atX: (int) x Y: (int) y atIndex: (int) i
{
  float realVal; //, newVal;

  realVal = [self getValueAtX: x Y: y atIndex: i ];
  if( realVal < reqVal )          // if asked more than exist give max
    reqVal = realVal;
  [self putValueUpd: realVal-reqVal atX: x Y: y atIndex: i ];
  
  if( reqVal < 0)
    [InvalidCombination raiseEvent:"Multi2d: takeValueUpd: negative nutri!\n"];
  return reqVal;     // returns value it took 
}


- (int) takeUnscaledValueUpd: (int) reqVal atX: (int) x Y: (int) y atIndex: (int) i
{
  int realVal; //, newVal;

  realVal = [self getUnscaledValueAtX: x Y: y atIndex: i ];
  if( realVal < reqVal )          // if asked more than exist give max
    reqVal = realVal;
  [self putUnscaledValueUpd: realVal-reqVal atX: x Y: y atIndex: i ];
  
  if( reqVal < 0)
    [InvalidCombination raiseEvent:"Multi2d: takeUnscaledValueUpd: negative nutri!\n"];
  return reqVal;     // returns value it took 
}


//===========   adds units to space at random positions     =============
//===========    using 'rulette' system                     =============

-(float) updateInFlowBy: (float) floatVal atIndex: (int) i
{
  int x,y, done;
  int currVal, putVal, val, ioUnsUnit;
  long sumAll, maxSum, availSpace, randPointer, sum;
  float ret;

  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: updInFlow: too big index\n"];
  val = (int) (floatVal*(MAX/maxScaledVal) + 0.5);
  if( val == 0)
    return 0;
  sumAll = [[self getId: i ] getUnscaledTotalNutri];
//printf("\n CMP: storedSum:%d  realSum:%d",sumAll,[self getUnscaledTotalAtIndex: i]);
  maxSum = size*size * MAX;
  availSpace = maxSum - sumAll;
//printf("\nIN: %d:  fl:%f int:%d \t ",i,floatVal,val); 
//printf("\t mxSum:%d   avSp:%d ",maxSum, availSpace);
  if( availSpace < val) 
  {
    printf("\nInFlow: Req Val to add in nutri:%d too big, setting reqVal=availSpace=%ld",
	   i,availSpace);
    val=availSpace;
    if( val == 0)
      return 0;
  }
  currVal = val;
  ioUnsUnit = (int) (ioUnit*(MAX/maxScaledVal)+ 0.5);
                      // loop until zero , here it's our minimal possible unit (0.01)  
  done = 1;
            // if after last loops still sum == 0 i.e. no nutri is at space => STOP
  while(currVal > 0)    
  {
    if (done == 0)   // trap if roulette will take nothing
      [InvalidCombination raiseEvent: "MultiScaled:: Wrong Inflow algorithm\n"];
    done = 0; sum = 0;
    randPointer=[uniformDblRand getDoubleWithMin: 0 withMax: availSpace-1];
    for (y = 0; y < size && done == 0; y++) 
      for (x = 0; x < size && done == 0; x++) 
      {  
	sum = sum + MAX-[self getUnscaledValueAtX: x Y: y atIndex: i];
	if( sum > randPointer )
	{ 
	  putVal=[self incrementUnscaledValueUpd: ioUnsUnit atX: x Y: y atIndex: i];
	  currVal = currVal - putVal;
	  if(putVal==0)
	    printf("\n Put %d!!! i:%d, v:%d",putVal,i,currVal);
	  availSpace = availSpace - putVal;
	  done = 1;
	}
      }
  }
  if(currVal>0)
    printf("\n InFlow not 100%% putValue: %d i:%d,req val:%d",currVal,i,val); 
  ret = ( ( (float)(val-currVal) * maxScaledVal) / MAX);
//printf("\n INRet:i:%d  fl:%f", val-currVal,ret);
  return ret;           // return value that was really put down 
}

//===========  takes units to space from random positions     =============
//===========    using 'rulette' system                       =============

-(float) updateOutFlowBy: (float) floatVal atIndex: (int) i
{
  int x,y, done;
  int currVal, takenVal,val, ioUnsUnit;
  long sumAll,sum, randPointer;
  float ret;

  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: updOutFlow: too big index\n"];
  val = (int) (floatVal*(MAX/maxScaledVal) + 0.5);
  if( val == 0)
    return 0;
  sumAll = [[self getId: i ] getUnscaledTotalNutri];
//printf("\nOutFlow: nutri:%d val:%d storedSum:%d, realSum:%d",i,val,sumAll,[self getUnscaledTotalAtIndex: i]);
  if(sumAll < val) 
  {
    printf("\nOutFlow: Req Val to take in nutri:%d too big, setting reqVal=sumAll=%ld",
	   i,sumAll);
    val=sumAll;
    if( val == 0)
      return 0;
  }
  currVal = val;
  ioUnsUnit = (int) (ioUnit*(MAX/maxScaledVal)+ 0.5);
                      // loop until zero , here it's our minimal possible unit (0.01)  
  done = 1;
  while(currVal> 0)
  {
    if (done == 0)   // trap if roulette will take nothing
      [InvalidCombination raiseEvent: "MultiScaled:: Wrong Outflow algorithm\n"];
    done = 0; sum = 0;
    randPointer= [uniformDblRand getDoubleWithMin: 0 withMax: sumAll-1];
    for (y = 0; y < size && done == 0; y++) 
      for (x = 0; x < size && done == 0; x++) 
      {  
	sum = sum + [self getUnscaledValueAtX: x Y: y atIndex: i];
	if( sum > randPointer )
	{ 
	  takenVal = [self takeUnscaledValueUpd: ioUnsUnit atX: x Y: y atIndex: i];
	  currVal = currVal - takenVal;
	  if(takenVal==0)
	    printf("\n Taken %d!!! i:%d, v:%d",takenVal,i,currVal);
	  sumAll = sumAll - takenVal;
	  done = 1;
	}
      }
  }
  if(currVal>0)
    printf("\nOutFlow not 100%% takenValue: %d i:%d,req val:%d",currVal,i,val);
  ret = ( ( (float)(val-currVal) * maxScaledVal) / MAX);
//printf("\n OUTRet:i:%d  fl:%f", val-currVal,ret);
  return ret;      // return value that it really took out
}


@end



// ---------------------------- GraveYard of old functions :) -----------
/*


-(float) updateInFlowBy: (float) val atIndex: (int) i sumAllNutri: (float) sumAll
{
  int x,y, done;
  float maxSum, putVal, availSpace, currVal, randPointer, sum;
  float minUnit;

  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: updInFlow: too big index\n"];
  if( val == 0)
    return 0;
  maxSum = size*size * maxScaledVal;
  availSpace = maxSum - sumAll;
  minUnit= maxScaledVal/MAX;
  //  printf("\nIN: %d:Req:%f maxSum:%f sumAll:%f",i,val,maxSum,sumAll);
  if( availSpace < val) 
  {
    printf("\nInFlow: Req Val to add in nutri:%d too big, setting reqVal=availSpace=%f",
	   i,availSpace);
    val=availSpace-minUnit;
    if( val == 0)
      return 0;
  }
  currVal = val;
                      // loop until zero , here it's our minimal possible unit (0.01)  
  done = 1;
            // if after last loops still sum == 0 i.e. no nutri is at space => STOP
  while(currVal > minUnit)    
  {
    if (done == 0)   // trap if roulette will take nothing
      [InvalidCombination raiseEvent: "MultiScaled:: Wrong Inflow algorithm\n"];
    done = 0; sum = 0;
    randPointer=(float)[uniformDblRand getDoubleWithMin: 0 withMax: availSpace-minUnit];
    for (y = 0; y < size && done == 0; y++) 
      for (x = 0; x < size && done == 0; x++) 
      {  
	sum = sum + maxScaledVal-[self getValueAtX: x Y: y atIndex: i];
	if( sum >= randPointer )
	{ 
	  putVal=[self incrementValueUpd: ioUnit atX: x Y: y atIndex: i];
	  currVal = currVal - putVal;
	  if(putVal==0)
	    printf("\n Put %f!!! i:%d, v:%f",putVal,i,currVal);
	  availSpace = availSpace - putVal;
	  done = 1;
	}
      }
  }
  if(currVal>minUnit)
    printf("\n InFlow not 100%% putValue: %f i:%d,req val:%f",currVal,i,val);
  return val-currVal;           // return value that was really put down 
}

//===========  takes units to space from random positions     =============
//===========    using 'rulette' system                       =============

-(float) updateOutFlowBy: (float) val atIndex: (int) i sumAllNutri: (float) sumAll
{
  int x,y, done;
  float currVal, sum, takenVal,  randPointer;
  float minUnit;

  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: updOutFlow: too big index\n"];
  if( val == 0)
    return 0;
  // printf("\nOutFlow: nutri:%d val:%f sumAll:%f",i,val,sumAll);
  minUnit= maxScaledVal/MAX;
  if(sumAll < val) 
  {
    printf("\nOutFlow: Req Val to take in nutri:%d too big, setting reqVal=sumAll=%f",
	   i,sumAll);
    val=sumAll-minUnit;
    if( val == 0)
      return 0;
  }
  currVal = val;
                      // loop until zero , here it's our minimal possible unit (0.01)  
  done = 1;
  while(currVal> minUnit)
  {
    if (done == 0)   // trap if roulette will take nothing
      [InvalidCombination raiseEvent: "MultiScaled:: Wrong Outflow algorithm\n"];
    done = 0; sum = 0;
    randPointer= (float)[uniformDblRand getDoubleWithMin: 0 withMax: sumAll-minUnit];
    for (y = 0; y < size && done == 0; y++) 
      for (x = 0; x < size && done == 0; x++) 
      {  
	sum = sum + [self getValueAtX: x Y: y atIndex: i];
	if( sum >= randPointer )
	{ 
	  takenVal = [self takeValueUpd: ioUnit atX: x Y: y atIndex: i];
	  currVal = currVal - takenVal;
	  if(takenVal==0)
	    printf("\n Taken %f!!! i:%d, v:%f",takenVal,i,currVal);
	  sumAll = sumAll - takenVal;
	  done = 1;
	}
      }
  }
  if(currVal>minUnit)
    printf("\nOutFlow not 100%% takenValue: %f i:%d,req val:%f",currVal,i,val);
  return val-currVal;      // return value that it really took out
} 


-(int) updateInFlowByProb: (double) prob atIndex: (int) i;
{
  int x,y,size, time=0, putVal, notdone,putCnt, cannot;
  double area;
 
  if( prob == 0)
    return 0;
  notdone=0; putCnt=0; cannot=0;
  size = [self getM2dSizeX];
  area = size * size;
  prob = prob/100.0;
  for (y = 0; y < size; y++) 
    for (x = 0; x < size; x++) 
    {  
      if ( (putVal=[self getValueAtX: x Y: y atIndex: i]) < maxSpotNutri )
      {
	//	prob = prob + cannot/area;
	if ([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] < prob) 
	  putVal = [self incrementValue: 1 atX: x Y: y atIndex: i];
      }
      else
	cannot++;
      //      printf("\n InF%d: prob: %5.3f cannot:%d val:%d",i,prob,cannot,putVal);
    }  
  if( cannot > 0)
    printf("\n Cannot put req InFlow at %d \t%4.2f%% refused ",
	   i,100*cannot/area);
  return 0;
}

-(int) updateOutFlowByProb: (double) prob atIndex: (int) i
{
  int x,y,size, takenVal, notdone,tookCnt, cannot;
  double area;

  if( prob == 0)
    return 0;
  notdone=0; tookCnt=0;cannot =0;
  size = [self getM2dSizeX];
  area = size * size; 
  prob = prob/100.0;
  for (y = 0; y < size; y++) 
    for (x = 0; x < size; x++) 
    {  
      if ([self getValueAtX: x Y: y atIndex: i] > 0 )
      {
	//	prob = prob + cannot/area;
	if ([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] < prob) 
	  takenVal = [self takeValue: 1 atX: x Y: y atIndex: i];
      }  
      else
	cannot++;
    }
  if( cannot > 0)
    printf("\n Cannot take req OutFlow at %d \t%4.2f%%",
	   i,100*cannot/area);
  return 0;
}


- updateInFlowBy: (int) val atIndex: (int) i;
{
  int x,y,size, time=0, putVal, mxTry;

  //  printf("\n Asked%d:%d",i,val);
  if( val == 0)
    return self;
  mxTry = val * 5;
  size = [self getM2dSizeX]-1;
  while( !( val<=0 || time>mxTry) )
  {
    x = [uniformIntRand getIntegerWithMin: 0 withMax: size];
    y = [uniformIntRand getIntegerWithMin: 0 withMax: size];
    putVal=[self incrementValue: 10 atX: x Y: y atIndex: i];
    val = val - putVal;
    time ++;
  }
  if(val > 0)
    printf("\n Cannot put req InFlow at %d, rest= %d %dx try",i,val,time);
  return self;
}

- updateOutFlowBy: (int) val atIndex: (int) i
{
  int x,y,size, time=0,mxTry;

  if( val == 0)
    return self;
  size = [self getM2dSizeX]-1;
  mxTry = (size+1)*(size+1);        
  while( ! (val<=0  || time>mxTry) )
  {
    x = [uniformIntRand getIntegerWithMin: 0 withMax: size];
    y = [uniformIntRand getIntegerWithMin: 0 withMax: size];
    val = val - [self takeValue: val atX: x Y: y atIndex: i];
    time ++;
  }
  if(val > 0)
    printf("\n Cannot take req OutFlow at %d, rest= %d %dx try ",i,val,time);
  return self;
}

*/
