// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// ModelSwarm.m					

#import "ModelSwarm.h"
#import <activity.h>
#import <collections.h>
#import <simtools.h>
#import <math.h>
#import <string.h>


@implementation ModelSwarm  

- magDeath: (Mag *) mag    { [reaperQueue addLast: mag];  return self; }

- magBirth: (Mag *) mag    {  [birthQueue addLast: mag];  return self; }

- getMagList     {  return magList; }

- getReaperQueue {  return reaperQueue; }

- (int) getReproSize {  return reproSize; }

- getBirthQueue  {  return birthQueue; }

- getWorld       {  return world; }

- (float) getKmetab     {  return Kmetab; }
- (float) getKmove      {  return Kmove; }
- (float) getKconsum    {  return Kconsum; }
- (float) getKsatisf    {  return Ksatisf; }
- (float) getEnzymeCost {  return enzymeCost; }
- (float) getExpon      {  return Expon; }
- (float *) getKmetabP     {  return &Kmetab; }
- (float *) getKmoveP      {  return &Kmove; }
- (float *) getKconsumP    {  return &Kconsum; }
- (float *) getKsatisfP    {  return &Ksatisf; }
- (float *) getEnzymeCostP {  return &enzymeCost; }
- (float *) getExponP      {  return &Expon; }

- getNutri        { return [nutrisList getId: 0]; }

- getNutriAtIndex: (int) i   { return [nutrisList getId: i]; }

- (int) getNutrisNum   {  return nutrisNum; }

- (int) getAgeLimit   {  return ageLimit; }

- (float) getDeathRate {  return deathRate; }

- (int) getBirthsNum  {  return birthsNum; }

- (int) getDeathsNum   {  return deathsNum;  }

- getNutrisList   {  return nutrisList; }

- (int) getMutationsCnt     { return mutCnt; }

- (float) getMoveMetabAvg   { return moveMetabAvg; }
- (float) getEnzMetabAvg    { return enzMetabAvg; }
- (float) getOptFracsError  { return optFracsError; }

- (int *) getIODist   {  return ioDist; }

- (int *) getIOCard   {  return ioCard; }

- (char *) getSimName { return simName; }

- (int) getOutFlowArr: (int) index { return outFlowArr[index]; }

- (float *) getOptNutriFracsArr { return optNutriFracsArr; }

- (int) getMaxSpotNutri { return maxSpotNutri; }

- (float) getMagsBiomass
{ 
  float val;
  val=magsBiomass[cntMagsBiomass];
  if(++cntMagsBiomass > nutrisNum-1)                 // cycling 0,1,..N,0,1,..
    cntMagsBiomass = 0;
  return val; 
}

- (float) getContribNutri
{ 
  float val;
  val=magsContribNutris[cntContribNutri];
  if(++cntContribNutri > nutrisNum-1)                 // cycling 0,1,..N,0,1,..
    cntContribNutri = 0;
  return val; 
}

- (float) getTotNutriProd: (int) index    {  return totNutriProd[index]; }
- (float) getTotNutriCons: (int) index    {  return totNutriCons[index]; }
- (float) getTotFreeBiomCons: (int) index    {  return totFreeBiomCons[index]; }

- (float) getInCardAvg    { return inCardAvg; }
- (float) getInCardStd    { return inCardStd; } 
- (float) getOutCardAvg   { return outCardAvg; } 
- (float) getOutCardStd   { return outCardStd; } 
- (float) getEnzCardAvg   { return enzCardAvg; } 
- (float) getEnzCardStd   { return enzCardStd; }
 
- (float) getInEntropy    { return inEntropy; }
- (float) getOutEntropy   { return outEntropy; } 
- (float) getEnzEntropy   { return enzEntropy; } 
- (float) getIFD          { return iFD; } 

- addTotNutriProd: (float) add atIndex: (int) index;
{
  totNutriProd[index] = totNutriProd[index] + add;
  return self;
} 

- addTotNutriCons: (float) add atIndex: (int) index; 
{
  //  printf("CHRUM!");
  totNutriCons[index] += add;
  return self;
} 

- addTotFreeBiomCons: (float) add atIndex: (int) index; 
{
  totFreeBiomCons[index] += add;
  return self;
} 

- setMutationsCnt: (int) c
{ mutCnt = c; return self; }

- loadMS
{
  [ObjectLoader load: self fromFileNamed: "model.setup"];
  return self;
}

- saveMSto: (char *) filename
{
  [ObjectSaver save: self toFileNamed: filename
  	       withTemplate:  [probeLibrary getProbeMapFor: [self class]]];
  return self;
}

- setDisplayFreq: (int) freq       { displayFreq = freq;  return self; }

- setExperimentTime: (unsigned) time  { experimentTime=time; return self;}


+ createBegin: aZone 
{
  ModelSwarm *obj;
  id <ProbeMap> probeMap;

 printf("\n    MS: CreateBegin ..");

  obj = [super createBegin: aZone];
                                   // DEFAULT VALUES if there's no model.setup
  obj->worldSize  = 40;
  obj->nutrisNum   = 4;
  obj->seedProb   = 1;
  obj->diffusion  = 0;
  obj->evaporation= 1;
  obj->magDensity = 0.6;
  obj->initSize   = 10;
  obj->reproSize  = 23;
  obj->ageLimit   = 50;
  obj->deathRate   = 0.30;
  obj->ioTreshold = 0.5;
  obj->drain      = 1;
  obj->pMut       = 0.3;
  obj->minVision  = 1;
  obj->maxVision  = 8;
  obj->min_MaxMR  = 1;
  obj->max_MaxMR  = 25;
  obj->maxSpotNutri= 100;
  obj->ioUnit     = 10;
  obj->mutCnt     = 0;
  obj->K_move     = 1.5;             // relative
  obj->K_consum   = 10;              // relative to Kmetab
  obj->K_satisf   = 1.0;             // relative
  obj->enzyme_Cost= 1.0;             // relative
  obj->Kmetab     = 0.3;             // absolute value (base for relative K_xx) 
  obj->Kmove      = 1;               // absolute
  obj->Kconsum    = 5;               // absolute
  obj->Ksatisf    = 1;               // absolute
  obj->enzymeCost = 0.4;             // absolute
  obj->Expon      = 0.75;
  obj->initRandGenSeed =[randomGenerator getInitialSeed];                 
  if( ( obj->outTresh= (char *) calloc( MAXNUTRIS*8+1, sizeof(char)) )==NULL)
    [InvalidCombination raiseEvent: "MS: Cannot allocate outTresh\n"];   // int
  if( ( obj->initNutriGenes= (char *) calloc( MAXNUTRIS*8+1, sizeof(char)) )==NULL)
    [InvalidCombination raiseEvent: "MS: Cannot allocate initNutriGenes\n"]; // float
  if( ( obj->initEnzymeGenes= (char *) calloc( MAXNUTRIS*8+1, sizeof(char)) )==NULL)
    [InvalidCombination raiseEvent: "MS: Cannot allocate initEnzymeGenes\n"]; // int
  if( ( obj->nutriUtils= (char *) calloc( MAXNUTRIS*8+1, sizeof(char)) )==NULL)
    [InvalidCombination raiseEvent: "MS: Cannot allocate nutriUtils\n"]; // float 
  if( ( obj->inFlow= (char *) calloc( MAXNUTRIS*4+1, sizeof(char)) )==NULL)     
    [InvalidCombination raiseEvent: "MS: Cannot allocate inFlow\n"];   // int
  if( ( obj->outFlow = (char *) calloc( MAXNUTRIS*4+1,sizeof(char)) ) ==NULL)    
    [InvalidCombination raiseEvent: "MS: Cannot allocate outFlow\n"];  // int
  if( ( obj->initSeed= (char *) calloc( MAXNUTRIS*4+1, sizeof(char)) )==NULL)   
    [InvalidCombination raiseEvent: "MS: Cannot allocate initSeed\n"]; // int
  if( ( obj->simName= (char *) calloc( MAXFILENAME, sizeof(char)) ) ==NULL )  
    [InvalidCombination raiseEvent: "MS: Cannot allocate simName\n"];  // string
  if( ( obj->optNutriFracs= (char *) calloc( MAXNUTRIS*8+1, sizeof(char)) )==NULL)
    [InvalidCombination raiseEvent: "MS: Cannot allocate optNutriFracs\n"]; // float 
  strcpy(obj->outTresh,"1000 1000 1000 1000");  
  strcpy(obj->initNutriGenes,"");  
  strcpy(obj->initEnzymeGenes,"0 0 1 0 1");  
  strcpy(obj->nutriUtils,"0.2 0.5 0.8 1");  
  strcpy(obj->inFlow,"1000 1000 1000 1000");  
  strcpy(obj->outFlow,"30 30 30 30");  
  strcpy(obj->initSeed,"100 80 80 80");  
  strcpy(obj->simName,"DefaultSim1");  
  strcpy(obj->optNutriFracs,"0.1 0.1 0.4 0.4");  

  obj->birthsNum     = 0;
  obj->deathsNum      = 0;
  obj->moveMetabAvg  = 0;
  obj->presetNutriGenes   = 0;
  obj->presetEnzymeGenes   = 0;
  obj->setOutTresh   = 0;
  obj->inCardAvg     = 0;
  obj->inCardStd     = 0;
  obj->outCardAvg    = 0;
  obj->outCardStd    = 0;
  obj->inEntropy     = 0;
  obj->outEntropy    = 0;
  obj->optFracsError = 0;
  obj->tak           = 0;
  obj->cntMagsBiomass   = 0;
  obj->cntContribNutri  = 0;
  obj->displayFreq   = 1;
  obj->experimentTime = 0;
  
  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "nutrisNum"
                                    inClass: [self class]]]; 
  [probeMap addProbe: [probeLibrary getProbeForVariable: "optNutriFracs"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "nutriUtils"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "inFlow"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "outFlow"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "initSeed"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "magDensity"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "initNutriGenes"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "initEnzymeGenes"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "initSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "reproSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "deathRate"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "ageLimit"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "pMut"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "Kmetab"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "K_move"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "K_consum"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "K_satisf"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "enzyme_Cost"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "simName"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "minVision"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "maxVision"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "min_MaxMR"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "max_MaxMR"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "diffusion"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "evaporation"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "outTresh"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "drain"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "Expon"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "maxSpotNutri"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "ioUnit"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "initRandGenSeed"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFreq"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "experimentTime"
                                    inClass: [self class]]];
  [probeLibrary setProbeMap: probeMap For: [self class]];
  
 printf("Done\n");
  return obj;
}

- createEnd
{
  id tempObj; 
 printf("\n    MS: createEnd ..");
  tempObj = [super createEnd];
  printf("Done\n");
  return tempObj;
}


- buildObjects
{
  int x, y, i;
  char gname[5];
  float sumOptFracs;
  
 printf("\n    MS: buildObjects ..");

#ifdef NOFAT1
 printf("\n    MS: NOFAT1 mode - if full space reproduce only 1 kid without mutation ");
#endif
#ifdef NOFAT2
 printf("\n    MS: NOFAT2 mode - if full space reproduce only 1 kid with mutation ");
#endif

     // save current Initial Seed to modelSwarm parameter
  initRandGenSeed = [randomGenerator getInitialSeed];  

  Kmove = K_move * Kmetab;        // compute from relative to absolute value
  Kconsum = K_consum * Kmetab;
  Ksatisf = K_satisf * Kmetab;
  enzymeCost = enzyme_Cost * Kmetab;
  experimentTime = 0;

  // each mag should have 1 inp & 1 outp, i.e. prob. of inp = ioTr. = 1/2*nutriNum
  ioTreshold = 1 - 2.0/(1*nutrisNum);     // full interval is <-1,1> => 2.0 
  //  ioTreshold = 1 - 2.0/(1*nutrisNum);     // full interval is <-1,1> => 2.0 
  enzTreshold = 1 - 1.0/(2*nutrisNum);   // prob. so each 2nd Mag has 1 enzyme
 
  if(maxVision > worldSize)
  {  
    printf("Too big maxVision, setting maxVision=worldSize\n");
    maxVision = worldSize;
  }
  if(ioUnit > maxSpotNutri)
  {  
    printf("Too much ioUnits > maxSpotNutri, setting ioUnit=maxSpotNutri\n");
    ioUnit = maxSpotNutri;
  }
  [self convertStr: nutriUtils toFloatArr: nutriUtilsArr ];
  [self convertStr: inFlow    toLongArr: inFlowArr ];
  [self convertStr: outFlow   toLongArr: outFlowArr ];
  setOutTresh = [self convertStr: outTresh  toLongArr: outTreshArr ];
  [self convertStr: initSeed  toLongArr: initSeedArr];
  [self convertStr: optNutriFracs  toFloatArr: optNutriFracsArr ];

  // scaling optNutriFracs to percents so their sum is 1.0
  sumOptFracs = 0;
  for(i=0; i<nutrisNum; i++)
    sumOptFracs += optNutriFracsArr[i];
  for(i=0; i<nutrisNum; i++)
    optNutriFracsArr[i] = optNutriFracsArr[i] / sumOptFracs;

  if([self convertStr: initNutriGenes toFloatArr: initNutriGenesArr ]==1)
  {
    presetNutriGenes = 1;
    printf("\ninitNutriGenes:");
    for(i=0; i<nutrisNum; i++)  
      printf("%5.2f,",initNutriGenesArr[i]);
  }
  if([self convertStr: initEnzymeGenes toFloatArr: initEnzymeGenesArr ]==1)
  {
    presetEnzymeGenes = 1;
    printf("\ninitEnzymeGenes:");
    for(i=0; i<nutrisNum; i++)  
      printf("%5.2f,",initEnzymeGenesArr[i]);
  }
  printf("\noptFracs:\t");
  for(i=0; i<nutrisNum; i++)  
    printf("%5.2f,",optNutriFracsArr[i]);
  printf("\nn_utils: \t");
  for(i=0; i<nutrisNum; i++)  
    printf("%5.2f,",nutriUtilsArr[i]);
  printf("\niSeed:   \t");
  for(i=0; i<nutrisNum; i++)  
    printf("%5ld,",initSeedArr[i]);
  printf("\ninFlow:  \t");
  for(i=0; i<nutrisNum; i++)  
    printf("%5ld,",inFlowArr[i]);
  printf("\noutFlow: \t");
  for(i=0; i<nutrisNum; i++)  
    printf("%5ld,",outFlowArr[i]);
  printf("\noutTresh: \t");
  for(i=0; i<nutrisNum; i++)  
    printf("%5ld,",outTreshArr[i]);

  // creating nutri spaces, actually one empty one more for redrawing worldRaster
  // in case none (black) backgroung is choosed - worldBgNutri = 0  
  nutrisList = [MultiScaled2d create: [self getZone]];
  [nutrisList createGridsN: 2*nutrisNum+1 sizeX: worldSize sizeY: worldSize
            withDiffusion: diffusion  withEvaporation: evaporation];
  [nutrisList setMaxScaledVal: maxSpotNutri];
  [nutrisList setIOUnit: ioUnit];
                                          // INIT SEED
  for(i=0; i<nutrisNum; i++)
  {  
    nutri = [nutrisList getId: i];
    [nutrisList updateInFlowBy: initSeedArr[i] atIndex: i];
    [nutri updateLattice];
  }
  world = [Grid2d createBegin: [self getZone]];
  [world setSizeX: worldSize Y: worldSize];
  world = [world createEnd];
  [world fillWithObject: nil];
                                       // CREATE GENOTYPE FORM
  geneMap = [GeneMap create: self];
  gname[1] = '\0';	  
  for(i=0; i<nutrisNum; i++)
  {                            // Nutri Selection  Gene <-1,1>
    gname[0] = 'A'+i;                  // rising A,B,C,... 
    [geneMap createGeneType: "flo"
	     Name: gname
	     Start: i*NutriSelGSize
	     Length: NutriSelGSize   
	     Min: -1        Max: 1];
  }
  gname[0] = 'b';	  
  gname[2] = '\0';	  
  for(i=0; i<nutrisNum; i++)
  {                            // Enzyme Selection  Gene <0,1>
    gname[1] = 'A'+i;                  // rising bA,bB,bC,... 
    [geneMap createGeneType: "flo"
	     Name: gname
	     Start: nutrisNum*NutriSelGSize + i*EnzGeneSize
	     Length: EnzGeneSize   
	     Min: 0        Max: 1];
  }
  [geneMap createGeneType: "flo"
	   Name: "Vision"
	   Start: nutrisNum*NutriSelGSize + nutrisNum*EnzGeneSize
	   Length: VisionGSize
	   Min: minVision        Max: maxVision];
  [geneMap createGeneType: "flo"
	   Name: "MaxMR"
	   Start: nutrisNum*NutriSelGSize + nutrisNum*EnzGeneSize + VisionGSize 
	   Length: MaxMRGSize
	   Min: min_MaxMR        Max: max_MaxMR];
		   
  magList = [List create: [self getZone]];

  for (y = 0; y < worldSize; y++)
    for (x = 0; x < worldSize; x++) 
      if( [uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] < magDensity )
	[self addRandMagAtX: x Y: y];
      
  reaperQueue = [List create: [self getZone]];
  birthQueue = [List create: [self getZone]];
 
 printf("Done\n");
  return self;
}



- tack
{
  printf("\n\t\t%d\n",tak++ );
  return self;
}

- loadRandGenSeed
{
  [randomGenerator setStateFromSeed: initRandGenSeed];
  return self;
}

- (int) convertStr: (char *) str toLongArr: (long *)arr
{
  int i;

  if(str[0]=='\0')
    return 0;
  sscanf(str,"%ld",&arr[0]);
  for(i=1; i<nutrisNum; i++)
  {
    str = strchr(str,' ');
    if(str == 0) 
      [InvalidCombination raiseEvent:"MS: Too short input data array (long)\n"];
    str ++;
    sscanf(str,"%ld",&arr[i]);
  } 
  return 1;
}

- (int) convertStr: (char *) str toFloatArr: (float *)arr
{
  int i;

  if(str[0]=='\0')
    return 0;
  sscanf(str,"%f",&arr[0]);
  for(i=1; i<nutrisNum; i++)
  {
    str = strchr(str,' ');
    if(str == 0) 
      [InvalidCombination raiseEvent:"MS: Too short input data array (float)\n"];
    str ++;
    sscanf(str,"%f",&arr[i]);
  } 
  return 1;
}




- buildActions                // SCHEDULING the  ACTIONS OF THE OBJETCS
{
// keep order: 1st born, 2nd reap, 3rd countStatistics
// cause: borned cannot be from dead Mags, lost pointer
//        borned has already metabRates => countStatistics is OK 
  int i;  

  modelActions = [ActionGroup create: self];
  for(i=0; i<nutrisNum; i++)
  {  
    nutri = [nutrisList getId: i];
    [modelActions createActionTo: nutri  message: M(stepRule)];
  }
                                         // must be after stepRule
  [modelActions createActionTo: self  message: M(updateIOFlowValue)];  
  [modelActions createActionTo: self  message: M(updateIFlowAndSumNutri)];  
  [modelActions createActionForEach: magList    message: M(step)];
  [modelActions createActionTo: self message: M(bornMags)];
  [modelActions createActionTo: self message: M(reapMag)];
  [modelActions createActionTo: self  message: M(updateOFlowAndNutriData)];
  [modelActions createActionTo: self message: M(countMagStatistics)];

  modelSchedule = [Schedule createBegin: self];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions]; 

  return self;
}

- activateIn: swarmContext
{
  [super activateIn: swarmContext];
  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}



- updateIOFlowValue 
{                      // in the case user changed any MS values during the run
  float sumOptFracs;
  int i;

  experimentTime ++;
  //printf("\n ---------------------------------------------------");

    // auto switching inflow during sim.  
  /*
  if(experimentTime > 1000)
    strcpy(inFlow,"2000 4000 10000 20000");  // easy
  if(experimentTime > 2000)
    strcpy(inFlow,"20000 10000 4000 2000");  // hard
  */

  [self convertStr: inFlow toLongArr: inFlowArr];
  [self convertStr: outFlow toLongArr: outFlowArr];
  [self convertStr: initSeed toLongArr: initSeedArr];
  [self convertStr: optNutriFracs  toFloatArr: optNutriFracsArr ];
  setOutTresh = [self convertStr: outTresh  toLongArr: outTreshArr];

  Kmove = K_move * Kmetab;        // compute from relative to absolute value
  Kconsum = K_consum * Kmetab;
  Ksatisf = K_satisf * Kmetab;
  enzymeCost = enzyme_Cost * Kmetab;

      // auto "starting" setting of Ksatisf 
  /*
  if(experimentTime < 200)
    Ksatisf = (K_satisf/10)*Kmetab;
  else 
    Ksatisf = (K_satisf*Kmetab);
  */
    
  sumOptFracs = 0;
  for(i=0; i<nutrisNum; i++)
    sumOptFracs += optNutriFracsArr[i];
  for(i=0; i<nutrisNum; i++)
    optNutriFracsArr[i] = optNutriFracsArr[i] / sumOptFracs;

  return self;
}

- updateIFlowAndSumNutri
{
  int i;
  //  unsigned xuns ; 
                        // sum of all nutri before Mags start to eat/produce

                        // with updateLattice in updateOFLowAndNutriData (in MS)
  for(i=0; i < nutrisNum; i++)
  {
    totNutriProd[i] = 0;        // null total nutri before new time step
    totNutriCons[i] = 0;
    totFreeBiomCons[i] = 0;
    sumAllNutri[i] = [nutrisList getTotalAtIndex: i]; 
    realInFlow[i]= [nutrisList updateInFlowBy: (float) inFlowArr[i]
			      atIndex: i ];
  }

  return self;
}


- updateOFlowAndNutriData
{
  int i;
  float reqOutFlow,val;
  float newSumAllNutri;
  float minim, maxim;
  float nutriFrac;

  totalNutris=0;
  for(i=0; i<nutrisNum; i++)
  {
    nutri = [nutrisList getId: i];
    [nutri updateLattice];              // update CRUCIAL !!!

    newSumAllNutri = [nutrisList getTotalAtIndex: i];  
    totalNutris += newSumAllNutri;
                                                    // transfer % -> absol.value
    reqOutFlow = (outFlowArr[i]/100.0)* (newSumAllNutri-(1-drain)*totNutriProd[i]);

                                                // Limits to outFlow : 
    if( setOutTresh == 1 )
      if ( reqOutFlow > (val=outTreshArr[i]) )  // max outFlow=outTreshold
	reqOutFlow = val;
    //  printf("\n reqOutFlow: %f, sumAll:%f ,outTr:%d, val:%f,prod:%f",
    //  reqOutFlow,newSumAllNutri, outTreshArr[i],val, totNutriProd[i]);
    realOutFlow[i]= [nutrisList updateOutFlowBy: reqOutFlow 
			       atIndex: i ];

                 // magsContribNutris added/taken by Mags in this step


    magsContribNutris[i] = newSumAllNutri-sumAllNutri[i]-(realInFlow[i]-realOutFlow[i]);
    sumAllNutri[i] = newSumAllNutri;
  
    maxim = (realInFlow[i] < realOutFlow[i]) ? realOutFlow[i] : realInFlow[i];
    if (maxim==0) maxim = 1;
    minim = ( totNutriProd[i] < totNutriCons[i]) ? totNutriProd[i] : totNutriCons[i];
    [nutri setCyclRatio: (minim+totFreeBiomCons[i]) / maxim ];
  }

  // Biomass Update
  for(i=nutrisNum; i < 2*nutrisNum; i++)
  {
    nutri = [nutrisList getId: i];
    [nutri updateLattice];              // update CRUCIAL !!!
    [nutri setTotalMagsBiomass: [nutrisList getTotalAtIndex: i]];
  }

  // Update Nutri Fractions according to totalNuris
  optFracsError = 0;
  for(i=0; i<nutrisNum; i++)
  {
    nutriFrac = sumAllNutri[i]/totalNutris;
    if(optNutriFracsArr[i]!=0)
      optFracsError +=  fabs((nutriFrac - optNutriFracsArr[i])/optNutriFracsArr[i] );
    else 
      optFracsError +=  fabs( nutriFrac - optNutriFracsArr[i] );
    [[nutrisList getId: i] setNutriFrac: nutriFrac ];
  }
  return self;
}

- countMagStatistics
{          // counting for all Mags: MoveMetabAvg,IODist arr, IO Card arr,
           //                        magsBiomass arr, magsContribNutris
  id index,mag;
  int cntMoving, cntEnzyming;
  int i, val; 
  int cardI, cardO, cardEnzymes;
  float sumMoveMetab, sumEnzMetab, sumTotMagInFracs;
  float *nutriFracs;
  int   *enzymes;
                                         // initializing arrays
  mutCnt=0;
  for(i=0; i < 3*nutrisNum; i++)
    ioDist[i]=0;
  for(i=0; i < 3*nutrisNum+3; i++)
    ioCard[i]=0;
  for(i=0; i < nutrisNum; i++)
  {
    magsBiomass[i]=0;
    totMagInFracs[i] = 0;
  }
  sumMoveMetab = 0; sumEnzMetab=0;
  cntMoving=0; cntEnzyming=0;
  index = [magList begin: self];
  while( (mag=[index next]) )            // go through all Mags  
  {
    mutCnt += [geneMap mutateGenome: [mag getMagGenome]
		       withProb: pMut ];
    val=[mag getHasMoved];
                    // if Mag moved (full 1, partial 2, bioFull 6, bioPart 7) 
    if(val==1 || val==2 || val==6 || val==7)
    { 
      cntMoving++;
      sumMoveMetab = sumMoveMetab + [mag getMoveMetab];
    }
    if( [mag getEnzymesNum ] > 0 )    // if Mag is producing enzymes
    { 
      cntEnzyming++;
      sumEnzMetab = sumEnzMetab + [mag getEnzMetab];
    }

    cardI = 0; cardO = 0; cardEnzymes = 0;
	 // counting int array for IO Distribution graph
         //   structure of array ioDist[]=Ain,Bin, .. Aout,Bout,.. A_enz,B_enz..
	 // counting int array for IO Cardinality graph
         //     ioCard[]= 0 x in, 1 x in, .., 0 x Out,1 x out, .., 0 x enz, 1 x enz 
    nutriFracs = [mag getNutriFracs];
    enzymes = [mag getEnzymes];
    for(i=0; i<nutrisNum; i++)
    {
      if( nutriFracs[i] > 0 )           // Input mask
      {
	cardI++;                // counting how many inputs this Mag has
        ioDist[i]++;				// total Mags input
	magsBiomass[i] = magsBiomass[i] + [mag getStock: i];        
	totMagInFracs[i] += nutriFracs[i];
      }
      if( nutriFracs[i] < 0 )           // Output mask
      {
	cardO++;                // counting how many outputs this Mag has
        ioDist[i+nutrisNum]++;			// total Mags output
      }
      if( enzymes[i] == 1 )
      {
	cardEnzymes++;          // counting how many enzymesFlags this Mag has
	ioDist[i+nutrisNum*2]++;
      }
						// total difference In-Out
      //      ioDist[i+nutrisNum*2] = ioDist[i+nutrisNum]-ioDist[i];	
                                                // sum nutri Mags posses
    }
    ioCard[ cardI ]++;
    ioCard[ cardO + nutrisNum+1 ]++;
    ioCard[ cardEnzymes + nutrisNum*2 + 2]++;
  }    // end all Mags cycle

                           // setting global AVG values
  if( cntMoving != 0 )
    moveMetabAvg = sumMoveMetab/cntMoving;
  else
    moveMetabAvg = 0;
  if( cntEnzyming != 0 )
    enzMetabAvg = sumEnzMetab/cntEnzyming;
  else
    enzMetabAvg = 0;
  sumTotMagInFracs = 0;
  for(i=0; i<nutrisNum; i++)
  {
    sumTotMagInFracs += totMagInFracs[i];
  }
  iFD = 0;
  for(i=0; i<nutrisNum; i++)
  {
    nutri = [nutrisList getId: i];
    [nutri setTotalMagsBiomass: magsBiomass[i]];

    iFD += fabs(sumAllNutri[i]/totalNutris - totMagInFracs[i]/sumTotMagInFracs);
  }
  iFD = iFD / nutrisNum;
  [self updateIOCardStat];
  [self updateIOEntropy];
  return self;  
}

- updateIOCardStat
{
  float inAvg, inAvg2, inStd;
  int nIn;
  float outAvg, outAvg2, outStd;
  int nOut;
  float enzAvg, enzAvg2, enzStd;
  int nEnz;
  int i, j;

  inAvg=0; inAvg2=0; inStd=0; nIn=0; 
  outAvg=0; outAvg2=0; outStd=0; nOut=0;
  enzAvg=0; enzAvg2=0; enzStd=0; nEnz=0;
 
  for(i=0; i<nutrisNum+1; i++)
  {
    for(j=0; j<ioCard[i]; j++)
    {
      inAvg = ((inAvg * (float)nIn ) + i) / ((float) (nIn+1));
      inAvg2 = ((inAvg2 * (float)nIn ) + i*i) / ((float) (nIn+1));
      inStd = sqrt(inAvg2 - inAvg*inAvg);
      nIn++;
    }
    for(j=0; j<ioCard[i+1+nutrisNum]; j++)
    {
      outAvg = ((outAvg * (float)nOut ) + i) / ((float) (nOut+1));
      outAvg2 = ((outAvg2 * (float)nOut ) + i*i) / ((float) (nOut+1));
      outStd = sqrt(outAvg2 - outAvg*outAvg);
      nOut++;
    }
    for(j=0; j<ioCard[i+2+nutrisNum*2]; j++)
    {
      enzAvg = ((enzAvg * (float)nEnz ) + i) / ((float) (nEnz+1));
      enzAvg2 = ((enzAvg2 * (float)nEnz ) + i*i) / ((float) (nEnz+1));
      enzStd = sqrt(enzAvg2 - enzAvg*enzAvg);
      nEnz++;
    }
  }
  inCardAvg = inAvg;
  inCardStd = inStd;
  outCardAvg = outAvg;
  outCardStd = outStd;
  enzCardAvg = enzAvg;
  enzCardStd = enzStd;
  
  return self;
}

- updateIOEntropy
{
  float inEnt, inProb ; 
  int inSum;
  float outEnt, outProb;
  int outSum;
  float enzEnt, enzProb;
  int enzSum;
  float mxEnt;
  int i;

  inEnt = 0; inSum=0;
  outEnt=0; outSum=0;
  enzEnt=0; enzSum=0;
  for(i=0; i<nutrisNum; i++)
  {
    inSum += ioDist[i];
    outSum += ioDist[i + nutrisNum ];
    enzSum += ioDist[i + 2*nutrisNum ];
  }
  for(i=0; i<nutrisNum; i++)
  {
    inProb = ioDist[i]/(float)inSum;     // always non zero In - hardwired in Mag
    if(inProb > 0)
      inEnt += inProb * log(inProb);
    if(outSum > 0)                       // protect: if 0 outputSum of all Mags
    {
      outProb = ioDist[i + nutrisNum]/(float)outSum;
      if(outProb > 0)
	outEnt += outProb * log(outProb);
    }
    if(enzSum > 0)                       // protect: if 0 enzymeSum of all Mags
    {
      enzProb = ioDist[i + 2* nutrisNum]/(float)enzSum;
      if(enzProb > 0)
	enzEnt += enzProb * log(enzProb);
    }
  }
  mxEnt = log( 1.0 / (float) nutrisNum);
  inEntropy = inEnt/mxEnt;
  outEntropy = outEnt/mxEnt;
  enzEntropy = enzEnt/mxEnt;
  return self;
}



// =========================== CREATE MAG FUNCTIONS ====================

- updatePType: (Mag *) mag
{
  char *genome, gname[5];  
  int i;
  float val;
  float *nutriFracs;
  int *enzymes, enzNum=0;
  float sumInNutriFracs, sumOutNutriFracs;
  int magInputs,magOutputs;

  gname[1] = '\0';
  genome = [mag getMagGenome];
  nutriFracs = [mag getNutriFracs];
  enzymes = [mag getEnzymes];
  sumInNutriFracs  = 0; sumOutNutriFracs = 0;
  magInputs = 0; magOutputs = 0;
  for(i=0; i<nutrisNum; i++)    // Nutri Selection Genes
  {  
    gname[0] = 'A'+i;
    val = [geneMap getValueOfGene: gname ofGenome: genome];
    if ( val > 1 || val < -1)
      printf("\n MS: Invalid nutri selection gene[%d] = %f ",i,nutriFracs[i]);

    nutriFracs[i] = 0;
    if (val > ioTreshold)        // scaling input genes, positive val
    {
      nutriFracs[i] = (val-ioTreshold)/(1-ioTreshold);
      if ( nutriFracs[i] < 0 )
	printf("\n MS: Negative nutriFracs[%d] = %f for in ",i,nutriFracs[i]);
      sumInNutriFracs += nutriFracs[i];
      magInputs++;
    }
    if (val < (-ioTreshold))     // scaling output genes, negative val
    {
      nutriFracs[i] = (val+ioTreshold)/(1-ioTreshold);
      if ( nutriFracs[i] > 0 )
	printf("\n MS: Positive nutriFracs[%d] = %f for out ",i,nutriFracs[i]);
      sumOutNutriFracs += (-nutriFracs[i]);
      magOutputs++;
    }
  }
  gname[2] = '\0'; gname[0] = 'b';
  for(i=0; i<nutrisNum; i++)
  {  
    if( nutriFracs[i] > 0 )                           // scaling ins/outs so sum=1
      nutriFracs[i] = nutriFracs[i]/sumInNutriFracs;
    if( nutriFracs[i] < 0 )
      nutriFracs[i] = nutriFracs[i]/sumOutNutriFracs;

    gname[1] = 'A'+i;                                 // updating Enzyme PType
    if([geneMap getValueOfGene: gname ofGenome: genome] > enzTreshold)
    {
      enzymes[i] = 1;
      enzNum++;
    }
    else
      enzymes[i] = 0;
  }
  [mag setEnzymesNum: enzNum ];
  [mag setInputsNum: magInputs ];
  [mag setOutputsNum: magOutputs ];
  [mag setVision: (int) ([geneMap getValueOfGene: "Vision" ofGenome: genome]+0.5)];
  [mag setMaxMR: (int) ([geneMap getValueOfGene: "MaxMR" ofGenome: genome]+0.5)];
  return self;
}

- updateMetabRates: (Mag *) mag
{
  int k;
  float w,size;
  
  size = 0;
  for(k=0; k<nutrisNum; k++)        
    size += [mag getStock:k];
  if(size < 0)
    printf("\n\007\007\007 MS: Negative size x,y:%d,%d!",[mag getX],[mag getY]);
  w = pow(size,Expon);
  [mag setConsRate: (Kconsum * w)];
  [mag setBasalMetab: (Kmetab * w)];        // setMoveMetab not needed
                                            // because new Mag hasMoved=0
  [mag setHasMoved: 0];
  return self;
}


- addRandMagAtX: (int)x Y: (int)y
{   
  Mag   *aMag;
  char  *aGenome, gname[5];
  float *nutriStocks;
  int   *enzymes;
  //  float *magNutriUtils;
  float *magNutriFracs;
  int   i;//, inpNum=0;
  
  aGenome = [geneMap createGenome];
  if( (nutriStocks= (float *) calloc( nutrisNum+1, sizeof(float)))==NULL)
    [InvalidCombination raiseEvent: "MS: Cannot allocate Mag's nutriStocks\n"];
  if( (enzymes= (int *) calloc( nutrisNum+1, sizeof(int)))==NULL)
    [InvalidCombination raiseEvent: "MS: Cannot allocate Mag's enzymes\n"];
  //  if( (magNutriUtils= (float *) calloc( nutrisNum+1, sizeof(float)))==NULL)
  //  [InvalidCombination raiseEvent: "MS: Cannot allocate Mag's nutriUtils\n"];
  if( (magNutriFracs= (float *) calloc( nutrisNum+1, sizeof(float)))==NULL)
    [InvalidCombination raiseEvent: "MS: Cannot allocate Mag's nutriFracs\n"];

  aMag = [Mag createBegin: self ];
  [aMag setWorld: world NutrisList: nutrisList ];
  [aMag setModelSwarm: self ]; 
  [aMag setMagGenome: aGenome ];  
  [aMag setNutriFracs: magNutriFracs ];  
  [aMag setNutriStocks: nutriStocks ];  
  [aMag setEnzymes: enzymes ];  
  [aMag setNutriUtils: nutriUtilsArr ];  
  [aMag setOptNutris: optNutriFracsArr ];  
  //  [aMag setIOTresholdP: &ioTreshold ];  
  aMag = [aMag createEnd];
  
  [world putObject: aMag atX: x Y: y];

  [geneMap randInitGenome: aGenome ];
  if(presetNutriGenes==1)
  {
    gname[1] = '\0';
    for(i=0; i<nutrisNum; i++)
    {  
      gname[0] = 'A'+i;         // rising A,B,C, ..
      [geneMap setValue: initNutriGenesArr[i] ofGene: gname ofGenome: aGenome ];
      //      printf("\n TEST: set:%f \t get:%f",
      //     initNutriGenesArr[i],[geneMap getValueOfGene: gname ofGenome: aGenome]);

    }
  }
  if(presetEnzymeGenes==1)
  {
    gname[0] = 'b';	  
    gname[2] = '\0';	  
    for(i=0; i<nutrisNum; i++)
    {  
      gname[1] = 'A'+i;           // rising bA,bB,bC ...
      [geneMap setValue: initEnzymeGenesArr[i] ofGene: gname ofGenome: aGenome ];
      //printf("\n TEST: set:%d \t get:%d",
      // initEnzymeGenesArr[i],(int)[geneMap getValueOfGene: gname ofGenome: aGenome]);

    }
  }
  [self updatePType: aMag];               // Genotype -> Phenotype
  [aMag setX: x Y: y];
  for(i=0; i<nutrisNum; i++)               // init.Mag resources in his Stocks 
  {
    if( magNutriFracs[i] > 0 )       // this nutri is as INPUT 
    {
      [aMag setStock:i value: initSize ];     
      //      inpNum++;                           // inputs count
    }
    else
      [aMag setStock:i value: 0 ];     
  }
  //  [aMag setMagInputsNum: inpNum ];
  [magList addLast: aMag ];
  return self;
}

- addReproMag: (Mag *) oMag
{  
  Mag *nMag;
  int x, y, i, j, k, newX, newY;
  unsigned done = 0;
  float value;
  char  *nGenome, *oGenome;
  float *nutriStocks;
  int   *enzymes;
  //  float *nMagNutriUtils;
  float *nMagNutriFracs, *oMagNutriFracs;
  int   nInpNum,oInpNum;
  
  [oMag getX: &x Y: &y];
  for(i= x-1 ; i<= x+1 && done==0; i++)  // search surround.8 cells
  {  
    newX = (i + worldSize) % worldSize;
    for(j= y-1 ; j<= y+1 && done==0; j++)
    { 
      newY = (j + worldSize) % worldSize;
      if([world getObjectAtX: newX Y: newY ] == nil)  // if empty place =>reproduce
      {
	done = 1;

	oGenome = [oMag getMagGenome];
	nGenome = [geneMap cloneGenome: oGenome ];
	if( (nutriStocks=(float *) calloc(nutrisNum+1,sizeof(float)))==NULL)
	  [InvalidCombination raiseEvent: "MS: Can't alloc nMag's nutriStocks\n"];
	if( (enzymes= (int *) calloc( nutrisNum+1, sizeof(int)))==NULL)
	  [InvalidCombination raiseEvent: "MS: Cannot allocate nMag's enzymes\n"];
	//	if( (nMagNutriUtils=(float *) calloc(nutrisNum+1,sizeof(float)))==NULL)
	//[InvalidCombination raiseEvent: "MS: Can't alloc nMag's nutriUtils\n"];
	if( (nMagNutriFracs= (float *) calloc( nutrisNum+1, sizeof(float)))==NULL)
	  [InvalidCombination raiseEvent: "MS: Can't allocate nMag's nutriFracs\n"];
	
	nMag = [Mag createBegin: self ];
	[nMag setWorld: world NutrisList: nutrisList ];
	[nMag setModelSwarm: self ]; 
	[nMag setMagGenome: nGenome ];  
	[nMag setNutriFracs: nMagNutriFracs ];  
	[nMag setEnzymes: enzymes ];  
	[nMag setNutriStocks: nutriStocks ];  
	[nMag setNutriUtils: nutriUtilsArr ];  
	[nMag setOptNutris: optNutriFracsArr ];  
	//	[nMag setIOTresholdP: &ioTreshold ];  
	nMag = [nMag createEnd];
	[world putObject: nMag atX: newX Y: newY ];
  
	// 	mutCnt += [geneMap mutateGenome: oGenome withProb: pMut ];
	// mutCnt += [geneMap mutateGenome: nGenome withProb: pMut ];
	[self updatePType: oMag ];
	[self updatePType: nMag ];

	[nMag setX: newX Y: newY ];
	
	/* give half Input stocks of parent to new Mag, 
	   ! if input mutated nMag won't get initNutri there ! */
	oMagNutriFracs = [oMag getNutriFracs ];
	nInpNum=0; oInpNum =0;
	for(k=0; k<nutrisNum; k++)   
	{   
	  value=[oMag getStock:k];                //  
	  if( oMagNutriFracs[k] > 0 )       // input mask
	  {   
	    //  oInpNum++;
	    [oMag setStock:k value: value-value/2];     
	  }  
          else
	  {  
	    [oMag setStock:k value: 0];     
	    //	    [oMag setStock:k value: (float)initSize/nutrisNum];    
	    // [nMag setStock:k value: (float)initSize/nutrisNum];    
	    //	    [oMag setStock:k value: initSize];    
	    //[nMag setStock:k value: initSize];    
	  } 
	  if( nMagNutriFracs[k] > 0 )       // input mask
	  {
	    //  nInpNum++;
	    [nMag setStock:k value: value/2];     
	  }
	  else
	    [nMag setStock:k value: 0];     
	  //  nMagNutriUtils[k] = nutriUtilsArr[k];
	}  
	//	[nMag setMagInputsNum: nInpNum ];
	//	[oMag setMagInputsNum: oInpNum ];
 	[magList addLast: nMag ];

                 // magSize changed => update cons,moveMetab for countAvg func
	[self updateMetabRates: oMag ];
 	[self updateMetabRates: nMag ];
	[oMag setMagAge: 0];
	[nMag setMagAge: 0];
      }
    }
  }

#ifdef NOFAT1
  if(done == 0)     // if cannot reproduce <= not enough space arround
  {                 //   then take half of stock anyway 
    oMagNutriFracs = [oMag getNutriFracs ];
    oInpNum =0;
    for(k=0; k<nutrisNum; k++)   
    {   
      value=[oMag getStock:k];                //  
      if( oMagNutriFracs[k] > 0 )       // input mask
	[oMag setStock:k value: value-value/2];     
      else
	[oMag setStock:k value: 0];     
      [nutrisList incrementValue: value/2      // put taken biomass to freeBiomass
		  atX: x Y: y 
		  atIndex: k+nutrisNum ];
    }
    [self updateMetabRates: oMag ];
  }
#endif

#ifdef NOFAT2
  if(done == 0)     // if cannot reproduce <= not enough space arround
  {                 //   then Born only 1 - take half of stock and new Ptype
    oMagNutriFracs = [oMag getNutriFracs ];
    [self updatePType: oMag ];
    //   oInpNum =0;
    for(k=0; k<nutrisNum; k++)   
    {   
      value=[oMag getStock:k];                //  
      if( oMagNutriFracs[k] > 0 )       // input mask
      {   
	//	oInpNum++;
	[oMag setStock:k value: value-value/2];     
      }  
      else
	[oMag setStock:k value: 0];     
      [nutrisList incrementValue: value/2      // put taken biomass to freeBiomass
		  atX: x Y: y 
		  atIndex: k+nutrisNum ];
    }
    //    [oMag setMagInputsNum: oInpNum ];
    [self updateMetabRates: oMag ];
    [oMag setMagAge: 0];
  }
#endif

  return self;
}



- reapMag
{
  id index, mag;
 
  deathsNum = [reaperQueue getCount];
  index = [reaperQueue begin: self];
  while( (mag=[index next]) )
  {
    [magList remove: mag];
    [mag drop];
  }    
  [reaperQueue removeAll];
  return self;
}

- bornMags
{
  id index, mag;
  
  birthsNum = [birthQueue getCount];
  index = [birthQueue begin: self];
  while( (mag=[index next]) )
    [self addReproMag: mag];
  [birthQueue removeAll];
  return self;
}

- printMag
{
  id index,mag;
  int x,y,i;
  BOOL c = NO;
  
  index = [magList begin: self];
  mag = [index next];
  x=[mag getX];
  y=[mag getY];
 printf("\n1st mag: %d-%d",x,y);
  for(i=0; i< 2*nutrisNum + VisionGSize + MaxMRGSize; i++)
  {  
//    c = (BOOL) [[mag getMagGenome] atOffset: i];
    printf("%d",c);
  }  
 return self;  
    
}

@end



// ====================  CEMETARY OF GOOD but OLD CODE ====================


//    [nutri seedCircleNutriAtX: worldSize/2 Y: worldSize/2];
//    [nutri seedSlopeNutriAtX: 1 Y: 1];
//    [nutri seedNutriWithProb: initSeedArr[i]];

/*  nutri = [nutrisList getId: 0];
  [nutri seedCircleNutriAtX: worldSize/4 Y: worldSize/4];
  nutri = [nutrisList getId: 1];
  [nutri seedCircleNutriAtX: worldSize/4 Y: worldSize*3/4];
  nutri = [nutrisList getId: 2];
  [nutri seedCircleNutriAtX: worldSize*3/4 Y: worldSize/4];
//  nutri = [nutrisList getId: 3];
//  [nutri seedCircleNutriAtX: worldSize*3/4 Y: worldSize*3/4];
*/
  









