// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// geneticsInt.h                                    Peter Zvirinsky oct,1998
// Library for implementing genetics in SWARM agents with Integer genes
//    genome:  binary string
//    gene:    set of bits, type INT,BITS
//    classes: GeneMap, GeneType				      

#import <objectbase/SwarmObject.h>
#import <collections.h> 
#import <random.h>

//====================================================================
// class Gene, structure for describing type and parameters
// of particular gene
//====================================================================

@interface Gene: SwarmObject
{ 
  char      name[21];
  char      type[5];
  unsigned  start;
  unsigned  len;
  int       min;
  int       max;
}

- setGName:   (char *)name;
- setGType:   (char *)type;
- setGStart:  (unsigned)start;
- setGLength: (unsigned)len;
- setGMin:    (int) min;
- setGMax:    (int) max;
- (char *)   getGName;
- (char *)   getGType;
- (unsigned) getGStart;
- (unsigned) getGLength;
- (int)      getGMin;
- (int)      getGMax;

@end

//====================================================================
// class GeneMap, List of pointers to GeneTypes
//====================================================================


@interface GeneMap: SwarmObject
{
  id geneMap;                     // pointer to List
  id <RandomBitDist> randBit;
  unsigned gMapLength;
}

- createEnd;
- createGeneType: (char *)   type
            Name: (char *)   name
           Start: (unsigned) start
          Length: (unsigned) len
             Min: (int)      min
             Max: (int)      max;
- getGeneWithName: (char *) nam;
- (char *)   getNameOfGene: (unsigned) index;
- (char *)   getTypeOfGene: (char *)nam;
- (unsigned) getStartOfGene: (char *)nam;
- (unsigned) getLengthOfGene: (char *)nam;
- (int)      getMinOfGene: (char *)nam;
- (int)      getMaxOfGene: (char *)nam;
- (unsigned) getGMapLength;

- (char *)   createGenome;
- randInitGenome: (char *) p;
- (char *) cloneGenome: (char *)p1;
- (int) mutateGenome: (char *) p withProb: (float) pmut;
- (int) getValueOfGene: (char *) nam ofGenome: (char *)p;
- printGenome: (char *) p;
@end

        



