// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// batchObserverSwarm.m

/* In BATCH mode program : 
   - READS batchObserver parameters from batchObserver.setup
   - READS modelSwarm parameters from model.setup
   - RUNS simulation for 'experimentDuration' steps
   - SAVES sXXX.setup
   - SAVES model.setup
   - SAVES graphs data in ./data/data.*
   - COPY ./model.setup -> ./data/model.setup
   - PACK all ./data directory to TGZ archive ./aXXX.tgz  
   - terminates
*/

#import "BatchObserverSwarm.h"
#import "ModelSwarm.h"

@implementation BatchObserverSwarm

+ createBegin: aZone
{
  BatchObserverSwarm *obj;

 printf("  OS: createBegin ..");
       // createBegin: here we set up the default simulation parameters.
  obj = [super createBegin: aZone];

  obj->displayFrequency   = 1;
  obj->experimentDuration = 100;
  obj->useSetupFile       = 1;
  obj->loadRandSeed       = 0;

  obj->drawPopulGr        = 1;
  obj->drawNutrisGr       = 1;
  obj->drawNutriFracsGr   = 1;
  obj->drawFreeBiomassGr  = 1;
  obj->drawCyclRatiosGr   = 1;
  obj->drawMagsBiomassGr  = 1;
  obj->drawContribNutriGr = 1;
  obj->drawIOCardStatGr   = 1;
  obj->drawIOEntropyGr    = 1;
  obj->drawOptFracsStatGr = 1;

  obj->tik                = 0;
  obj->expTime            = 0;

 printf("Done\n");
    return obj;
}

- createEnd
{
  printf("  OS: createEnd     Done\n");
  return [super createEnd];
}

- buildObjects
{
  id magList;
  id reaperQueue, birthQueue;
  char text[10];
  int i, nutrisNum;
  //  double maxNutri;
  //  char filename[MAXFILENAME];

 printf("  OS: buildObjects ..");

  [super buildObjects];
  [ObjectLoader load: self fromAppConfigFileNamed: "batchObserver.setup"];

  modelSwarm = [ModelSwarm create: self ];

  if(useSetupFile == 1)
    [modelSwarm loadMS];
  if( loadRandSeed == 1 )
    [modelSwarm loadRandGenSeed];

  [modelSwarm setDisplayFreq: displayFrequency ];
  [modelSwarm buildObjects];


  /*  if( strlen([modelSwarm getSimName]) > MAXFILENAME-1 )
    [InvalidCombination raiseEvent: "\n OS: Simulation name too long"]; 
  sprintf (filename, "out_%s.txt",[modelSwarm getSimName]);
                                                 // extra text output to file 
  if( (statusFile=fopen(filename,"w"))== NULL)
    [InvalidCombination raiseEvent: "OS: Cannot open statusFile"];
    */ 

  magList = [modelSwarm getMagList];
  reaperQueue = [modelSwarm getReaperQueue];
  birthQueue = [modelSwarm getBirthQueue];
  nutrisNum =  [modelSwarm getNutrisNum];
    
  // =============================  GRAPHS ==================================

  if(drawPopulGr==1)
  {  
    populationGraph = [EZGraph createBegin: self];
    [populationGraph setGraphics: 0];
    [populationGraph setFileOutput: 1];
    [populationGraph setFileName: "data/data.population"];
    populationGraph = [populationGraph createEnd];
    [populationGraph createSequence: "Population"
                     withFeedFrom: magList
		     andSelector: M(getCount)];
    [populationGraph createSequence: "Births"
		     withFeedFrom: modelSwarm
		     andSelector: M(getBirthsNum)];
    [populationGraph createSequence: "Deaths"
		     withFeedFrom: modelSwarm
		     andSelector: M(getDeathsNum)];
    [populationGraph createAverageSequence: "Age_avg"
                     withFeedFrom: magList
		     andSelector: M(getMagAge)];
    /*  [populationGraph createSequence: "Mutations"
		     withFeedFrom: modelSwarm 
		     andSelector: M(getMutationsCnt)];*/
    [populationGraph createTotalSequence: "enz_Mag"
		     withFeedFrom: magList
		     andSelector: M(getEnzMag)];
    
  }

  if(drawNutrisGr==1)
  {  
    allNutriGraph = [EZGraph createBegin: [self getZone]];
    [allNutriGraph setGraphics: 0];
    [allNutriGraph setFileOutput: 1];
    [allNutriGraph setFileName: "data/data.nutris"];
    allNutriGraph = [allNutriGraph createEnd];
    for(i=0; i<nutrisNum; i++)
    {  
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_nutri");
      [allNutriGraph createSequence: text
		 withFeedFrom: [modelSwarm getNutriAtIndex: i]
		 andSelector: M(getScaledTotalNutri)]; 
    }		 
  }	
	 
  if(drawNutriFracsGr==1)
  {  
    allNutriFracsGraph = [EZGraph createBegin: [self getZone]];
    [allNutriFracsGraph setGraphics: 0];
    [allNutriFracsGraph setFileOutput: 1];
    [allNutriFracsGraph setFileName: "data/data.nutriFracs"];
    allNutriFracsGraph = [allNutriFracsGraph createEnd];
    for(i=0; i<nutrisNum; i++)
    {  
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_nutri");
      [allNutriFracsGraph createSequence: text
		 withFeedFrom: [modelSwarm getNutriAtIndex: i]
		 andSelector: M(getNutriFrac)]; 
    }		 
  }	
	 
  if(drawFreeBiomassGr==1)
  {  
    freeBiomassGraph = [EZGraph createBegin: [self getZone]];
    SET_WINDOW_GEOMETRY_RECORD_NAME(freeBiomassGraph);
    [freeBiomassGraph setGraphics: 0];
    [freeBiomassGraph setFileOutput: 1];
    [freeBiomassGraph setFileName: "data/data.fBiomass"];
    freeBiomassGraph = [freeBiomassGraph createEnd];
    for(i=0; i<nutrisNum; i++)
    {  
      text[0] = 'A'+i;         // rising A,B,C,... 
      text[1] = '\0';	  
      strcat(text,"_bioM");
      [freeBiomassGraph createSequence: text
		 withFeedFrom: [modelSwarm getNutriAtIndex: i+nutrisNum]
		 andSelector: M(getScaledTotalNutri)]; 
    }		 
  }	
	 
  if(drawCyclRatiosGr==1)
  {   
    cyclRatiosGraph = [EZGraph createBegin: [self getZone]];
    [cyclRatiosGraph setGraphics: 0];
    [cyclRatiosGraph setFileOutput: 1];
    [cyclRatiosGraph setFileName: "data/data.cyclRatios"];
    cyclRatiosGraph = [cyclRatiosGraph createEnd]; 
    for(i=0; i<[modelSwarm getNutrisNum]; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
      [cyclRatiosGraph createSequence: text
		       withFeedFrom: [modelSwarm getNutriAtIndex: i]
		       andSelector: M(getCyclRatio)]; 
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
      /* I just hope order of calling selector will stay the same
      [cyclRatiosGraph createSequence: text 
		       withFeedFrom: modelSwarm 
		       andSelector: M(getCyclRatios)];*/ 
    }		  
  }		  

  if(drawMagsBiomassGr==1)
  {   
    magsBiomassGraph = [EZGraph createBegin: [self getZone]];
    [magsBiomassGraph setGraphics: 0];
    [magsBiomassGraph setFileOutput: 1];
    [magsBiomassGraph setFileName: "data/data.mBiomass"];
    magsBiomassGraph = [magsBiomassGraph createEnd]; 
    for(i=0; i<[modelSwarm getNutrisNum]; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
      [magsBiomassGraph createSequence: text
		     withFeedFrom: [modelSwarm getNutriAtIndex: i]
		     andSelector: M(getTotalMagsBiomass)]; 
    }		  
  }		  

  if(drawContribNutriGr==1)
  {   
    magsContribNutrisGraph = [EZGraph createBegin: [self getZone]];
    [magsContribNutrisGraph setGraphics: 0];
    [magsContribNutrisGraph setFileOutput: 1];
    [magsContribNutrisGraph setFileName: "data/data.contribNuts"];
    magsContribNutrisGraph = [magsContribNutrisGraph createEnd]; 
    for(i=0; i<[modelSwarm getNutrisNum]; i++) 
    {   
      text[0] = 'A'+i;         // rising A,B,C,...  
      text[1] = '\0';	   
      strcat(text,"_nutri"); 
       // pretty dangerous way: in getMagsBiomass I have internal counter
       // which count calls to selector and return various arr[counter++]
       // I just hope order of calling selector will stay the same
      [magsContribNutrisGraph createSequence: text
		      withFeedFrom: modelSwarm
		      andSelector: M(getContribNutri)]; 
    }		  
  }		  

  if(drawIOEntropyGr==1)
  {  
    ioEntropyGraph = [EZGraph createBegin: self];
    [ioEntropyGraph setGraphics: 0];
    [ioEntropyGraph setFileOutput: 1];
    [ioEntropyGraph setFileName: "data/data.entropy"];
    ioEntropyGraph = [ioEntropyGraph createEnd];
    [ioEntropyGraph createSequence: "input"
                     withFeedFrom: modelSwarm
		     andSelector: M(getInEntropy)];
    [ioEntropyGraph createSequence: "output"
                     withFeedFrom: modelSwarm
		     andSelector: M(getOutEntropy)];
    [ioEntropyGraph createSequence: "enzyme"
                     withFeedFrom: modelSwarm
		     andSelector: M(getEnzEntropy)];
   }
  
  if(drawIOCardStatGr==1)
  {  
    ioCardStatGraph = [EZGraph createBegin: self];
    [ioCardStatGraph setGraphics: 0];
    [ioCardStatGraph setFileOutput: 1];
    [ioCardStatGraph setFileName: "data/data.ioCardStat"];
    ioCardStatGraph = [ioCardStatGraph createEnd];
    [ioCardStatGraph createSequence: "in_card_avg"
                     withFeedFrom: modelSwarm
		     andSelector: M(getInCardAvg)];
    [ioCardStatGraph createSequence: "out_card_avg"
                     withFeedFrom: modelSwarm
		     andSelector: M(getOutCardAvg)];
    [ioCardStatGraph createSequence: "enz_card_avg"
                     withFeedFrom: modelSwarm
		     andSelector: M(getEnzCardAvg)];
    [ioCardStatGraph createSequence: "in_card_std"
                     withFeedFrom: modelSwarm
		     andSelector: M(getInCardStd)];
    [ioCardStatGraph createSequence: "out_card_std"
                     withFeedFrom: modelSwarm
		     andSelector: M(getOutCardStd)];
    [ioCardStatGraph createSequence: "enz_card_std"
                     withFeedFrom: modelSwarm
		     andSelector: M(getEnzCardStd)];
  }
  
  if(drawOptFracsStatGr==1)
  {  
    optFracsStatGraph = [EZGraph createBegin: self];
    [optFracsStatGraph setGraphics: 0];
    [optFracsStatGraph setFileOutput: 1];
    [optFracsStatGraph setFileName: "data/data.optStat"];
    optFracsStatGraph = [optFracsStatGraph createEnd];
    [optFracsStatGraph createSequence: "globalErr"
                     withFeedFrom: modelSwarm
		     andSelector: M(getOptFracsError)];
    [optFracsStatGraph createAverageSequence: "avgLocalErr"
		       withFeedFrom: magList 
		       andSelector: M(getD)];
    [optFracsStatGraph createSequence: "IFD"
                     withFeedFrom: modelSwarm
		     andSelector: M(getIFD)];
  }
  
  if(drawMetabGr==1)
  {  
    metabGraph = [EZGraph createBegin: [self getZone]];
    [metabGraph setGraphics: 0];
    [metabGraph setFileOutput: 1];
    [metabGraph setFileName: "data/data.MetabRates"];
    metabGraph = [metabGraph createEnd];
    [metabGraph createAverageSequence: "totalMetab"
                   withFeedFrom: magList
		   andSelector: M(getTotalMetab)];
        // special moveMetab to count only Mags which hasMoved = 1
    [metabGraph createSequence: "moveMetab"     
                   withFeedFrom: modelSwarm
		   andSelector: M(getMoveMetabAvg)];
    [metabGraph createAverageSequence: "consRate"
                   withFeedFrom: magList 
		   andSelector: M(getConsRate)];
    [metabGraph createAverageSequence: "magSize"
                   withFeedFrom: magList
		   andSelector: M(getMagSize)];
    [metabGraph createAverageSequence: "vision"
                   withFeedFrom: magList
		   andSelector: M(getVision)];
    [metabGraph createAverageSequence: "maxMR"
                   withFeedFrom: magList
		   andSelector: M(getMaxMR)];
    /*    [metabGraph createSequence: "enzMetab"     
                   withFeedFrom: modelSwarm 
		   andSelector: M(getEnzMetabAvg)];*/
    [metabGraph createAverageSequence: "satisfMetab"     
                   withFeedFrom: magList
		   andSelector: M(getSatisfMetab)];
  }

 printf("  Done\n");
	       	       
  return self;
}


- tick
{
//  printf("\n\t%d ",tik++ );
  printf("\n\t%d \t %d\t %d\t %d",tik++,[[modelSwarm getMagList] getCount],
 [[modelSwarm getReaperQueue] getCount],[[modelSwarm getBirthQueue] getCount]);
  return self;
}


- buildActions
{
  int nutrisNum;
 printf("  OS: buildActions ..");

  [super buildActions];
  [modelSwarm buildActions];
  nutrisNum=[modelSwarm getNutrisNum];
  
  displayActions = [ActionGroup create: self];

  if(drawPopulGr == 1) 
          [displayActions createActionTo: populationGraph   message: M(step)];
  if(drawNutrisGr == 1)	       	       
          [displayActions createActionTo: allNutriGraph         message: M(step)];
  if(drawNutriFracsGr == 1)	       	       
          [displayActions createActionTo: allNutriFracsGraph message: M(step)];
  if(drawFreeBiomassGr == 1)	       	       
          [displayActions createActionTo: freeBiomassGraph  message: M(step)];
  if(drawCyclRatiosGr == 1)	       	       
          [displayActions createActionTo: cyclRatiosGraph   message: M(step)];
  if(drawMagsBiomassGr == 1)	       	       
          [displayActions createActionTo: magsBiomassGraph     message: M(step)];
  if(drawContribNutriGr == 1)	       	       
          [displayActions createActionTo: magsContribNutrisGraph    message: M(step)];
  if(drawIOEntropyGr == 1)	       	       
          [displayActions createActionTo: ioEntropyGraph    message: M(step)];
  if(drawIOCardStatGr == 1)	       	       
          [displayActions createActionTo: ioCardStatGraph   message: M(step)];
  if(drawOptFracsStatGr == 1)	       	       
          [displayActions createActionTo: optFracsStatGraph message: M(step)];
  if(drawMetabGr == 1)	       	       
          [displayActions createActionTo: metabGraph        message: M(step)];

  [displayActions createActionTo: self                message: M(checkStop)];

  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
  
  stopSchedule = [Schedule create: self];
  [stopSchedule at: experimentDuration 
	        createActionTo: self
		message: M(stopRunning) ];

 printf("Done\n");
 
  return self;
}


- saveModel       // called when all mags are dead (checkStop)
{
  char filename[MAXFILENAME];

  [modelSwarm setExperimentTime: expTime];
  if( strlen([modelSwarm getSimName]) > MAXFILENAME-1 )
    [InvalidCombination raiseEvent: "\n OS: Simulation name too long"]; 

  sprintf (filename, "s%s.setup",[modelSwarm getSimName]);
  [modelSwarm saveMSto: filename];
  [modelSwarm saveMSto: "model.setup"];

  return self;
}

- checkStop
{
  //  char text[MAXFILENAME+20];
  int magCount;

  expTime += displayFrequency;
  magCount = [[modelSwarm getMagList] getCount];
  //fprintf(statusFile,"\n %d \t%d", expTime, magCount);
  printf("\n     %4d \t\t%4d", expTime, magCount);

  if( magCount == 0 )
  {  
    printf("\nAll mags dead\n\007");
    [self stopRunning];
  }    
  return self;
}

- stopRunning
{
  char text[MAXFILENAME+20];

 printf("\n  OS: stopRunning: closing, saving, packing data ..");
  
  [self saveModel];
  [getTopLevelActivity() terminate]; // Terminate the simulation.
  if(drawPopulGr == 1) 
          [populationGraph drop];
  if(drawNutrisGr == 1)	       	       
          [allNutriGraph drop];
  if(drawNutriFracsGr == 1)	       	       
          [allNutriFracsGraph drop];
  if(drawFreeBiomassGr == 1)	       	       
          [freeBiomassGraph drop];
  if(drawCyclRatiosGr == 1)	       	       
          [cyclRatiosGraph drop];
  if(drawMagsBiomassGr == 1)	       	       
          [magsBiomassGraph drop];  
  if(drawContribNutriGr == 1)	       	       
          [magsContribNutrisGraph drop]; 
  if(drawIOEntropyGr == 1)	       	       
          [ioEntropyGraph drop]; 
  if(drawIOCardStatGr == 1)	       	       
          [ioCardStatGraph drop];
  if(drawOptFracsStatGr == 1)	       	       
          [optFracsStatGraph drop];
  if(drawMetabGr == 1)	       	       
          [metabGraph drop];     
  //  fclose(statusFile);

  system("cp model.setup data/model.setup");    
  printf("\n cp model.setup data/model.setup");
  sprintf(text,"tar -zcf a%s.data.tgz data/*",[modelSwarm getSimName]);
  printf("\n%s",text);
  system(text);    
 printf("Done \n");
  return self;
}

- activateIn: swarmContext
{
 printf("  OS: ActivateIn ..");

  [super activateIn: swarmContext];
  [modelSwarm activateIn: self];

  [stopSchedule activateIn: self];
  [displaySchedule activateIn: self];

 printf("Done \n");
  return [self getSwarmActivity];
}

- go 
{
  printf(" \n --- Batch mode --- ");

  printf("\n\t Experiment Duration: %d",experimentDuration);
  printf("\n\t Logging data every %d steps to files data/data.*",displayFrequency);

  printf("\n\n____ time \t agents");
  
  [[self getActivity] run];
  return [[self getActivity] getStatus];
}

@end















