#import "LLAMJ_ObserverSwarm.h"

@implementation LLAMJ_ObserverSwarm

+createBegin: (id) aZone {
  LLAMJ_ObserverSwarm * obj;
  ProbeMap * probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;
  obj->zoomSize = 5;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "zoomSize"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-buildObjects {
  id modelZone;
  
  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];
  llamjModelSwarm = [LLAMJ_ModelSwarm create: modelZone];
  
  [probeDisplayManager createProbeDisplayFor: llamjModelSwarm];
  [probeDisplayManager createProbeDisplayFor: self];

  [controlPanel waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;


  // Finished probing, set it all up.
  

  // create a colormap
  colormap = [XColormap create: globalZone];
  [colormap setColor: 0 ToGrey: 1.0];
  [colormap setColor: 1 ToGrey: 0.0];

  // create a window for display
  displayWindow = [ZoomRaster create: globalZone];
  [displayWindow setColormap: colormap];
  [displayWindow setZoomFactor: zoomSize];
  [displayWindow setWidth: [llamjModelSwarm getGridSize]
		 Height: [llamjModelSwarm getGridSize]];
  [displayWindow setWindowTitle: "Company World"];
  [displayWindow pack];

  [llamjModelSwarm buildObjects: displayWindow];

  // set up the graph of number triggered
  densityGraph = [BLTGraph create: globalZone];
  [densityGraph title: "Density vs. time"];
  [densityGraph axisLabelsX: "time" Y: "density"];

  densityData = [densityGraph createElement];
  [densityData setLabel: "Density"];
  [densityData setColor: "black"];

  densityGrapher = [ActiveGraph createBegin: globalZone];
  [densityGrapher setElement: densityData];
  [densityGrapher setDataFeed: [llamjModelSwarm getWorld]];
  [densityGrapher setProbedSelector: M(getDensity)];
  densityGrapher = [densityGrapher createEnd];

  [densityGraph pack];


  
  return self;
}  

-buildActions {
  [super buildActions];
  
  [llamjModelSwarm buildActions];

  // MODIFY: schedule display objects here.
  displayActions = [ActionGroup create: [self getZone]];
  [displayActions createActionTo: displayWindow       message: M(drawSelf)];
  [displayActions createActionTo: densityGrapher      message: M(step)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: controlPanel        message: M(doTkEvents)];
  
  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [llamjModelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}


@end
