#import "LLAMJ_ModelSwarm.h"
#import <simtools.h>


@implementation LLAMJ_ModelSwarm

-(int) getGridSize { return gridSize; }
-(int) getK { return K; }
-(int) getEl { return Elower; }
-(int) getEu { return Eupper; }
-(int) getBirth { return Birth; }
-getWorld { return world; }


// createBegin: here we set up the default simulation parameters.
+createBegin: (id) aZone {
  LLAMJ_ModelSwarm * obj;
  ProbeMap * probeMap;

  obj = [super createBegin: aZone];

  obj->K = 2;
  obj->Elower = 6;
  obj->Eupper = 20;
  obj->Birth = 3;
  obj->gridSize = 50;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "gridSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "K"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "Elower"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "Eupper"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "Birth"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}



-buildObjects: (id) displayWidget {

  // allow our parent class to build anything.
  [super buildObjects];
  
  // build grid
  world = [LLAMJ_Ca2d createBegin: [self getZone]  
                               setModelSwarm: self
                               setDisplayWidget: displayWidget];
  [world setSizeX: gridSize Y: gridSize];
  [world setNumStates: 2];
  world = [world createEnd];
  
  return self;
}



-buildActions {
  [super buildActions];

  modelActions = [ActionGroup create: [self getZone]];
  [modelActions createActionTo:      world        message: M(stepRule)];  

  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}


-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];
  [modelSchedule activateIn: self];
  return [self getSwarmActivity];
}

@end
