// Heatbugs application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <simtools.h>     // initSwarm () and swarmGUIMode
#import <simtoolsgui.h>  // GUISwarm
#import "MySwarmAppArguments.h"
#import "HeatbugObserverSwarm.h"
#import "HeatbugBatchSwarm.h"

// The main() function is the top-level place where everything starts.
// For a typical Swarm simulation, in main() you create a toplevel
// Swarm, let it build and activate, and set it to running.

int
main (int argc, const char **argv)
{
  id theTopLevelSwarm;
  int i;

  // Swarm initialization: all Swarm apps must call this first.
  // initSwarm (argc, argv);

  // Do this instead if custom command line arguments are needed:
  initSwarmArguments (argc, argv, [MySwarmAppArguments class]);

  // swarmGUIMode is set in initSwarm(). It's set to be 0 if you
  // typed heatbugs -batchmode. Otherwise, it's set to 1.

  printf("The         vary-Seed flag was %d\n", [arguments getVarySeedFlag]);
  printf("The        batch-mode flag was %d\n", [arguments getBatchModeFlag]);
  printf("The      app-mode argument was %s\n", [arguments getAppModeString]);
  printf("The show-current-time flag was %d\n", [arguments getShowCurrentTimeFlag]);
  printf("The      protocol argument was %s\n", [arguments getProtocolArg]);
  printf("The         drone argument was %s\n", [arguments getDroneArg]);

  printf("The    swarm-home directory is %s\n", [arguments getSwarmHome]);
  printf("The        application name is %s\n", [arguments getAppName]);
  printf("The         executable path is %s\n", [arguments getExecutablePath]);
  printf("The             config-path is %s\n", [arguments getConfigPath]);
  printf("The               data-path is %s\n", [arguments getDataPath]);
  printf("The default-app-config-path is %s\n", [arguments getAppConfigPath]);
  printf("The   default-app-data-path is %s\n", [arguments getAppDataPath]);
  printf("The command line arguments (tokens) are :\n");
  for (i=0; i< [arguments getArgc]; i++)
     printf("     %s\n", [arguments getArgv][i]);
 
  if (swarmGUIMode == 1)
    {
      // We've got graphics, so make a full ObserverSwarm to get GUI objects
      theTopLevelSwarm = [HeatbugObserverSwarm createBegin: globalZone];
      SET_WINDOW_GEOMETRY_RECORD_NAME (theTopLevelSwarm);
      theTopLevelSwarm = [theTopLevelSwarm createEnd];
    }
  else
    // No graphics - make a batchmode swarm and run it.
    theTopLevelSwarm = [HeatbugBatchSwarm create: globalZone];

  [theTopLevelSwarm buildObjects];
  [theTopLevelSwarm buildActions];
  [theTopLevelSwarm activateIn: nil];
  [theTopLevelSwarm go];

  // theTopLevelSwarm has finished processing, so it's time to quit.
  return 0;
}
