#import "grid.h"
#import "GridTurtle.h"

#define __USE_FIXED_PROTOTYPES__   // for gcc headers
#include <stdio.h>

int main(void)
{
  id   aZone, anOrderedSet, aTurtle, turtles[10], index;
  int  i;

  initModule( grid );

  aZone = [Zone create: globalZone];

  anOrderedSet = [OrderedSet createBegin: aZone];
  [anOrderedSet setIndexFromMemberLoc:
    offsetof( GridTurtle_c, listMembership )];
  anOrderedSet = [anOrderedSet createEnd];

  printf( "count: %d\n", [anOrderedSet getCount] );

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: aZone];
    turtles[i] = aTurtle;
    [aTurtle turn: -1];
    [aTurtle move: i * 10];
    if ( i & 1 ) [anOrderedSet add: aTurtle];
  }

  printf( "count: %d\n", [anOrderedSet getCount] );

  index = [anOrderedSet begin: scratchZone];
  while ( (aTurtle = [index next]) ) {
    [aTurtle print];
  }
  for ( i = 0; i < 10; i++ ) {
    if ( ! [anOrderedSet contains: turtles[i]] ) {
      printf( "turtle not found at %d\n", i );
    }
  }

  for ( i = 0; i < 10; i++ ) {
    if ( i % 2 ) {
      [anOrderedSet remove: turtles[i]];
    } else {
      [anOrderedSet add: turtles[i]];
    }
  }
  index = [anOrderedSet begin: scratchZone];
  while ( (aTurtle = [index next]) ) {
    [aTurtle print];
  }
  for ( i = 0; i < 10; i++ ) {
    if ( ! [anOrderedSet contains: turtles[i]] ) {
      printf( "turtle not found at %d\n", i );
    }
  }

  [anOrderedSet xprint];
  [anOrderedSet drop];
  [aZone xprint];
  [aZone drop];
  return 0;
}
