// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 21/01/97.

// Definition de l'observateur du monde.
// Le role de l'observateur est de fournir des informations sur la simulation.

#import <swarmobject.h>
#import <space.h>
#import <activity.h>
#import <tkobjc.h>
#import <collections.h>
#import <simtools.h>
#import <analysis.h>
#import "DispersionModelSwarm.h"

@interface DispersionObserverSwarm : GUISwarm {
  int displayFrequency;         // Frequence d'affichage

  id displayActions;		// Schedulling des objets dependants du Swarm
  id displaySchedule;

  DispersionModelSwarm *dispersionModelSwarm;  // Reference sur le modele observe

  // Objets de visualisation et d'observations
  XColormap * colormap;		  // Palette des couleurs
  ZoomRaster * worldRaster;       // Visualisation du monde
  EZGraph * unhappyGraph;         // Visualisation de l'insatisfaction

  Object2dDisplay *agentDisplay;  // Visualisation des agents
  Value2dDisplay *spaceDisplay;
}

+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end


