// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 20/01/97.
// Implementation de l'espace de densite.

#import "DensitySpace.h"
#import <random.h>

const Density maxDensity= 100;
const Density minDensity= 1;

typedef struct {
  Density d;
  int x, y;
} Solution;

@implementation DensitySpace

// Modification du voisinage
-setNeighborhood: (int) value {
  neighborhood= value;
  return self;
}

// Incrementation de la densite dans le voisinage de la cellule (x,y).
-incDensityAroundX: (int) x Y: (int) y {
  int i, j;
  int currentX, currentY;
  int densityHere;

  for (i = x - neighborhood; i <= x + neighborhood; i++) {
    for (j = y - neighborhood; j <= y + neighborhood; j++) {
      currentX= (i+xsize)%xsize;
      currentY= (j+ysize)%ysize;

      densityHere= [self getValueAtX: currentX Y: currentY];
      [self putValue: densityHere+1 atX: currentX Y: currentY];
    }
  }
  return self;
}

// Decrementation de la densite dans le voisinage de la cellule (x,y).
-decDensityAroundX: (int) x Y: (int) y {
  int i, j;
  int currentX, currentY;
  int densityHere;

  for (i = x - neighborhood; i <= x + neighborhood; i++) {
    for (j = y - neighborhood; j <= y + neighborhood; j++) {
      currentX= (i+xsize)%xsize;
      currentY= (j+ysize)%ysize;

      densityHere= [self getValueAtX: currentX Y: currentY];
      [self putValue: densityHere-1 atX: currentX Y: currentY];
    }
  }
  return self;
}

// Recherche de la meilleure densite dans le voisinage immediat d'un agent.
// L'algorithme construit une liste ordonnee des meilleures positions.
// Ensuite, l'une des meilleures est choisie aleatoirement.
-(Density) findBetterDensity: (DensityExtremeType) type
		      X: (int *) px 
		      Y: (int *) py {
  Density bestDensity;
  int x, y;
  int bestX, bestY;

  // Initialisation de la meilleure densite, a priori sur le site courant.
  bestX = *px;
  bestY = *py;
  bestDensity = [self getValueAtX: bestX Y: bestY];

  // Recherche de la meilleure densite dans le voisinsage immediat.
  for (x = *px-1; x <= *px+1; x++) {
    for (y = *py-1; y <= *py+1; y++) {
      Density densityHere;
      BOOL hereIsBetter;
      int currentX= (x+xsize)%xsize;
      int currentY= (y+ysize)%ysize;

      densityHere = [self getValueAtX: currentX Y: currentY];
      hereIsBetter = (type == low) ? (densityHere > bestDensity)
	                           : (densityHere < bestDensity);
      if (hereIsBetter) {
	bestDensity = densityHere;
	bestX = currentX;
	bestY = currentY;
      }
    }
  }

  // Renvoie de la meilleure densite trouvee.
  *px = (bestX + xsize) % xsize;
  *py = (bestY + ysize) % ysize;

  return bestDensity;
}

// Renvoie la densite a la position demandee
-(Density) getDensityAtX: (int) x Y: (int) y {
  return [self getValueAtX: x Y: y];
}

@end
