// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 21/01/97.

// Implementation de l'observateur du monde.

#import "DispersionObserverSwarm.h"

@implementation DispersionObserverSwarm

// Creation du DispersionObserverSwarm : initialisation.
+createBegin: (id) aZone {
  DispersionObserverSwarm * obj;
  ProbeMap * probeMap;

  // Creation de l'objet Observateur
  obj = [super createBegin: aZone];
  obj->displayFrequency = 1;

  // Creation du visualisateur de l'observateur
  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Ajout des parametres accessibles pour les simulations.
  // Ici seul la frequence de prelevement des donnees est accessible.
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

// Creation du DispersionObserverSwarm : validation.
-createEnd {
  return [super createEnd];
}

// Creation des objets qui dependent du "DispersionObserverSwarm".
-buildObjects {
  id modelZone;

  [super buildObjects];

  // Creation du modele observe.
  modelZone = [Zone create: [self getZone]];
  dispersionModelSwarm = [DispersionModelSwarm create: modelZone];

  // Creation des interfaces de manipulations de l'observateur et du modele
  [probeDisplayManager createProbeDisplayFor: dispersionModelSwarm];
  [probeDisplayManager createProbeDisplayFor: self];

  // Mise en attente d'un evenement. L'utilisateur doit appuyer sur un bouton
  // de la fenetre de controle.
  [controlPanel setStateStopped] ;

  // Le systeme est parametre. On peut commencer a creer les objects de
  // la simulation.

  // Construction des objets dependants du modele
  [dispersionModelSwarm buildObjects];

  // Definition des couleurs de visualisation des agents.
  colormap= [XColormap create: [self getZone]];

  [colormap setColor: 0 ToName: "white"];
  [colormap setColor: 1 ToName: "green"];

  // Coloration des agents en vert.
  // On recupere la liste des agents de chaque speedSwarm pour colorier
  // les agents.
  {
    int i;
    id tmpList;
    id tmpArray= [dispersionModelSwarm getSpeedSwarmArray];
    
    for (i=0; i<[tmpArray getCount]; i++) {
      tmpList= [[tmpArray atOffset: i] getAgentList];
      [tmpList forEach: M(setAgentColor:) : (void *) 1];
    }
  }

  // Creation d'une fenetre 2D pour visualiser les agents.
  worldRaster = [ZoomRaster create: [self getZone]];
  [worldRaster setColormap: colormap];  // Lien vers la palette de couleurs
  [worldRaster setZoomFactor: 4];       // Zoom
  [worldRaster setWidth: [[dispersionModelSwarm getWorld] getSizeX] // Taille
	       Height: [[dispersionModelSwarm getWorld] getSizeY]];
  [worldRaster setWindowTitle: "Dispersion World"]; // Label de la fenetre
  [worldRaster pack]; // Dessine la fenetre

  // Visualisation des agents sur la fenetre prevue a cet effet
  // L'initialisation cree un lien vers la fenetre de visualisation
  // des agents ("worldRaster"), un autre lien vers l'environnement
  // dans lequel se deplace les agents ([dispersionModelSwarm getWorld])
  // ainsi qu'un lien vers la methode pour afficher les agents.
  agentDisplay= [Object2dDisplay createBegin: [self getZone]];
  [agentDisplay setDisplayWidget: worldRaster];
  [agentDisplay setDiscrete2dToDisplay: [dispersionModelSwarm getWorld]];
  // IL DOIT Y AVOIR UN PROBLEME !!!
  [agentDisplay setDisplayMessage: M(drawSelfOn:)];
  agentDisplay = [agentDisplay createEnd];

  // Visualisation de l'etat d'un agent selectionne avec
  // le bouton droit de la souris.
  [worldRaster setButton: ButtonRight
	       Client: agentDisplay
	       Message: M(makeProbeAtX:Y:)];

  // Visualisation de l'insatisfaction moyenne des agents
  // et de la densite moyenne souhaitee par l'ensemble des agents.
  unhappyGraph= [EZGraph createBegin: [self getZone]];
  [unhappyGraph setTitle: "Unhappiness of agents vs. time"];
  [unhappyGraph setAxisLabelsX: "time" Y: "unhappiness"];
  unhappyGraph= [unhappyGraph createEnd];

  { 
    int i;
    char s[10];
    id tmpArray= [dispersionModelSwarm getSpeedSwarmArray];
    id tmpList;
    
    for (i=0; i<[tmpArray getCount]; i++) {
      tmpList= [[tmpArray atOffset: i] getAgentList];
      if (tmpList != nil) {
	sprintf(s, "speed: %d", i+1);
	[unhappyGraph createAverageSequence: s
		      withFeedFrom: tmpList
		      andSelector: M(getUnhappiness)];
      }
    }
  }

  return self;
}

// Creation du groupes d'actions dans le modele
-buildActions {
  [super buildActions];

  // Activation du modelSwarm
  [dispersionModelSwarm buildActions];

  displayActions = [ActionGroup create: [self getZone]];

  // Affichage du monde
  [displayActions createActionTo: worldRaster       message: M(erase)];
  [displayActions createActionTo: agentDisplay      message: M(display)];
  [displayActions createActionTo: worldRaster       message: M(drawSelf)];

  // Mise a jour du graphique
  [displayActions createActionTo: unhappyGraph message: M(step)];

  // Mise a jour des interfaces de visualisation des objets.
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: controlPanel        message: M(doTkEvents)];

  // Mise en place du scheduller.
  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
  
  return self;
}

// Activation du scheduler
-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];
  [dispersionModelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  return [self getSwarmActivity];
}

@end
