// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 13/02/97.

// Le DispersionModelSwarm est le Swarm racine du modele que l'on concoit.
// Il definit le monde dans lequel les agents vont se mouvoir. Il a pour
// charge de gerer l'ensemble de l'application que ce soit directement
// ou indirectement par delegation des Swarm qu'il gere.

#import <swarmobject.h>
#import "Agent.h"
#import "DensitySpace.h"
#import "SpeedSwarm.h"
#import <space.h>
#import <activity.h>
#import <collections.h>

@interface DispersionModelSwarm : Swarm {
  int nbOfAgents;                        // Nombre d'agents presents dans le monde
  int worldXSize, worldYSize;            // Dimensions du monde
  int neighborhood;                      // Distance de voisinage
  int convergenceFactor;                 // Facteur de convergeance des densites
  int minIdealDensity, maxIdealDensity;  // Intervalle de densite
  BOOL isMinDensity;                       // Densite ideale active == minDensity
  int minSpeed, maxSpeed;                // Intervalle de vitesse
  double randomMoveProbability;          // Probabilite de mouvement aleatoire
  int timeRange;

  id modelActions;                       // Schedulling des SpeedSwarm
  id modelSchedule;

  id speedSwarmArray;                    // Tableau des SpeedSwarm
  id agentListInMigration;               // Liste des agents en migration
  Grid2d *world;                         // Grille de positionnement
  DensitySpace *densityMap;              // Carte des densite
}

// Methodes d'acces au modele.
-getSpeedSwarmArray;
-(Grid2d *) getWorld;
-(DensitySpace *) getDensityMap;

// Methode assurant la migration des agents.
-doMigration;

// Methode recalculant la densite ideale des agents
-computeDensity;

// Methodes generales necessaires pour les swarms.
+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end
