// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************

// ObserverSwarm.m

#import "ObserverSwarm.h"
#import <activity.h>
#import <simtoolsgui.h>

@implementation ObserverSwarm

+ createBegin: aZone
{
  ObserverSwarm *obj;
  id <ProbeMap> probeMap;

  // Superclass createBegin to allocate ourselves.

  obj = [super createBegin: aZone];

  // Fill in the relevant parameters.

//  obj->displayFrequency = 1;  // displayFrequency is not used here in
                                // a traditional way
  obj->displayErrorGraphInVerificationSet = 1; // 1=yes, 0=not
  obj->displayErrorGraphInTrainingSet     = 1; // 1=yes, 0=not

// +++++++ start
  obj->numberOfTheAgentA_ToBeObservedDirectly = 1; // we can choose the agent
// +++++++ end

  obj->stopAtEpochGroupNumber             = 0; // to stop the program and to
                                               // save the weights (if != 0)

  // to build a customized probe map
  // without a probe map, the default is to show all variables and messages
  // here we choose to customize the appearance of the probe, to give a nicer
  // interface

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // add variables to be probed

  [probeMap addProbe: [probeLibrary getProbeForVariable: 
                                      "displayErrorGraphInVerificationSet"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: 
                                      "displayErrorGraphInTrainingSet"
                                    inClass: [self class]]];

// +++++++ start
  [probeMap addProbe: [probeLibrary getProbeForVariable:
                                      "numberOfTheAgentA_ToBeObservedDirectly"
                                    inClass: [self class]]];
// +++++++ end

  [probeMap addProbe: [probeLibrary getProbeForVariable:
                                      "stopAtEpochGroupNumber"
                                    inClass: [self class]]];

  // set our custom probeMap into the probeLibrary as the default probe for
  // the ObserverSwarm class

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

- createEnd
{
  return [super createEnd];
}


- buildObjects
{
  [super buildObjects];

  modelSwarm = [ModelSwarm create: self];

  // to create probe objects on the model and the observer (self, here)
  // ARCHIVED to allow the "Save" button to operate

  CREATE_ARCHIVED_PROBE_DISPLAY (modelSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);

  // we pause here to allow the parameters to be changed.

  [controlPanel setStateStopped];


  // The system will wait until the user hits "Start" or "Next"
  // on the control panel

  [modelSwarm buildObjects];

  // Observer display objects.

  if (displayErrorGraphInVerificationSet == 1)
  {
  // error graph
  errorGraphInVerificationSet = [EZGraph createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (errorGraphInVerificationSet);
                                                    // to allow "Save"
  [errorGraphInVerificationSet setTitle: "Errors in verification set."];
  [errorGraphInVerificationSet setAxisLabelsX:
   "(Epoch Groups) x (# of p. in ver. set) - 1" Y: "Error"];
  errorGraphInVerificationSet = [errorGraphInVerificationSet createEnd];

  [errorGraphInVerificationSet createAverageSequence:
                               "Mean bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInVerificationSet)];

  [errorGraphInVerificationSet createMinSequence:
                               "Min bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInVerificationSet)];

  [errorGraphInVerificationSet createMaxSequence:
                               "Max bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInVerificationSet)] ;

  [errorGraphInVerificationSet createAverageSequence:
                               "Mean prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInVerificationSet)] ;
  [errorGraphInVerificationSet createMinSequence:
                               "Min prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInVerificationSet)] ;

  [errorGraphInVerificationSet createMaxSequence:
                               "Max prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInVerificationSet)] ;

  }

  if (displayErrorGraphInTrainingSet == 1)
  {
  // error graph
  errorGraphInTrainingSet = [EZGraph createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (errorGraphInTrainingSet);
                                                    // to allow "Save"
  [errorGraphInTrainingSet setTitle: "Errors in training set."];
  [errorGraphInTrainingSet setAxisLabelsX:
   "(Epoch Groups) x (# of p. in ver. set) - 1" Y: "Error"];
  errorGraphInTrainingSet = [errorGraphInTrainingSet createEnd];

  [errorGraphInTrainingSet createAverageSequence:
                               "Mean bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInTrainingSet)];

  [errorGraphInTrainingSet createMinSequence:
                               "Min bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInTrainingSet)];

  [errorGraphInTrainingSet createMaxSequence:
                               "Max bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInTrainingSet)] ;

  [errorGraphInTrainingSet createAverageSequence:
                               "Mean prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInTrainingSet)] ;
  [errorGraphInTrainingSet createMinSequence:
                               "Min prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInTrainingSet)] ;

  [errorGraphInTrainingSet createMaxSequence:
                               "Max prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInTrainingSet)] ;

  }


  // inputs, outputs and targets for one or more agents (via EZGraph), needed
  // also to save the values in a file; we can reproduce this widget to
  // obtain the graph for further agents

// +++++++ start
  // a check
  if([modelSwarm getAgentNumber] == 0)
                         numberOfTheAgentA_ToBeObservedDirectly=0;

  // this may be 0 if we do not have any agent (above) or if we choose to
  // have no display
  if (numberOfTheAgentA_ToBeObservedDirectly > 0) // the value comes from probe
  {
  // to identify the address of the chosen agent

  [[modelSwarm getAgentArrayIndex] setOffset:
                                   numberOfTheAgentA_ToBeObservedDirectly-1];
  agentA = [[modelSwarm getAgentArrayIndex] get];
  agentA_Interface = [agentA getInterface];


   // agent A graph
   agentA_Graph = [EZGraph createBegin: [self getZone]];
   SET_WINDOW_GEOMETRY_RECORD_NAME (agentA_Graph); // to allow "Save"
   [agentA_Graph setTitle: "Agent A data."];
   [agentA_Graph setAxisLabelsX:
    "(Epoch Groups) x (# of p. in ver. set) - 1" Y: "Value"];
   agentA_Graph = [agentA_Graph createEnd];

// the following setting doubles the number of messages sent
// by createSequence; so the counters in the specific Interface proceed
// by 0.5steps
   [agentA_Graph setFileOutput: (BOOL) 1];
                                           // to send the data also to a file

   [agentA_Graph createSequence: "L1_input"
                                 withFeedFrom: agentA_Interface
                                 andSelector: M(getL1)];
   [agentA_Graph createSequence: "L2_input"
                                 withFeedFrom: agentA_Interface
                                 andSelector: M(getL2)];
   [agentA_Graph createSequence: "OR_output"
                                 withFeedFrom: agentA_Interface
                                 andSelector: M(getOR_out)];
   [agentA_Graph createSequence: "OR_target"
                                 withFeedFrom: agentA_Interface
                                 andSelector: M(getOR_target)];
   [agentA_Graph createSequence: "XOR_output"
                                 withFeedFrom: agentA_Interface
                                 andSelector: M(getXOR_out)];
   [agentA_Graph createSequence: "XOR_target"
                                 withFeedFrom: agentA_Interface
                                 andSelector: M(getXOR_target)];

  }
// +++++++ end

  return self;
}

- buildActions
{
  int k;
  [super buildActions];

  // model schedule.

  [modelSwarm buildActions];

  // ActionGroup for Observer display
  // it gets the number of steps in each cycle, required to display
  // all the patterns of an agent (in its verification set)
  patternNumberInVerificationSet=[modelSwarm
                                  getPatternNumberInVerificationSet];

  displayActions = [ActionGroup create: self];

  // to update probes
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  [displayActions createActionTo: errorGraphInVerificationSet
                                                           message: M(step)];
  [displayActions createActionTo: errorGraphInTrainingSet  message: M(step)];
  [displayActions createActionTo: self message: M(checkToStop)];

  // Display schedule. Note that the repeat interval is set by our
  // own Swarm data structure. The display is frequently the slowest part of a
  // simulation, when it is redraw less frequently things are faster

  displaySchedule = [Schedule createBegin: self];


  // the if condition is related to the CT use of the program
  if (patternNumberInVerificationSet < 0)
  [displaySchedule setRepeatInterval: 
                       -1*patternNumberInVerificationSet];
  else
  [displaySchedule setRepeatInterval:
                          patternNumberInVerificationSet]; // note frequency!



  displaySchedule = [displaySchedule createEnd];

  if (patternNumberInVerificationSet < 0)
  [displaySchedule at: -1*patternNumberInVerificationSet-1
                           createAction: displayActions];
  else
  [displaySchedule at:    patternNumberInVerificationSet-1
                           createAction: displayActions];


// +++++++ start
  if (numberOfTheAgentA_ToBeObservedDirectly > 0)
  {
  // the if condition is related to the CT use of the program
  if (patternNumberInVerificationSet < 0)
   for (k=0;k<=-1*patternNumberInVerificationSet-1;k++)
       [displaySchedule at: k
       createActionTo: agentA_Graph message: M(step)];
  else
   for (k=0;k<=   patternNumberInVerificationSet-1;k++)
       [displaySchedule at: k
       createActionTo: agentA_Graph message: M(step)];
   }
// +++++++ end

  return self;
}

- activateIn: swarmContext
{
// activateIn: - to activate the schedules to make them ready to run.

  [super activateIn: swarmContext];

  [modelSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

  // to check for the stopping conditions
- checkToStop
{

  // if stopAtEpochGroupNumber is left to 0, the program will never stop

  if (stopAtEpochGroupNumber == [modelSwarm getCurrentEpochGroup])
  {
      printf("Stopping at epoch group number %4d and\nsaving files.\n",
                                [modelSwarm getCurrentEpochGroup]);

      // agents are receiving the order to save their data
      [[modelSwarm getList] forEach: M(save)];
                                          
      // we can restart by pressing "Start" or "Next"
      [controlPanel setStateStopped];
  }

  return self;
}


@end


