// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************

// ObserverSwarm.h

#import "ModelSwarm.h"
#import "BPCTAgent.h"

// +++++++ start
#import "SpecificInterface.h"  // NB. We have to include the specific
                               // interfaces for the agents
                               // related to the graphics below
// +++++++ end

#import <simtoolsgui/GUISwarm.h>
#import <analysis.h> // to use EZgraph


@interface ObserverSwarm: GUISwarm
{
  int displayFrequency, patternNumberInVerificationSet;
                                        // alternatively used as
                                        // freq. of update in the
                                        // Observer widgets

  id displayActions;                    // schedule data structures
  id displaySchedule;

  id <EZGraph> errorGraphInVerificationSet; // to display the error while
                                            // verifying
  int displayErrorGraphInVerificationSet;

  id <EZGraph> errorGraphInTrainingSet;     // to display the error while
                                            // learning
  int displayErrorGraphInTrainingSet;

  id <EZGraph> agentA_Graph;

  int stopAtEpochGroupNumber, numberOfTheAgentA_ToBeObservedDirectly;

  ModelSwarm *modelSwarm;               // the Swarm containing our neural
                                        // networks

// +++++++ start
  BPCTAgent  * agentA; // an agent that may be accessed directly, if any
  SpecificInterface  * agentA_Interface;
                       // the interface of an agent that has to be accessed
// +++++++ end

}

+ createBegin: aZone;
- createEnd; 
- buildObjects;
- buildActions;
- activateIn: swarmContext;

- checkToStop;

@end

