// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// Matrix.h 

#import <objectbase/SwarmObject.h>

@interface Matrix: SwarmObject
{
  float * m;
  int rows, cols, max, code, firstRow;
}

// to build a matrix, filling it with zeros (see below for 'Code')
- setDimensionRows: (int) r Cols: (int) c Code: (int) cod;

// to buid a vector, filling it with zeros (see below for 'Code')
- setDimension: (int) p Code: (int) cod;

// to shift rows: n   -> n-1
//                n-1 -> n-2
//                etc.
- shift;

// the position of the first row filled with the shift operations
// that we have done (our data matrixex in CT context are filled starting
// from the last row)
- (int) getFirstRow;


// to retrieve a value from a matrix, by row and col (starting from 0,0)
- (float) R: (int) r C: (int) c;

// to retrieve a value from a vector, by position (starting from 0)
- (float) P: (int) p;

// to set a value in a matrix
- R: (int) r C: (int) c setFrom: (float) v;

// to set a value in a vector
- P: (int) p            setFrom: (float) v;

// to set a value in a matrix, adding it to the previous value
- R: (int) r C: (int) c setFromP: (float) v;

// to set a value in a vector, adding it to the previous value
- P: (int) p            setFromP: (float) v;

// to return the number of position in a vector or the result of
// rows and cols in a matrix
- (int) getNumberOfElements;

// to return the number of rows in a matrix or the number of
// rows in a vector (vector are treated here as column vectors)
- (int) getNumberOfRows;

// to return the number of cols in a matrix or 1 in a vector (see above)
- (int) getNumberOfCols;

// the address of the first position of the vector (also a matrix is here
// internally treated as vector)
- (float *) getAddress;  // if necessary ...

// the address of the second position (i.e. &m[1] )
- (float *) getAddress1; // if necessary ...


// EXTERNAL values
// we associate our matrix to a minmax array, to obtain
// 'external' values (those defined in the range of the first two cols
//                    of the minmax files)

// KEEP IN MIND THAT ALL VALUES ARE STORED IN VECTORS AND MATRIXES AS
// INTERNAL VALUES   (those defined in the range of the last  two cols
//                    of the minmax files)

// minmax arrays contain a row for each element (input values and output
// values of the neural network) and four cols:
// col 0 -> min external value
// col 1 -> max external value
// col 2 -> min internal value (for output unit use 0.1 instead of 0)
// col 3 -> max internal value (for output unit use 0.9 instead of 1)

// a shift may be necessary to link the rows of minmax array to the unit
// reported in vectors or matrixes

// to retrieve a value from a given matrix in EXTERNAL metrics, by row and
// col, using 'mm' minmax matrix with a 'sf' col shift, if necessary;
// the given matrix is supposed to be organized with patterns by rows
// and input units or output units or targets by cols

- (float) R: (int) r C: (int) c asExternalValueUsing: mm withShift: (int) sf;

// to set a value in a given matrix from an EXTERNAL metrics, by row and col,
// using 'mm' minmax matrix with a 'sf' col shift, if necessary;
// the given matrix is supposed to be organized with patterns by rows
// and input units or output units or targets by cols

- R: (int) r C: (int) c setFrom: (float) v asExternalValueUsing: mm
                                         withShift: (int) sf;

- R_lastAndC:   (int) c setFrom: (float) v asExternalValueUsing: mm
                                         withShift: (int) sf;


@end


// 'Code' is only used to identify error messages related to an array
