#import <space.h>
#import <gui.h>
#import "Tree.h"
#import "Species.h"

@implementation Tree

- setAge: (int)anAge
{
  age = anAge;
  return self;
}

- setSeedingCounter: (int)aYear
{
  seedingCounter = aYear;
  return self;
}

- setSpecies: aSpecies
{
  species = aSpecies;
  return self;
}

- setX: (int)inX Y: (int)inY
{
  x = inX;
  y = inY;
  return self;
}

- createEnd
{
  age = 0;
  totalHeat = 0;
  seedingCounter = 0;

  return self;
}

- (int)getAge
{
  return age;
}

- (int)getX
{
  return x;
}

- (int)getY
{
  return y;
}

- getSpecies
{
  return species;
}

- clearSeedingCounter
{
  seedingCounter = 0;
  return self;
}

- (int)incSeedingCounter
{
  seedingCounter++;
  return seedingCounter;
}

- (int)incAge
{
  age++;
  return age;
}

- burn
{
  [species fireAtX: x Y: y theTree: self];
  return self;
}

- fireWithHeat: (int)theHeat
{
  totalHeat += theHeat;

  if ([species igniteWithHeat: totalHeat AtAge: age])
    [self burn];
  return self;
}

- (void)step
{
  totalHeat = 0;
  [species step: self];
  //  return self;
}

- drawSelfOn: (id <Raster>)r
{
  if (((Species *)species)->showAgeLevel)
    [r drawPointX: x Y: y Color: ([species getLevelAtAge: age] + 25)];
  else 
    [r drawPointX: x Y: y Color: ((Species *)species)->color];

  return self;
}

- (int)getSpeciesIdentifier
{
  return ((Species *)species)->color;
}

@end
