#import <objectbase.h>
#import "SeedSpace.h"
#import <gui.h>

@interface Species: SwarmObject
{
@public
   
//              Mortality
//-----------------------------------

  //The flattened array is necessary because we do not yet have a 
  //mechanism for loading arrays.
  int ageLevel0;
  int ageLevel1;
  int ageLevel2;
  int ageLevel3;
  int ageLevel4;

  int ageLevels[5];

//              Disturbance
//-----------------------------------

  int resistance0;
  int resistance1;
  int resistance2;

  int resistance[3];

  int heat0;
  int heat1;
  int heat2;

  int heat[3];

//              Growth
//-----------------------------------

  int canopyStructure;

//              Fecundity
//-----------------------------------

  double seedMortalityRate;
  int seedPeriodicity;
  int seedsPerSquare;
  int seedingRadius;
  int shadeTolerance;
  id seedSpace;

//              Location
//-----------------------------------

  int worldSize;
  id forest;
  id youngForest;
  id modelSwarm;


//              Population
//-----------------------------------

  int initialPopulation;  // Both mature and young forest...
  int numberOfTrees;      // Only mature adults.
  int totalNumberOfTrees; // Used to calculate relative proportion...
 
//           Visualization
//-----------------------------------

  char *colorName;
  char *speciesName;

  int showAgeLevel;
  Color color;
}

//This method packs all the arrays from the externally initialised variables.
- packArrays;

- setColorMapEntry: (int)aColor;
- setYoungForest: aYoungForest;
- setForest: aForest;
- setWorldSize: (int)aSize;
- setModelSwarm: aSwarm;
- createEnd;
- showAgeLevel;
- showSpecies;
- (int) ageOrSpecies;
- (char *)getSpeciesName;
- (char *)getColorName;
- (int)getInitialPopulation;
- (int)getColor;
- (unsigned)getCount;
- setTotalNumberOfTrees: (int) aTotal;
- (int)stillActive;
- (double)getRelativeProportion;
- incrementPopulation;
- getSeedSpace;
- (int)getCanopyStructure;
- (int)getLevelAtAge: (int)theAge;
- (int) getAgeLevel: (int) anAgeLevel;
- (int) getSeedPeriodicity;
- (int) getHeatAtAge: (int) theAge;
- (int) getPotencyAtX: (int) theX Y: (int) theY;
- seed: aTree;
- step: aTree;
- fireAtX: (int)theX Y: (int)theY theTree: aTree;
- (int)igniteWithHeat: (int)theHeat AtAge: (int)theAge;
- destroySeedsAtX: (int)theX Y: (int)theY;
@end
















