#import "ForestModelSwarm.h"
#import "YoungForest.h"
#import "MatureForest.h"
#import "Spring.h"
#import "Fire.h"
#import "Tree.h"
#import "Species.h"
#import <random.h>
#import <simtools.h> // UName, ObjectLoader

@implementation ForestModelSwarm

- (int)getSpeciesNumber
{
  return speciesNumber ;
}

- getSpeciesList
{
  return speciesList ;
}

- (int) getWorldSize
{
  return worldSize ;
}

- getTheForest
{
  return theForest ;
}

- getTheYoungForest
{
  return theYoungForest ;
}

- getTheFireSpace
{
  return theFireSpace ;
}

+ createBegin: aZone
{
  ForestModelSwarm * obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];

  obj->speciesNumber = 8 ;
  obj->worldSize = 100;
  obj->freqLStrikes = 3;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "freqLStrikes"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "speciesNumber"
				    inClass: [self class]]];
  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

- createEnd
{
  return [super createEnd];
}

- populateWithSpecies: aSpecies
{
  int i, aNumber ;

  aNumber = [aSpecies getInitialPopulation] ;

  for (i = 0; i < aNumber; i++)
    {
      id aTree;
      int age ;
      
      aTree = [Tree createBegin: [self getZone]];
      [aTree setSpecies: aSpecies] ;
      aTree = [aTree createEnd];
      
      //    age = [uniformRandom rMax: ([aSpecies getAgeLevel: 4] + 1)] ;
      age = [uniformIntRand getIntegerWithMin: 0 withMax: [aSpecies getAgeLevel: 4]] ;
      
      [aTree setAge: age] ;
      
      if(age > [aSpecies getAgeLevel: 2])
        [aTree setSeedingCounter: 
                 (age - ([aSpecies getAgeLevel: 2] + 1)) 
               % [aSpecies getSeedPeriodicity]];
      
      if (age <= [aSpecies getAgeLevel: 1])
        [theYoungForest addTree: aTree];
      else
        [theForest addTree: aTree];
    }
  
  return self ;
}

- buildObjects
{
  int i ;
  id theFileNamer ;
  
  [super buildObjects];
  
  theForest = [MatureForest createBegin: [self getZone]];
  [theForest setWorldSize: worldSize] ;
  theForest = [theForest createEnd] ;

  theYoungForest = [YoungForest createBegin: [self getZone]];
  [theYoungForest setForest: theForest] ; 
  [theYoungForest setWorldSize: worldSize] ;
  theYoungForest = [theYoungForest createEnd] ;

  theFireSpace = [Discrete2d createBegin: [self getZone]] ;
  [theFireSpace setSizeX: worldSize Y: worldSize] ;
  theFireSpace = [theFireSpace createEnd] ;

  fire = [Fire create: [self getZone]] ;
  [fire setWorldSize: worldSize] ;
  [fire setForest: theForest] ; 
  [fire setFreqLStrikes: freqLStrikes] ;

  theFileNamer = [UName create: [self getZone] setBaseName: "species"];
  speciesList = [List create: [self getZone]];

  for(i = 0 ; i < speciesNumber ; i++){
    id aSpecies ;

    aSpecies = [Species createBegin: [self getZone]] ;
    [ObjectLoader load: aSpecies
                  fromAppDataFileNamed: [theFileNamer getNewName]];
    [aSpecies packArrays] ;
    [aSpecies setForest: theForest] ;
    [aSpecies setModelSwarm: self] ;
    [aSpecies setYoungForest: theYoungForest] ;
    [aSpecies setWorldSize: worldSize] ;
    aSpecies = [aSpecies createEnd] ;

    [self populateWithSpecies: aSpecies] ;

    [speciesList addLast: aSpecies] ;
  }

  spring = [Spring createBegin: [self getZone]] ;
  [spring setWorldSize: worldSize] ;
  [spring setForest: theForest] ; 
  [spring setYoungForest: theYoungForest] ;
  [spring createEndWith: speciesList] ;

  [theFileNamer drop] ;

  return self;
}

-buildActions {
  int i ;

  [super buildActions];
  
  modelActions = [ActionGroup create: [self getZone]];

  [modelActions createActionTo:      theFireSpace  
                       message: M(fastFillWithValue:) : (id) 0];

  [modelActions createActionTo:      fire             message: M(step)];
  [modelActions createActionTo:      spring           message: M(step)];

  for(i = 0 ; i < speciesNumber ; i++)
    [modelActions createActionTo: 
      [[speciesList atOffset: i] getSeedSpace]  message: M(stepRule)];

  [modelActions createActionTo:      theForest        message: M(step)];
  [modelActions createActionTo:      theYoungForest   message: M(step)];

  [modelActions createActionTo:      self   message: M(step)];

  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

-fireAtX: (int) theX Y: (int) theY {
  int i ;

  for(i = 0 ; i < speciesNumber ; i++)
    [[speciesList atOffset: i] destroySeedsAtX: theX Y: theY] ;
  
  [theFireSpace putValue: 1 atX: theX Y: theY] ;
  
  return self ;
}

-(void)step {
  int total, i ;

  total = 0 ;

  for(i = 0 ; i < speciesNumber ; i++) 
    total += [[speciesList atOffset: i] getCount] ;

  for(i = 0 ; i < speciesNumber ; i++) 
    [[speciesList atOffset: i] setTotalNumberOfTrees: total] ;

  //  return self ;
}

@end



