// Swarm library. Copyright (C) 1996 Santa Fe Institute. This library is
//   distributed without any warranty; without even the implied warranty
//   of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Object to shuffle Swarm List in place
// (From Knuth vol 2)

// Author: Sven Thommesen <sthomme@humsci.auburn.edu>
// Date: July 30, 1997
// Reworked from Ted Belding's Shuffler

#import "ListShuffler.h"
#import <simtools.h>

@implementation ListShuffler

-setUniformRandom: (id) rnd {

  if (uniformRandom != nil) 
  [InvalidArgument raiseEvent: 
  "ListShuffler: You can only set the UniformUnsigned object once\n"];
  
  uniformRandom = rnd;

  if (![uniformRandom respondsTo: M(getUnsignedWithMin:withMax:)])
  [InvalidArgument raiseEvent:
  "ListShuffler: need a UniformUnsigned distribution object!\n"];

  return self;
}

-createEnd {

  if (uniformRandom == nil) 

  // (a) Use the default system object:
  uniformRandom = uniformUnsRand;	// defined in simtools/global.h

  // (b) Complain and abort:
  // [InvalidCombination raiseEvent: 
  // "ListShuffler was created without a random number generator.\n"];

  return self;
}

+create: aZone setUniformRandom: dist {
   ListShuffler * shuffler;

   shuffler = [ListShuffler createBegin: aZone];
   [shuffler setUniformRandom: dist];
   shuffler = [shuffler createEnd];

   return shuffler;
}

-shufflePartialList: list Num: (int) num {
  int j,k;

  j = num;

  // printf("Shuffling a list with %d elements:\n", j);

  while (j > 1) {

    // Get a k that's uniform over [0,j-1]:
    k = [uniformRandom getUnsignedWithMin: 0 withMax: j-1];

    j--;

    // Laborious, explicit way:
    // temp = [list atOffset: k];
    // [list atOffset: k put: [list atOffset: j]];
    // [list atOffset: j put: temp];

    // New way:
    // (This clever, convoluted, and inscrutable hack
    // depends on objectiveC keeping track of intermediate values!)
    [list atOffset: j put: [list atOffset: k put: [list atOffset: j]]];

    // printf("  Swapped element %d with element %d\n", j, k);

  }

  return list;
}

-shuffleWholeList: list {
  int j,k;

  j = [list getCount];

  // printf("Shuffling a list with %d elements:\n", j);

  if (j == 0) return list;

  while (j > 1) {

    // Get a k that's uniform over [0,j-1]:
    k = [uniformRandom getUnsignedWithMin: 0 withMax: j-1];

    j--;

    [list atOffset: j put: [list atOffset: k put: [list atOffset: j]]];

    // printf("  Swapped element %d with element %d\n", j, k);

  }

  return list;
}

@end
