// Swarm library. Copyright (C) 1996 Santa Fe Institute. This library is
//   distributed without any warranty; without even the implied warranty
//   of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Author: Sven Thommesen <sthomme@humsci.auburn.edu>
// Date: July 30, 1997

// Object to shuffle a Swarm List in place
// (From Knuth vol 2)
// Reworked from Ted Belding's Shuffler.

#import <swarmobject.h>
#import <simtools.h>

@interface ListShuffler: SwarmObject {

   id uniformRandom;		// uniform unsigned distribution object

}

-setUniformRandom: (id) rnd;
-createEnd;

+create: aZone setUniformRandom: dist;

-shufflePartialList: list Num: (int) num;
-shuffleWholeList: list;

@end

