//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//Here's the overseer of the entire graphical simulation

import swarm.Globals;
import swarm.objectbase.Swarm;
import swarm.activity.Activity;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.simtoolsgui.GUISwarmImpl;
import swarm.space.Object2dDisplay;
import swarm.space.Object2dDisplayImpl;
import swarm.gui.ZoomRasterImpl;
import swarm.gui.ZoomRaster;
import swarm.gui.Colormap;
import swarm.gui.ColormapImpl;
import swarm.defobj.Zone;
import swarm.objectbase.VarProbe;
import swarm.objectbase.MessageProbe;
import swarm.objectbase.EmptyProbeMapImpl;
import swarm.analysis.EZGraph;
import swarm.analysis.EZGraphImpl;
import swarm.Selector;

public class Overlord extends GUISwarmImpl {
	public Object2dDisplay displayer; //the first three relate to the display
	public ZoomRaster raster;
	public Colormap cmap;	//this one's for assigning colors
	public Landscape modelswarm; //the modelswarm, in which agents are created
	public Schedule dispSchedule; //schedules updates to the display
	public EZGraph animalsGraph; //we'll use this to graph total living animals 							//over time
	public EZGraph lifeDeathGraph; //this graph will show life/death info
	public static SimulationState state; //the current state of the simulation is 						//viewed and edited through this reference

	public Overlord (Zone thZone) {
		super (thZone);  //thZone is the memory zone in which this class is found
				//any swarms beneath it will be found in its memory zone

		Landscape.isGraphical = true;

		modelswarm = new Landscape (getZone ());//create our							//modelswarm in the Overlord's memory zone

		modelswarm.makeWorld (20, 20, Master.xRegions, Master.yRegions);
	}

	//build all the graphical and interface objects, and tell modelswarm to build 	//its objects
	public Object buildObjects () {
		super.buildObjects ();
		modelswarm.buildObjects ();
		

		//this stuff is fairly complicated, but it's just your typical GUI 			//set up
		Globals.env.createArchivedProbeDisplay (state, "Simulation State");
		Globals.env.createArchivedProbeDisplay (modelswarm.world, "Regions");

		cmap = new ColormapImpl (getZone ());
		//sets up a series of shades of green to stand for different amounts of 		//food on the food map
		for (int i = 2; i < 4 * Landscape.MAXFOOD; i++)
			cmap.setColor$ToRed$Green$Blue
				((byte) i, 0, i / (4.0 * Landscape.MAXFOOD - 1), 0);
		cmap.setColor$ToName ((byte) 0, "white");
		cmap.setColor$ToName ((byte) 1, "red");

		//these are the colors of the animals
		cmap.setColor$ToName ((byte) 60, "orange");	//Human
		cmap.setColor$ToName ((byte) 61, "yellow");	//Monkey
		cmap.setColor$ToName ((byte) 62, "violet");	//Horse
		cmap.setColor$ToName ((byte) 63, "blue");		//Koala
		cmap.setColor$ToName ((byte) 64, "slate grey");	//Cow

		//the ZoomRaster brings all the graphing stuff together
		raster = new ZoomRasterImpl (getZone (), "raster");
		raster.setColormap (cmap);
		raster.setZoomFactor (4);
		raster.setWidth$Height (modelswarm.getWorld ().getSizeX (),
						modelswarm.getWorld ().getSizeY ());
		raster.setWindowTitle ("The Space");
		raster.pack ();
		raster.erase ();

		//the displayer object tells swarm to draw all the Animals on the grid 			//with the drawMe () function
		try {
			displayer = new Object2dDisplayImpl (getZone (), raster, 
					modelswarm.getWorld (), 
					new Selector (Class.forName ("Animal"), 						"drawMe", false));

			raster.setButton$Client$Message (3, displayer, 
					new Selector (displayer.getClass (), 
					"makeProbeAtX$Y", true));
		}
		catch (Exception e) {
			e.printStackTrace (System.err);
			System.exit (1);
		}

		//and now let's set up the graphs
		animalsGraph = new EZGraphImpl (getZone (), "Animals vs. Time", 						"time", "total animals", "animalsGraph");

		lifeDeathGraph = new EZGraphImpl (getZone (), "Life/Death Info vs. Time", 				"time", "Info", "lifeDeathGraph");
		try {
			animalsGraph.createSequence$withFeedFrom$andSelector 
				("Total_Animals", state, new Selector
				(Class.forName ("SimulationState"), "getTotalAnimals", 													false));

			animalsGraph.createSequence$withFeedFrom$andSelector 
				("Total_Humans", state, new Selector
				(Class.forName ("SimulationState"), "getTotalHumans", 													false));

			animalsGraph.createSequence$withFeedFrom$andSelector 
				("Total_Monkeys", state, new Selector
				(Class.forName ("SimulationState"), "getTotalMonkeys", 													false));

			animalsGraph.createSequence$withFeedFrom$andSelector 
				("Total_Horses", state, new Selector
				(Class.forName ("SimulationState"), "getTotalHorses", 													false));

			animalsGraph.createSequence$withFeedFrom$andSelector 
				("Total_Cows", state, new Selector
				(Class.forName ("SimulationState"), "getTotalCows", false));

			lifeDeathGraph.createSequence$withFeedFrom$andSelector 
				("Birth_Count", state, new Selector
				(Class.forName ("SimulationState"), "getBirthCount", false));

			lifeDeathGraph.createSequence$withFeedFrom$andSelector 
				("Death_Count", state, new Selector
				(Class.forName ("SimulationState"), "getDeathCount", false));

			lifeDeathGraph.createSequence$withFeedFrom$andSelector 
				("Num_Starved", state, new Selector
				(Class.forName ("SimulationState"), "getNumStarved", false));

			lifeDeathGraph.createSequence$withFeedFrom$andSelector 
				("Num_DiedOldAge", state, new Selector
				(Class.forName ("SimulationState"), "getNumOldAged", false));


		} catch (Exception e) {
			System.err.println ("Problems with your graphs");
		}

		return this;
	}

	//sets up the our display schedule; modelswarm doesn't really use buildActions
	public Object buildActions () {
		super.buildActions ();
		modelswarm.buildActions ();

		dispSchedule = new ScheduleImpl (getZone (), 1);
		
		try {
			dispSchedule.at$createActionTo$message (0, this,
				new Selector (getClass (), "showDisplay", false));
		}
		catch (Exception e) {
			e.printStackTrace (System.err);
			System.exit (1);
		}
		
		return this;
	}

	//activate our class and our schedule, and tell modelswarm to activate all the 	//agents
	public Activity activateIn (Swarm papaswarm) {
		super.activateIn (papaswarm);
		modelswarm.activateIn (this);
		dispSchedule.activateIn (this);
	
		return getActivity ();
	}

	//the function the display schedule calls, it updates the display, tells the 	//modelswarm to draw food the first time this timestep it is asked to do so, 	//updates Landscape's Time and Total_Animal fields, etc
	public void showDisplay () {
		raster.erase ();

		state.Time++;
		state.Total_Animals = 
			modelswarm.allAnimals.size ();
		modelswarm.foodDrawn = false; //so when the first agent tells it to draw
						//food, it will
		
		modelswarm.getWorld ().updateFoodAndDeath ();

		if ((modelswarm.allAnimals.size ()) == 0)
			(getControlPanel ()).setStateStopped (); //stop it if 
									//everyone's dead
		else {
			(getActionCache ()).doTkEvents ();
			Globals.env.probeDisplayManager.update ();
			if (state.displayIt) {
				displayer.display ();
				raster.drawSelf ();
			}
			if (state.animalGraphIt)
				if (animalsGraph != null)
					animalsGraph.step ();

			if (state.lifeDeathGraphIt)
				if (lifeDeathGraph != null)
					lifeDeathGraph.step ();
		}
	}
	
	//here we run the actual program
	//we initialize swarm, create the overswarm, tell it to build its actions and 	//objects, activate it, and we're off
	public static void runGraphicSimulation () {
		Overlord overswarm = new Overlord (Globals.env.globalZone);

		overswarm.buildObjects ();
		overswarm.buildActions ();

		overswarm.activateIn (null);

		overswarm.go ();
	}
}