//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//Originally, Overlord and Optimizer were written separately so that a user could run //Overlord to run a single simulation with graphics or Optimizer to run a series of //simulations without graphics.  This new class goes above those two classes in the //hierarchy.  It calls one or the other, depending on which the user wishes to use.  //Thus, the user no long need worry about running the correct program or making sure //the most recent changes to Overlord or Optimizer have been compiled.

import swarm.Globals;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.FileReader;

public class Master {
	
	//the number of foodspace regions that will be created in the x and y 	//directions
	public static int xRegions;
	public static int yRegions;

	//sets static environmental variables in several classes by reading values from 	//a file
	public static void setEnvironmentalValues () {
		try {
			BufferedReader in = new BufferedReader (new FileReader 										("Data\\EnvironmentalData.txt"));
		
			in.readLine ();
			Landscape.NUMCOWS = Integer.parseInt (in.readLine ());

			in.readLine ();
			Landscape.NUMKOALAS = Integer.parseInt (in.readLine ());

			in.readLine ();
			Landscape.NUMHORSES = Integer.parseInt (in.readLine ());

			in.readLine ();
			Landscape.NUMMONKEYS = Integer.parseInt (in.readLine ());

			in.readLine ();
			Landscape.NUMHUMANS = Integer.parseInt (in.readLine ());

			in.readLine ();
			Space2d.TIME_BETWEEN_FOOD = Integer.parseInt (in.readLine ());

			in.readLine ();
			Space2d.SEASON_LENGTH = Integer.parseInt (in.readLine ());

			in.readLine ();
			Space2d.MAX_FOOD_DUMP = (int) (Space2d.TIME_BETWEEN_FOOD * 25 * 									Double.parseDouble (in.readLine ()));

			in.readLine ();
			xRegions = Integer.parseInt (in.readLine ());

			in.readLine ();
			yRegions = Integer.parseInt (in.readLine ());
		}
		catch (Exception e) {
			System.err.println ("There was an error in reading from the file EnvironmentalData.txt");
			System.exit (1);
		}
	}



	public static void main (String[] args) {
		Globals.env.initSwarm ("2dFeederOptimization", "1.5", 												"MisterDrgn@aol.com", args);
			
		int runType = 0; //1 for Overlord, 2 for Optimization
		//and the Object used to read input from the console
		BufferedReader userIn = new BufferedReader 
							(new InputStreamReader (System.in));
		String input; //and the String to hold input

		setEnvironmentalValues ();

		while ((runType != 1) && (runType != 2)) {
			System.out.print ("Choose a run type: 1 for a run in graphics mode, 2 for a run in optimization mode:  ");

			//read a line from the user
			try {
				input = userIn.readLine ();
			}
			catch (Exception e) {
				input = "0";
			}
	
			//change the line into a number
			try {
				runType = Integer.parseInt (input);
			}
			catch (Exception e) {
				System.err.println ("You must enter a number.");
			}

			//error message if we aren't within the bounds
			if (!((runType == 1) || (runType == 2)))
				System.err.println ("The number entered must be 1 or 2");
		}
		try {
			userIn.close ();
		}
		catch (Exception e) {
			System.err.println ("Problem closing the input reader.");
		}

		//now run the appropriate simulation
		if (runType == 1)
			Overlord.runGraphicSimulation ();

		if (runType == 2)
			Optimizer.runOptimization ();
	}
}
			

			