//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//This is the alternate modelswarm class, for use with the Optimizer

import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.activity.Activity;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.defobj.Zone;
import swarm.Globals;
import swarm.gui.Raster;

import java.util.LinkedList;
import java.util.List;

import java.io.FileReader;
import java.io.BufferedReader;

import java.lang.reflect.Field;

import java.lang.IllegalArgumentException;

public class Landscape extends SwarmImpl {
	Space2d world; //the 2d world in which food is found and in which agents live
	private SimulationState state; //holds info on the state of the simulation
	LinkedList allAnimals; //all the Animals are held within this list
	boolean foodDrawn; //keeps track of whether the food has yet been drawn in a 					//given time step

	//tells us whether we're in graphical mode or optimization mode (using Overlord 	//or Optimizer)
	public static boolean isGraphical;

	public final static int MAXFOOD = 8; //the most food you can have in one place

	//number of starting animals of each type
	//we'll leave these in all-caps even tho they are no longer constants because 	//they are given a value only once, when the program is first run and these 	//values are read from the file EnvironmentalData.txt
	public static int NUMCOWS;
	public static int NUMKOALAS;
	public static int NUMHORSES;
	public static int NUMMONKEYS;
	public static int NUMHUMANS;

	public final static int NUM_ANIMALS = 5; //number of animals types

	//this array is used when we obtain each animal's stats from its text file
	private final static String[] animalNames = new String[] 
					{"Cow", "Koala", "Horse", "Monkey", "Human"};
	//our constructor
	public Landscape (Zone thZone) {

		super (thZone);

		state = new SimulationState (getZone ());
		
		allAnimals = new LinkedList ();
	}

	//creates our Space2d Object
	public void makeWorld (int xsiz, int ysiz, int xnum, int ynum) {
		//xsiz and ysiz are only the dimenions of individual regions 		//xnum and ynum refer to the numbers of regions in the x and y dimensions
		world = new Space2d (getZone (), xsiz, ysiz, xnum, ynum);
	}

	public Space2d getWorld () {
		return world;
	}

	public List getAllAnimals () {
		return allAnimals;
	}

	//here we'll make all our agents
	public Object buildObjects () {
		super.buildObjects ();
		
		Cow newCow;
		Koala newKoala;
		Horse newHorse;
		Monkey newMonkey;
		Human newHuman;

		boolean done;
		int newx = 0, newy = 0;
		
		getAnimalStats ();

		//create the necessary number of Animals of each type, randomly place 			//them within the 2d space, and add them to the allAnimals list
		for (int i = 0; i <= NUMCOWS - 1; i++) {
			done = false;
			while (!done) {
				newx = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeX () - 1);

				newy = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeY () - 1);

				if (world.getObjectAtX$Y (newx, newy) == null)
					done = true;
			}
			newCow = new Cow (getZone (), this, newx, newy);
			allAnimals.add (newCow);
		}

		for (int i = 0; i <= NUMKOALAS - 1; i++) {
			done = false;
			while (!done) {
				newx = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeX () - 1);

				newy = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeY () - 1);

				if (world.getObjectAtX$Y (newx, newy) == null)
					done = true;
			}
			newKoala = new Koala (getZone (), this, newx, newy);
			allAnimals.add (newKoala);
		}
			
		for (int i = 0; i <= NUMHORSES - 1; i++) {
			done = false;
			while (!done) {
				newx = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeX () - 1);

				newy = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeY () - 1);

				if (world.getObjectAtX$Y (newx, newy) == null)
					done = true;
			}
			newHorse = new Horse (getZone (), this, newx, newy);
			allAnimals.add (newHorse);
		}

		for (int i = 0; i <= NUMMONKEYS - 1; i++) {
			done = false;
			while (!done) {
				newx = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeX () - 1);

				newy = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeY () - 1);

				if (world.getObjectAtX$Y (newx, newy) == null)
					done = true;
			}
			newMonkey = new Monkey (getZone (), this, newx, newy);
			allAnimals.add (newMonkey);
		}

		for (int i = 0; i <= NUMHUMANS - 1; i++) {
			done = false;
			while (!done) {
				newx = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeX () - 1);

				newy = Globals.env.uniformIntRand.getIntegerWithMin$withMax 									(0, world.getSizeY () - 1);

				if (world.getObjectAtX$Y (newx, newy) == null)
					done = true;
			}
			newHuman = new Human (getZone (), this, newx, newy);
			allAnimals.add (newHuman);
		}

		state.Total_Animals = allAnimals.size ();		

		return this;
	}

	//obtains each animal's stats from its text file
	private void getAnimalStats () {
		Class thClass;
		String thName;
	
		for (int i = 0; i <= animalNames.length - 1; i++) {
			thName = animalNames[i];

			//now read from a file
			try {
				thClass = Class.forName (thName);

				BufferedReader in = new BufferedReader 
					(new FileReader ("Data\\" + thName + "Data.txt"));

				//now set the static fields for each animal's stats within 					//that animal's class, reading the info from the animal's 					//data file
				in.readLine (); //skip over irrelevant text
				thClass.getDeclaredField ("SPEED").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("SIGHT").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("SIZE"). setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("MAXEN").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("BABYAGE").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("OLDAGE").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("NUMBABIES").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("ENTOMOVE").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("ENFROMFOOD").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("ENFORBABY").setInt 
						(null, Integer.parseInt (in.readLine ()));

				in.readLine ();
				thClass.getField ("COLOR").setByte 
						(null, Byte.parseByte (in.readLine ()));

				in.close ();
			}
			catch (IllegalArgumentException e) {
				System.err.println 
					("One of the values entered in the data file for the " 								+ thName + " class is illegal.");
				System.exit (1);
			}
			catch (Exception e) {
				System.err.println 
					("There was an error reading the data file for the " + 										thName + " class.");
				System.exit (1);
			}
		}
	}


	//modelswarm and its agents don't really need to build actions outside of 	//the constructors, so all we do with this is send it to the modelswarm's 	//superclass
	public Object buildActions () {
		super.buildActions ();

		return this;
	}		

	//activate the world and all the Animals except for the templates
	public Activity activateIn (Swarm papaswarm) {
		super.activateIn (papaswarm);
		//reaper.activateIn (this);   we're not using this just now 
		world.activateIn (this);
	
		for (int i = 0; i <= allAnimals.size () - 1; i++)
			((Animal) allAnimals.get (i)).activateIn (this);

		return getActivity ();
	}

	//the modelswarm will draw the food on the display only the first time it 	//receives this command each time step (this happens when the first Animal's 	//drawMe function is called
	public void drawFood (Raster r) {
		if (foodDrawn == false) {
			foodDrawn = true;

			for (int i = 0; i <= world.getSizeX () - 1; i++)
				for (int j = 0; j <= world.getSizeY () - 1; j++)
					r.drawPointX$Y$Color (i, j, 
						(byte) world.getFood (i, j));
		}
	}

	//each time a new Animal is created, it must be added to the LinkedList of 	//animals, and it must be activated
	public void addBaby (Animal baby, int x, int y) {
		allAnimals.add (baby);
		baby.activateIn (this);
	}
}
