//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//This is a relatively simple animal which wanders the 2d space, always moving //towards the most tempting immediate morsel.

import swarm.Globals;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.defobj.Zone;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.activity.Activity;
import swarm.Selector;

public class Cow extends Animal {

	Schedule schedule; //we use the schedule object to schedule the actions

	//the three following variables are all found in Animal, Cow's parent class, 	//but they have been added to this class so that they will show up whenever the 	//user probes an animal of this type
	int age;
	int energy;
	boolean alive;

	//Cow Stats, see the Animal class for info on what each stat means
	//If you wish to modify these stats, go to Data\CowData.txt
	//As these values will be modified only once, at the beginning of a simulation, 	//we will keep them in all-caps, as though they were constants
	public static int SPEED;
	public static int SIGHT;
	public static int SIZE;
	public static int MAXEN;
	public static int BABYAGE;
	public static int OLDAGE;
	public static int NUMBABIES;
	public static int ENTOMOVE;
	public static int ENFROMFOOD;
	public static int ENFORBABY;
	public static byte COLOR; 

	//the constructor begins by sending info on all these stats to the parent 		//class, Animal
	public Cow (Zone thZone, Landscape thWorld, int x, int y) {
		super (thZone, thWorld, SPEED, SIGHT, SIZE, x, y, COLOR, MAXEN, BABYAGE, 					OLDAGE, NUMBABIES, ENTOMOVE, ENFROMFOOD, ENFORBABY);

		buildActions (thZone); //set up our schedule
	}

	//here's our schedule; the frequency of the schedule's repeats depends upon the 	//speed of the animal
	public Object buildActions (Zone thZone) {
		schedule = new ScheduleImpl (thZone, speed);
		try {
			schedule.at$createActionTo$message (0, this, 
						new Selector (getClass (), "takeStep", false));
		}  
		catch (Exception e) {
			e.printStackTrace (System.err);
			System.exit (1);
		}

		return this;
	}

	//each time it takes a turn, assuming it is still alive, the animal updates 	//age, energy, and alive; moves to the best food space (because of the cow's 	//limited sight, this is the best adjacent space); eats the food; and grows
	public void takeStep () {
		if (super.alive) {
			this.age = super.age;
			this.energy = super.energy;
			this.alive = true;

			moveToBestFood ();
			eatFood ();
			grow ();
		} else
			this.alive = false;
	}

	//here we activate the animal and its schedule
	public Activity activateIn (Swarm papaswarm) {
		super.activateIn (papaswarm);
		schedule.activateIn (this);
		return getActivity ();
	}
}